/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.automation.scripting.internals;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.automation.scripting.api.AutomationScriptingService;
import org.nuxeo.automation.scripting.internals.AutomationScriptingParamsInjector;
import org.nuxeo.automation.scripting.internals.AutomationScriptingRegistry;
import org.nuxeo.automation.scripting.internals.AutomationScriptingServiceImpl;
import org.nuxeo.automation.scripting.internals.ClassFilterDescriptor;
import org.nuxeo.automation.scripting.internals.ScriptingOperationDescriptor;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.services.config.ConfigurationService;

public class AutomationScriptingComponent
extends DefaultComponent {
    private static final Log log = LogFactory.getLog(AutomationScriptingComponent.class);
    protected static final String XP_OPERATION = "operation";
    protected static final String XP_CLASSFILTER = "classFilter";
    protected final AutomationScriptingServiceImpl service = new AutomationScriptingServiceImpl();
    protected final AutomationScriptingRegistry registry = new AutomationScriptingRegistry();
    protected final List<ClassFilterDescriptor> classFilterDescriptors = new ArrayList<ClassFilterDescriptor>();

    public void activate(ComponentContext context) {
        this.registry.automation = (AutomationService)Framework.getService(AutomationService.class);
        this.registry.scripting = this.service;
    }

    public void start(ComponentContext context) {
        boolean inlinedContext = ((ConfigurationService)Framework.getService(ConfigurationService.class)).isBooleanTrue("nuxeo.automation.scripting.inline-context-in-params");
        this.service.paramsInjector = AutomationScriptingParamsInjector.newInstance(inlinedContext);
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (XP_OPERATION.equals(extensionPoint)) {
            ScriptingOperationDescriptor desc = (ScriptingOperationDescriptor)contribution;
            desc.setContributingComponent(contributor.getName().toString());
            this.registry.addContribution(desc);
        } else if (XP_CLASSFILTER.equals(extensionPoint)) {
            this.registerClassFilter((ClassFilterDescriptor)contribution);
        } else {
            log.error((Object)("Unknown extension point " + extensionPoint));
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (XP_OPERATION.equals(extensionPoint)) {
            this.registry.removeContribution((ScriptingOperationDescriptor)contribution);
        } else if (XP_CLASSFILTER.equals(extensionPoint)) {
            this.unregisterClassFilter((ClassFilterDescriptor)contribution);
        } else {
            log.error((Object)("Unknown extension point " + extensionPoint));
        }
    }

    protected void registerClassFilter(ClassFilterDescriptor desc) {
        this.classFilterDescriptors.add(desc);
        this.recomputeClassFilters();
    }

    protected void unregisterClassFilter(ClassFilterDescriptor desc) {
        this.classFilterDescriptors.remove(desc);
        this.recomputeClassFilters();
    }

    protected void recomputeClassFilters() {
        HashSet<String> allowedClassNames = new HashSet<String>();
        for (ClassFilterDescriptor desc : this.classFilterDescriptors) {
            if (desc.deny.contains("*")) {
                allowedClassNames.clear();
                allowedClassNames.addAll(desc.allow);
                continue;
            }
            allowedClassNames.addAll(desc.allow);
            allowedClassNames.removeAll(desc.deny);
        }
        this.service.allowedClassNames.clear();
        this.service.allowedClassNames.addAll(allowedClassNames);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(AutomationScriptingService.class)) {
            return adapter.cast(this.service);
        }
        return (T)super.getAdapter(adapter);
    }
}

