/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.impl.task.commands;

import java.io.File;
import java.util.Map;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.ValidationStatus;
import org.nuxeo.connect.update.impl.task.AbstractCommand;
import org.nuxeo.connect.update.impl.task.Command;
import org.nuxeo.connect.update.impl.task.commands.Copy;
import org.nuxeo.connect.update.impl.xml.XmlWriter;
import org.nuxeo.connect.update.task.Task;
import org.nuxeo.connect.update.util.FileRef;
import org.nuxeo.connect.update.util.IOUtils;
import org.w3c.dom.Element;

public class Delete
extends AbstractCommand {
    public static final String ID = "delete";
    protected File file;
    protected String md5;
    protected boolean onExit;

    public Delete() {
        super(ID);
    }

    public Delete(File file, String md5) {
        this(file, md5, false);
    }

    public Delete(File file, String md5, boolean onExit) {
        super(ID);
        this.file = file;
        this.md5 = md5;
        this.onExit = onExit;
    }

    @Override
    protected void doValidate(Task task, ValidationStatus status) {
        if (this.file == null) {
            status.addError("Invalid delete syntax: No file specified");
        }
        if (this.file.isDirectory()) {
            status.addError("Cannot delete directories: " + this.file.getName());
        }
    }

    @Override
    protected Command doRun(Task task, Map<String, String> prefs) throws PackageException {
        try {
            if (this.file.isFile()) {
                if (this.md5 != null && !this.md5.equals(IOUtils.createMd5(this.file))) {
                    return null;
                }
                File bak = IOUtils.backup(task.getPackage(), this.file);
                if (this.onExit) {
                    this.file.deleteOnExit();
                } else {
                    this.file.delete();
                }
                return new Copy(bak, this.file, this.md5, false, this.onExit);
            }
            return null;
        }
        catch (Exception e) {
            throw new PackageException("Failed to create backup when deleting: " + this.file.getName());
        }
    }

    @Override
    public void readFrom(Element element) throws PackageException {
        String v = element.getAttribute("file");
        if (v.length() > 0) {
            FileRef ref = FileRef.newFileRef(v);
            ref.fillPatternVariables(this.guardVars);
            this.file = ref.getFile();
            this.guardVars.put("file", this.file);
        }
        if ((v = element.getAttribute("md5")).length() > 0) {
            this.md5 = v;
        }
        if ((v = element.getAttribute("onExit")).length() > 0) {
            this.onExit = Boolean.parseBoolean(v);
        }
    }

    @Override
    public void writeTo(XmlWriter writer) {
        writer.start(ID);
        if (this.file != null) {
            writer.attr("file", this.file.getAbsolutePath());
        }
        if (this.md5 != null) {
            writer.attr("md5", this.md5);
        }
        if (this.onExit) {
            writer.attr("onExit", "true");
        }
        writer.end();
    }
}

