/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.NuxeoValidationState;
import org.nuxeo.connect.update.PackageData;
import org.nuxeo.connect.update.PackageDependency;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.PackageType;
import org.nuxeo.connect.update.ProductionState;
import org.nuxeo.connect.update.Validator;
import org.nuxeo.connect.update.Version;
import org.nuxeo.connect.update.impl.LocalPackageData;
import org.nuxeo.connect.update.impl.UpdateServiceImpl;
import org.nuxeo.connect.update.impl.task.InstallTask;
import org.nuxeo.connect.update.impl.task.UninstallTask;
import org.nuxeo.connect.update.impl.xml.FormsDefinition;
import org.nuxeo.connect.update.impl.xml.PackageDefinitionImpl;
import org.nuxeo.connect.update.impl.xml.TaskDefinitionImpl;
import org.nuxeo.connect.update.model.Form;
import org.nuxeo.connect.update.model.TaskDefinition;
import org.nuxeo.connect.update.task.Task;

public class LocalPackageImpl
implements LocalPackage {
    protected String id;
    protected int state;
    protected LocalPackageData data;
    protected PackageDefinitionImpl def;

    public LocalPackageImpl(File file, int state) throws PackageException {
        this(null, file, state);
    }

    public LocalPackageImpl(ClassLoader parent, File file, int state) throws PackageException {
        this.state = state;
        XMap xmap = UpdateServiceImpl.getXmap();
        if (xmap == null) {
            xmap = UpdateServiceImpl.createXmap();
        }
        try {
            this.data = new LocalPackageData(parent, file);
            FileInputStream in = new FileInputStream(this.data.getManifest());
            this.def = (PackageDefinitionImpl)xmap.load((InputStream)in);
        }
        catch (FileNotFoundException e) {
            throw new PackageException("Invalid package - no package.xml file found in package " + file.getName());
        }
        catch (Exception e) {
            throw new PackageException("Failed to load package.xml descriptor for package " + file.getName(), (Throwable)e);
        }
        this.id = this.def.getId();
    }

    public void setState(int state) {
        this.state = state;
    }

    public PackageData getData() {
        return this.data;
    }

    public File getInstallFile() throws PackageException {
        File file = this.data.getEntry("install.xml");
        return file.isFile() ? file : null;
    }

    public File getUninstallFile() throws PackageException {
        File file = this.data.getEntry("uninstall.xml");
        return file.isFile() ? file : null;
    }

    public String getLicenseType() {
        return this.def.getLicense();
    }

    public String getLicenseUrl() {
        return this.def.getLicenseUrl();
    }

    public String getLicenseContent() throws PackageException {
        File file = this.data.getEntry("license.txt");
        if (file.isFile()) {
            try {
                return FileUtils.readFile((File)file);
            }
            catch (Exception e) {
                throw new PackageException("Failed to read license.txt file for package: " + this.getId());
            }
        }
        return null;
    }

    public String getClassifier() {
        return this.def.getClassifier();
    }

    public String getDescription() {
        return this.def.getDescription();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.def.getName();
    }

    public String getTitle() {
        return this.def.getTitle();
    }

    public int getState() {
        return this.state;
    }

    public String[] getTargetPlatforms() {
        return this.def.getPlatforms();
    }

    public PackageDependency[] getDependencies() {
        return this.def.getDependencies();
    }

    public PackageType getType() {
        return this.def.getType();
    }

    public String getHomePage() {
        return this.def.getHomePage();
    }

    public Version getVersion() {
        return this.def.getVersion();
    }

    public String getVendor() {
        return this.def.getVendor();
    }

    public boolean isLocal() {
        return true;
    }

    protected String getDefaultInstallTaskType() {
        return InstallTask.class.getName();
    }

    protected String getDefaultUninstallTaskType() {
        return UninstallTask.class.getName();
    }

    public Task getInstallTask() throws PackageException {
        if (this.def.getInstaller() == null) {
            this.def.setInstaller(new TaskDefinitionImpl(this.getDefaultInstallTaskType(), false));
        } else if (this.def.getInstaller().getType() == null) {
            this.def.getInstaller().setType(this.getDefaultInstallTaskType());
        }
        return this.getTask(this.def.getInstaller());
    }

    public Task getUninstallTask() throws PackageException {
        if (this.def.getUninstaller() == null) {
            this.def.setUninstaller(new TaskDefinitionImpl(this.getDefaultUninstallTaskType(), false));
        } else if (this.def.getUninstaller().getType() == null) {
            this.def.getUninstaller().setType(this.getDefaultUninstallTaskType());
        }
        return this.getTask(this.def.getUninstaller());
    }

    protected Task getTask(TaskDefinition tdef) throws PackageException {
        Task task = null;
        try {
            task = (Task)this.data.loadClass(tdef.getType()).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new PackageException("Could not instantiate custom task " + tdef.getType() + " for package " + this.getId(), (Throwable)e);
        }
        task.initialize((LocalPackage)this, tdef.getRequireRestart());
        return task;
    }

    public Validator getValidator() throws PackageException {
        if (this.def.getValidator() != null) {
            try {
                return (Validator)this.data.loadClass(this.def.getValidator()).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new PackageException("Could not instantiate custom validator " + this.def.getValidator() + " for package " + this.getId(), (Throwable)e);
            }
        }
        return null;
    }

    public Form[] getForms(String path) throws PackageException {
        File file = this.data.getEntry(path);
        if (file.isFile()) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                FormsDefinition forms = (FormsDefinition)UpdateServiceImpl.getXmap().load((InputStream)in);
                Form[] formArray = forms.getForms();
                return formArray;
            }
            catch (Exception e) {
                throw new PackageException("Failed to load forms file: " + file);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return null;
    }

    public Form[] getValidationForms() throws PackageException {
        return this.getForms("forms/validation.xml");
    }

    public Form[] getInstallForms() throws PackageException {
        return this.getForms("forms/install.xml");
    }

    public Form[] getUninstallForms() throws PackageException {
        return this.getForms("forms/uninstall.xml");
    }

    public String getTermsAndConditionsContent() throws PackageException {
        File file = this.data.getEntry("terms-and-conditions.txt");
        if (file.isFile()) {
            try {
                return FileUtils.readFile((File)file);
            }
            catch (Exception e) {
                throw new PackageException("Failed to read license.txt file for package: " + this.getId());
            }
        }
        return null;
    }

    public boolean requireTermsAndConditionsAcceptance() {
        return this.def.requireTermsAndConditionsAcceptance();
    }

    public ProductionState getProductionState() {
        return this.def.getProductionState();
    }

    public NuxeoValidationState getValidationState() {
        return this.def.getValidationState();
    }

    public boolean isSupported() {
        return this.def.isSupported();
    }

    public boolean supportsHotReload() {
        return this.def.supportsHotReload();
    }
}

