/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.impl.task.commands;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.ValidationStatus;
import org.nuxeo.connect.update.impl.task.UninstallTask;
import org.nuxeo.connect.update.impl.task.commands.AbstractCommand;
import org.nuxeo.connect.update.impl.task.commands.Command;
import org.nuxeo.connect.update.impl.task.commands.CompositeCommand;
import org.nuxeo.connect.update.impl.task.commands.Delete;
import org.nuxeo.connect.update.impl.task.commands.UnAppend;
import org.nuxeo.connect.update.impl.xml.XmlWriter;
import org.nuxeo.connect.update.task.Task;
import org.nuxeo.connect.update.util.FileMatcher;
import org.nuxeo.connect.update.util.FileRef;
import org.nuxeo.connect.update.util.FileVersion;
import org.nuxeo.connect.update.util.IOUtils;
import org.w3c.dom.Element;

public class Copy
extends AbstractCommand {
    protected static final Log log = LogFactory.getLog(Copy.class);
    public static final String ID = "copy";
    protected File file;
    protected File tofile;
    protected boolean overwrite;
    protected String md5;
    protected boolean removeOnExit;
    protected boolean append;
    private boolean overwriteIfNewerVersion;
    private boolean upgradeOnly;

    protected Copy(String id) {
        super(id);
    }

    public Copy() {
        this(ID);
    }

    public Copy(File file, File tofile, String md5, boolean overwrite) {
        this(ID, file, tofile, md5, overwrite, false);
    }

    public Copy(File file, File tofile, String md5, boolean overwrite, boolean removeOnExit) {
        this(ID, file, tofile, md5, overwrite, removeOnExit);
    }

    protected Copy(String id, File file, File tofile, String md5, boolean overwrite, boolean removeOnExit) {
        this(id);
        this.file = file;
        this.tofile = tofile;
        this.md5 = md5;
        this.overwrite = overwrite;
        this.removeOnExit = removeOnExit;
    }

    @Override
    protected Command doRun(Task task, Map<String, String> prefs) throws PackageException {
        if (!this.file.exists()) {
            log.warn((Object)("Can't copy " + this.file + " . File missing."));
            return null;
        }
        return this.doCopy(task, prefs, this.file, this.tofile, this.overwrite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Command doCopy(Task task, Map<String, String> prefs, File fileToCopy, File dst, boolean doOverwrite) throws PackageException {
        String dstmd5;
        File bak = null;
        CompositeCommand rollbackCommand = new CompositeCommand();
        if (fileToCopy.isDirectory()) {
            if (fileToCopy != this.file) {
                dst = new File(dst, fileToCopy.getName());
            }
            dst.mkdirs();
            for (File childFile : fileToCopy.listFiles()) {
                rollbackCommand.addCommand(this.doCopy(task, prefs, childFile, dst, doOverwrite));
            }
            return rollbackCommand;
        }
        if (dst.isDirectory()) {
            dst = new File(dst, fileToCopy.getName());
        }
        try {
            String content;
            FileMatcher filenameMatcher = FileMatcher.getMatcher("{n:.*-}[0-9]+.*\\.jar");
            if (filenameMatcher.match(fileToCopy.getName()) && (this.overwriteIfNewerVersion || this.upgradeOnly)) {
                FileVersion dstVersion = null;
                String filenameWithoutVersion = filenameMatcher.getValue();
                FileMatcher versionMatcher = FileMatcher.getMatcher(filenameWithoutVersion + "{v:[0-9]+.*}\\.jar");
                if (versionMatcher.match(fileToCopy.getName())) {
                    FileVersion fileToCopyVersion = new FileVersion(versionMatcher.getValue());
                    File dir = dst.getParentFile();
                    File[] list = dir.listFiles();
                    if (list != null) {
                        for (File f : list) {
                            if (!versionMatcher.match(f.getName())) continue;
                            dst = f;
                            dstVersion = new FileVersion(versionMatcher.getValue());
                            break;
                        }
                    }
                    if (dstVersion == null) {
                        if (this.upgradeOnly) {
                            return null;
                        }
                    } else if (fileToCopyVersion.greaterThan(dstVersion)) {
                        File oldDst = dst;
                        dst = new File(dst.getParentFile(), fileToCopy.getName());
                        File backup = IOUtils.backup(task.getPackage(), oldDst);
                        rollbackCommand.addCommand(new Copy(backup, oldDst, null, false));
                        if (!ArrayUtils.contains((Object[])FILES_TO_DELETE_ONLY_ON_EXIT, (Object)filenameWithoutVersion)) {
                            oldDst.delete();
                        } else {
                            oldDst.deleteOnExit();
                        }
                    } else if (fileToCopyVersion.isSnapshot() && fileToCopyVersion.equals(dstVersion)) {
                        doOverwrite = true;
                    } else if (!doOverwrite) {
                        log.info((Object)("Ignore " + fileToCopy + " because not newer than " + dstVersion + " and 'overwrite' is set to false."));
                        return null;
                    }
                }
            }
            if (dst.exists()) {
                if (!doOverwrite && !this.append) {
                    throw new PackageException("Copy command has overwrite flag on false but destination file exists: " + dst);
                }
                if (!(task instanceof UninstallTask)) {
                    bak = this.append ? IOUtils.backup(task.getPackage(), fileToCopy) : IOUtils.backup(task.getPackage(), dst);
                }
            } else {
                dst.getParentFile().mkdirs();
            }
            if ((content = this.getContentToCopy(fileToCopy, prefs)) != null) {
                if (this.append && dst.exists()) {
                    RandomAccessFile rfile = new RandomAccessFile(dst, "r");
                    try {
                        rfile.seek(dst.length());
                        if (!"".equals(rfile.readLine())) {
                            content = System.getProperty("line.separator") + content;
                        }
                    }
                    catch (IOException e) {
                        log.error((Object)e);
                    }
                    finally {
                        rfile.close();
                    }
                }
                FileUtils.writeFile((File)dst, (String)content, (boolean)this.append);
            } else {
                File tmp = new File(dst.getPath() + ".tmp");
                FileUtils.copy((File)fileToCopy, (File)tmp);
                if (!tmp.renameTo(dst)) {
                    tmp.delete();
                    FileUtils.copy((File)fileToCopy, (File)dst);
                }
            }
            dstmd5 = IOUtils.createMd5(dst);
        }
        catch (Exception e) {
            throw new PackageException("Failed to copy " + fileToCopy, (Throwable)e);
        }
        if (bak == null) {
            rollbackCommand.addCommand(new Delete(dst, dstmd5, this.removeOnExit));
        } else if (this.append) {
            rollbackCommand.addCommand(new UnAppend(bak, dst));
        } else {
            rollbackCommand.addCommand(new Copy(bak, dst, dstmd5, true));
        }
        return rollbackCommand;
    }

    protected String getContentToCopy(File fileToCopy, Map<String, String> prefs) throws PackageException {
        String deprecatedContent = this.getContentToCopy(prefs);
        if (deprecatedContent != null) {
            return deprecatedContent;
        }
        if (this.append) {
            try {
                return FileUtils.readFile((File)fileToCopy);
            }
            catch (IOException e) {
                throw new PackageException("Couldn't read " + fileToCopy.getName(), (Throwable)e);
            }
        }
        return null;
    }

    @Deprecated
    protected String getContentToCopy(Map<String, String> prefs) throws PackageException {
        return null;
    }

    @Override
    protected void doValidate(Task task, ValidationStatus status) throws PackageException {
        if (this.file == null || this.tofile == null) {
            status.addError("Cannot execute command in installer. Invalid copy syntax: file, dir, tofile or todir was not specified.");
        }
        if (this.tofile.isFile() && !this.overwrite && !this.append) {
            if (this.removeOnExit) {
                status.addError("A restart is needed to perform this operation: cleaning " + this.tofile.getName());
            } else {
                status.addError("Cannot overwrite existing file: " + this.tofile.getName());
            }
        }
        if (this.md5 != null) {
            try {
                if (this.tofile.isFile() && !this.md5.equals(IOUtils.createMd5(this.tofile))) {
                    status.addError("MD5 check failed. File: " + this.tofile + " has changed since its backup");
                }
            }
            catch (Exception e) {
                throw new PackageException((Throwable)e);
            }
        }
    }

    @Override
    public void readFrom(Element element) throws PackageException {
        boolean sourceIsDir = false;
        File dir = null;
        String v = element.getAttribute("dir");
        if (v.length() > 0) {
            dir = new File(v);
        }
        if ((v = element.getAttribute("file")).length() > 0) {
            this.file = dir != null ? new File(dir, v) : new File(v);
            this.guardVars.put("file", this.file);
        } else {
            sourceIsDir = true;
            this.file = dir;
            this.guardVars.put("dir", dir);
        }
        v = element.getAttribute("todir");
        if (v.length() > 0) {
            if (sourceIsDir) {
                this.tofile = new File(v);
                this.guardVars.put("todir", this.tofile);
            } else {
                this.tofile = new File(v, this.file.getName());
                this.guardVars.put("tofile", this.tofile);
            }
        } else {
            v = element.getAttribute("tofile");
            if (v.length() > 0) {
                FileRef ref = FileRef.newFileRef(v);
                this.tofile = ref.getFile();
                this.guardVars.put("tofile", this.tofile);
                ref.fillPatternVariables(this.guardVars);
            }
        }
        v = element.getAttribute("md5");
        if (v.length() > 0) {
            this.md5 = v;
        }
        if ((v = element.getAttribute("overwrite")).length() > 0) {
            this.overwrite = Boolean.parseBoolean(v);
        }
        if ((v = element.getAttribute("removeOnExit")).length() > 0) {
            this.removeOnExit = Boolean.parseBoolean(v);
        }
        if ((v = element.getAttribute("overwriteIfNewerVersion")).length() > 0) {
            this.overwriteIfNewerVersion = Boolean.parseBoolean(v);
        }
        if ((v = element.getAttribute("upgradeOnly")).length() > 0) {
            this.upgradeOnly = Boolean.parseBoolean(v);
        }
        if ((v = element.getAttribute("append")).length() > 0) {
            this.append = Boolean.parseBoolean(v);
        }
    }

    @Override
    public void writeTo(XmlWriter writer) {
        writer.start(ID);
        if (this.file != null) {
            writer.attr("file", this.file.getAbsolutePath());
        }
        if (this.tofile != null) {
            writer.attr("tofile", this.tofile.getAbsolutePath());
        }
        writer.attr("overwrite", String.valueOf(this.overwrite));
        if (this.md5 != null) {
            writer.attr("md5", this.md5);
        }
        if (this.removeOnExit) {
            writer.attr("removeOnExit", "true");
        }
        if (this.overwriteIfNewerVersion) {
            writer.attr("overwriteIfNewerVersion", "true");
        }
        if (this.upgradeOnly) {
            writer.attr("upgradeOnly", "true");
        }
        if (this.append) {
            writer.attr("append", "true");
        }
        writer.end();
    }
}

