/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wss.handlers.fprpc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.wss.WSSException;
import org.nuxeo.wss.fprpc.FPRPCCall;
import org.nuxeo.wss.fprpc.FPRPCRequest;
import org.nuxeo.wss.fprpc.FPRPCResponse;
import org.nuxeo.wss.handlers.fprpc.AbstractFPRPCHandler;
import org.nuxeo.wss.handlers.fprpc.FPRPCHandler;
import org.nuxeo.wss.spi.WSSBackend;
import org.nuxeo.wss.spi.WSSListItem;
import org.nuxeo.wss.url.WSSUrlMapper;

public class AuthorHandler
extends AbstractFPRPCHandler
implements FPRPCHandler {
    private static final Log log = LogFactory.getLog(AuthorHandler.class);

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void processCall(FPRPCRequest request, FPRPCResponse fpResponse, int callIndex, WSSBackend backend) throws WSSException {
        Iterator i$;
        ArrayList<String> failedUrls;
        ArrayList<WSSListItem> folders;
        ArrayList<WSSListItem> docs;
        FPRPCCall call = request.getCalls().get(callIndex);
        fpResponse.addRenderingParameter("siteRoot", request.getSitePath());
        fpResponse.addRenderingParameter("request", request);
        fpResponse.addRenderingParameter("serviceName", call.getParameters().get("service_name"));
        log.debug((Object)("Handling FP Author call on method " + call.getMethodName()));
        if ("open service".equals(call.getMethodName())) {
            fpResponse.setRenderingTemplateName("open-service.ftl");
            return;
        }
        if ("list documents".equals(call.getMethodName())) {
            void var10_38;
            String location = call.getParameters().get("initialUrl").trim();
            location = WSSUrlMapper.getUrlWithSitePath(request, location);
            boolean listFiles = false;
            boolean listFolders = false;
            boolean listIncludeParent = false;
            Object var10_36 = null;
            List<WSSListItem> files = null;
            WSSListItem parent = null;
            if ("true".equals(call.getParameters().get("listFiles"))) {
                listFiles = true;
                files = backend.listLeafItems(location);
            }
            if ("true".equals(call.getParameters().get("listFolders"))) {
                listFolders = true;
                List<WSSListItem> list = backend.listFolderishItems(location);
            }
            if ("true".equals(call.getParameters().get("listIncludeParent"))) {
                listIncludeParent = true;
                parent = backend.getItem(location);
            }
            fpResponse.addRenderingParameter("listFiles", listFiles);
            fpResponse.addRenderingParameter("listFolders", listFolders);
            fpResponse.addRenderingParameter("listIncludeParent", listIncludeParent);
            fpResponse.addRenderingParameter("folders", var10_38);
            fpResponse.addRenderingParameter("files", files);
            fpResponse.addRenderingParameter("parent", parent);
            fpResponse.setRenderingTemplateName("list-documents.ftl");
            return;
        }
        if ("get document".equals(call.getMethodName())) {
            String location = call.getParameters().get("document_name");
            WSSListItem doc = backend.getItem(location = WSSUrlMapper.getUrlWithSitePath(request, location));
            if (doc == null) {
                try {
                    fpResponse.getHttpResponse().sendError(404);
                    fpResponse.getHttpResponse().flushBuffer();
                }
                catch (IOException e) {
                    log.error((Object)"Error handling error page", (Throwable)e);
                }
                fpResponse.setProcessed(true);
                return;
            }
            if (!"chkoutExclusive".equalsIgnoreCase(call.getParameters().get("get_option"))) {
                fpResponse.addRenderingParameter("doc", doc);
                fpResponse.setRenderingTemplateName("get-document.ftl");
                fpResponse.addBinaryStream(doc.getStream());
                return;
            }
            if (doc.canCheckOut(request.getUserName())) {
                doc.checkOut(request.getUserName());
                fpResponse.addRenderingParameter("doc", doc);
                fpResponse.setRenderingTemplateName("get-document.ftl");
                fpResponse.addBinaryStream(doc.getStream());
                return;
            }
            if (doc.isCheckOut()) {
                fpResponse.sendFPError(request, "589838", this.getLockErrorMessage(doc));
                return;
            }
            fpResponse.sendFPError(request, "0x001E0002", doc.getDisplayName());
            return;
        }
        if ("put document".equals(call.getMethodName())) {
            String fileName;
            WSSListItem doc;
            String url = call.getParameters().get("document/document_name");
            String location = WSSUrlMapper.getUrlWithSitePath(request, url);
            if (backend.exists(location)) {
                doc = backend.getItem(location);
                String[] stringArray = url.split("/");
                fileName = stringArray[stringArray.length - 1];
            } else {
                String[] stringArray = url.split("/");
                String newFileName = stringArray[stringArray.length - 1];
                String parentPath = (url + "*").replace("/" + newFileName + "*", "");
                String parentLocation = WSSUrlMapper.getUrlWithSitePath(request, parentPath);
                doc = backend.createFileItem(parentLocation, newFileName);
                fileName = newFileName;
            }
            if (doc != null) {
                doc.setStream(request.getVermeerBinary(), fileName);
                fpResponse.addRenderingParameter("doc", doc);
                fpResponse.setRenderingTemplateName("put-document.ftl");
                return;
            }
            try {
                fpResponse.getHttpResponse().sendError(404);
                fpResponse.getHttpResponse().flushBuffer();
            }
            catch (IOException iOException) {
                log.error((Object)"Error handling error page", (Throwable)iOException);
            }
            fpResponse.setProcessed(true);
            return;
        }
        if ("checkout document".equals(call.getMethodName())) {
            String location = call.getParameters().get("document_name");
            if (!backend.exists(location = WSSUrlMapper.getUrlWithSitePath(request, location))) {
                fpResponse.sendFPError(request, "0x00090005", location);
                return;
            }
            WSSListItem doc = backend.getItem(location);
            fpResponse.addRenderingParameter("request", request);
            if (doc.canCheckOut(request.getUserName())) {
                doc.checkOut(request.getUserName());
                fpResponse.addRenderingParameter("doc", doc);
                fpResponse.setRenderingTemplateName("checkout-document.ftl");
                return;
            }
            if (doc.isCheckOut()) {
                fpResponse.sendFPError(request, "589838", this.getLockErrorMessage(doc));
                return;
            }
            fpResponse.sendFPError(request, "0x001E0002", doc.getDisplayName());
            return;
        }
        if ("uncheckout document".equals(call.getMethodName())) {
            String location = call.getParameters().get("document_name");
            if (!backend.exists(location = WSSUrlMapper.getUrlWithSitePath(request, location))) {
                fpResponse.sendFPError(request, "0x00090005", location);
                return;
            }
            WSSListItem doc = backend.getItem(location);
            if (doc.canUnCheckOut(request.getUserName())) {
                doc.uncheckOut(request.getUserName());
                fpResponse.addRenderingParameter("doc", doc);
                fpResponse.setRenderingTemplateName("uncheckout-document.ftl");
                return;
            }
            if (!doc.isCheckOut()) {
                fpResponse.sendFPError(request, "0x0009000F", doc.getDisplayName());
                return;
            }
            fpResponse.sendFPError(request, "0x001E0002", doc.getDisplayName());
            return;
        }
        if ("create url-directories".equals(call.getMethodName())) {
            String urls = call.getParameters().get("urldirs");
            urls = urls.substring(1, urls.length() - 1);
            Map<String, String> params = this.unpackMapValues(urls);
            String location = params.get("url");
            String[] urlParts = location.split("/");
            String string = urlParts[urlParts.length - 1];
            String parentPath = (location + "*").replace("/" + string + "*", "");
            String parentLocation = WSSUrlMapper.getUrlWithSitePath(request, parentPath);
            WSSListItem folder = backend.createFolder(parentLocation, string);
            fpResponse.addRenderingParameter("folder", folder);
            fpResponse.setRenderingTemplateName("create-url-directories.ftl");
            return;
        }
        if ("move document".equals(call.getMethodName())) {
            String location = call.getParameters().get("oldUrl");
            String newLocation = call.getParameters().get("newUrl");
            location = WSSUrlMapper.getUrlWithSitePath(request, location);
            newLocation = WSSUrlMapper.getUrlWithSitePath(request, newLocation);
            if (!backend.exists(location)) {
                fpResponse.sendFPError(request, "0x00090005", location);
                return;
            }
            WSSListItem doc = backend.moveItem(location, newLocation);
            fpResponse.addRenderingParameter("doc", doc);
            fpResponse.addRenderingParameter("oldUrl", location);
            fpResponse.addRenderingParameter("newUrl", location);
            fpResponse.setRenderingTemplateName("move-document.ftl");
            return;
        }
        if (!"remove documents".equals(call.getMethodName())) {
            void var10_47;
            if (!"getDocsMetaInfo".equals(call.getMethodName())) return;
            docs = new ArrayList<WSSListItem>();
            folders = new ArrayList<WSSListItem>();
            failedUrls = new ArrayList<String>();
            String url = call.getParameters().get("document_name");
            ArrayList<String> arrayList = new ArrayList<String>();
            if (url == null) {
                url = call.getParameters().get("url_list");
                if (url.startsWith("[")) {
                    List<String> list = this.unpackValues(url);
                } else {
                    arrayList.add(url);
                }
            } else {
                arrayList.add(url);
            }
            i$ = var10_47.iterator();
        } else {
            String urllist = call.getParameters().get("url_list");
            List<String> urls = this.unpackValues(urllist);
            ArrayList<String> removedDocUrls = new ArrayList<String>();
            ArrayList<String> removedDirUrls = new ArrayList<String>();
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> failedDirUrls = new ArrayList<String>();
            Iterator<String> i$2 = urls.iterator();
            while (true) {
                if (!i$2.hasNext()) {
                    fpResponse.addRenderingParameter("removedDocUrls", removedDocUrls);
                    fpResponse.addRenderingParameter("removedDirUrls", removedDirUrls);
                    fpResponse.addRenderingParameter("failedDocUrls", arrayList);
                    fpResponse.addRenderingParameter("failedDirUrls", failedDirUrls);
                    fpResponse.setRenderingTemplateName("remove-documents.ftl");
                    return;
                }
                String url = i$2.next();
                String location = WSSUrlMapper.getUrlWithSitePath(request, url);
                if (backend.exists(location)) {
                    WSSListItem doc = backend.getItem(location);
                    try {
                        backend.removeItem(location);
                        if (doc.isFolderish()) {
                            removedDirUrls.add(url);
                            continue;
                        }
                        removedDocUrls.add(url);
                    }
                    catch (WSSException e) {
                        if (doc.isFolderish()) {
                            failedDirUrls.add(url);
                            continue;
                        }
                        arrayList.add(url);
                    }
                    continue;
                }
                arrayList.add(url);
            }
        }
        while (i$.hasNext()) {
            String location = (String)i$.next();
            if (location.startsWith("http")) {
                location = WSSUrlMapper.getLocationFromFullUrl(request, location);
            }
            if (backend.exists(location = WSSUrlMapper.getUrlWithSitePath(request, location))) {
                WSSListItem doc = backend.getItem(location);
                if (doc.isFolderish()) {
                    folders.add(doc);
                    continue;
                }
                docs.add(doc);
                continue;
            }
            String failedUrl = location;
            if ((failedUrl = failedUrl.replace(request.getSitePath(), "")).startsWith("/")) {
                failedUrl = failedUrl.substring(1);
            }
            failedUrls.add(failedUrl);
        }
        fpResponse.addRenderingParameter("docs", docs);
        if (failedUrls.size() > 0) {
            fpResponse.addRenderingParameter("includeFailedUrls", true);
        } else {
            fpResponse.addRenderingParameter("includeFailedUrls", false);
        }
        if (folders.size() > 0) {
            fpResponse.addRenderingParameter("includefolders", true);
        } else {
            fpResponse.addRenderingParameter("includefolders", false);
        }
        fpResponse.addRenderingParameter("includefiles", true);
        fpResponse.addRenderingParameter("folders", folders);
        fpResponse.addRenderingParameter("failedUrls", failedUrls);
        fpResponse.setRenderingTemplateName("getDocsMetaInfo.ftl");
    }

    protected List<String> unpackValues(String packedParams) {
        String[] parts;
        ArrayList<String> values = new ArrayList<String>();
        packedParams = packedParams.substring(1, packedParams.length() - 1);
        for (String part : parts = packedParams.split("\\;")) {
            values.add(part);
        }
        return values;
    }

    protected Map<String, String> unpackMapValues(String packedParams) {
        List<String> values = this.unpackValues(packedParams);
        HashMap<String, String> params = new HashMap<String, String>();
        for (String value : values) {
            String[] parts = value.split("=");
            params.put(parts[0], parts[1]);
        }
        return params;
    }

    protected String getLockErrorMessage(WSSListItem doc) {
        return "The file " + doc.getDisplayName() + " is checked out or locked for editing by " + doc.getCheckoutUser();
    }
}

