/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wss.handlers.resources;

import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.wss.WSSConfig;

public class ResourcesHandler {
    protected static final int BUFFER_SIZE = 10240;
    public static final DateFormat HTTP_EXPIRES_DATE_FORMAT = ResourcesHandler.httpExpiresDateFormat();
    private static final Log log = LogFactory.getLog(ResourcesHandler.class);

    private static DateFormat httpExpiresDateFormat() {
        SimpleDateFormat df = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        return df;
    }

    public static InputStream getResourceAsStream(String resourceSubPath) {
        String resourcePath = WSSConfig.instance().getResourcesBasePath() + resourceSubPath;
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourcePath);
        return is;
    }

    protected void addCacheHeaders(HttpServletResponse response, int cacheTime) {
        response.addHeader("Cache-Control", "max-age=" + cacheTime);
        response.addHeader("Cache-Control", "public");
        Date date = new Date();
        long newDate = date.getTime() + new Long(cacheTime) * 1000L;
        date.setTime(newDate);
        response.setHeader("Expires", HTTP_EXPIRES_DATE_FORMAT.format(date));
    }

    public void handleResource(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String uri = request.getRequestURI();
        log.debug((Object)("Handling resource call on uri = " + uri));
        String[] parts = uri.split(WSSConfig.instance().getResourcesUrlPattern());
        String resourceSubPath = parts[parts.length - 1];
        InputStream is = ResourcesHandler.getResourceAsStream(resourceSubPath);
        if (is == null && resourceSubPath.contains("icons/")) {
            is = ResourcesHandler.getResourceAsStream("icons/file.gif");
        }
        if (is == null) {
            log.warn((Object)("Resource not found for uri " + uri));
            response.sendError(404);
            return;
        }
        this.addCacheHeaders(response, 600);
        try {
            int read;
            ServletOutputStream out = response.getOutputStream();
            byte[] buffer = new byte[10240];
            while ((read = is.read(buffer)) != -1) {
                out.write(buffer, 0, read);
                out.flush();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while serving resource", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        finally {
            if (response != null) {
                response.flushBuffer();
            }
            if (is != null) {
                is.close();
            }
        }
    }
}

