/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.jaxrs.io.documents;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.nuxeo.ecm.automation.jaxrs.io.documents.JSONDocumentModelReader;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.webengine.WebException;

public class JSONDocumentModelListReader
implements MessageBodyReader<DocumentModelList> {
    @Context
    private HttpServletRequest request;
    @Context
    JsonFactory factory;

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return DocumentModelList.class.isAssignableFrom(type);
    }

    public DocumentModelList readFrom(Class<DocumentModelList> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        String content = IOUtils.toString((InputStream)entityStream);
        if (content.isEmpty() && content.isEmpty()) {
            throw new WebException("No content in request body", Response.Status.BAD_REQUEST.getStatusCode());
        }
        try {
            return this.readRequest(content, httpHeaders, this.request);
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    public DocumentModelList readRequest(String content, MultivaluedMap<String, String> httpHeaders, HttpServletRequest request) throws Exception {
        JsonParser jp = this.factory.createJsonParser(content);
        return JSONDocumentModelListReader.readRequest(jp, httpHeaders, request);
    }

    public static DocumentModelList readRequest(JsonParser jp, MultivaluedMap<String, String> httpHeaders, HttpServletRequest request) throws Exception {
        DocumentModelList result = null;
        jp.nextToken();
        JsonToken tok = jp.nextToken();
        while (tok != JsonToken.END_OBJECT) {
            String entityType;
            String key = jp.getCurrentName();
            jp.nextToken();
            if ("entries".equals(key)) {
                result = JSONDocumentModelListReader.readDocumentEntriesFromJson(jp, httpHeaders, request);
            } else if ("entity-type".equals(key) && !"documents".equals(entityType = (String)jp.readValueAs(String.class))) {
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
            tok = jp.nextToken();
        }
        if (result == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        return result;
    }

    private static DocumentModelList readDocumentEntriesFromJson(JsonParser jp, MultivaluedMap<String, String> httpHeaders, HttpServletRequest request) throws Exception {
        DocumentModelListImpl entries = new DocumentModelListImpl();
        while (jp.nextToken() == JsonToken.START_OBJECT) {
            DocumentModel doc = JSONDocumentModelReader.readJson((JsonParser)jp, httpHeaders, (HttpServletRequest)request);
            entries.add((Object)doc);
        }
        return entries;
    }
}

