/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.center.profile;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.international.LocaleSelector;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.user.center.profile.UserProfileService;
import org.nuxeo.ecm.webapp.security.UserManagementActions;
import org.nuxeo.runtime.api.Framework;

@Name(value="userProfileActions")
@Scope(value=ScopeType.CONVERSATION)
public class UserProfileActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PROFILE_VIEW_MODE = "view";
    public static final String PROFILE_EDIT_MODE = "edit";
    public static final String PROFILE_EDIT_PASSWORD_MODE = "editPassword";
    @In(create=true)
    protected transient UserManagementActions userManagementActions;
    @In(create=true)
    protected NuxeoPrincipal currentUser;
    @In(create=true)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true)
    protected transient LocaleSelector localeSelector;
    @In(create=true)
    protected transient UserManager userManager;
    protected String mode = "view";
    protected DocumentModel userProfileDocument;
    protected DocumentModel currentUserProfile;

    public void updateUser() throws ClientException {
        if (this.userProfileDocument != null) {
            this.userProfileDocument.getDataModels().remove((Object)this.userManager.getUserSchemaName());
            this.documentManager.saveDocument(this.userProfileDocument);
            this.documentManager.save();
        }
        this.userManagementActions.updateUser();
        this.mode = PROFILE_VIEW_MODE;
    }

    public String getMode() throws ClientException {
        return this.mode;
    }

    public boolean getCanEdit() throws ClientException {
        return this.userManagementActions.getAllowEditUser() && this.userManagementActions.isNotReadOnly();
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public DocumentModel getCurrentUserModel() {
        DocumentModel selectedUser = this.userManagementActions.getSelectedUser();
        DocumentModel currentUserModel = this.currentUser.getModel();
        if (selectedUser == null || !selectedUser.getId().equals(currentUserModel.getId())) {
            this.userManagementActions.setSelectedUser(currentUserModel);
        }
        return currentUserModel;
    }

    public DocumentModel getUserProfileDocument() throws ClientException {
        this.getCurrentUserModel();
        if (this.userProfileDocument == null) {
            String currentLocale;
            this.userProfileDocument = ((UserProfileService)Framework.getService(UserProfileService.class)).getUserProfileDocument(this.documentManager);
            String locale = (String)((Object)this.userProfileDocument.getPropertyValue("userprofile:locale"));
            if (StringUtils.isEmpty((String)locale) && !StringUtils.isEmpty((String)(currentLocale = this.localeSelector.getLocaleString()))) {
                this.userProfileDocument.setPropertyValue("userprofile:locale", (Serializable)((Object)currentLocale));
            }
        }
        return this.userProfileDocument;
    }

    public DocumentModel getUserProfileDocument(String userName) throws ClientException {
        UserProfileService userProfileService = (UserProfileService)Framework.getService(UserProfileService.class);
        return userProfileService.getUserProfileDocument(userName, this.documentManager);
    }

    public DocumentModel getUserProfile() throws ClientException {
        if (this.currentUserProfile == null) {
            UserProfileService userProfileService = (UserProfileService)Framework.getService(UserProfileService.class);
            this.currentUserProfile = userProfileService.getUserProfile(this.getCurrentUserModel(), this.documentManager);
        }
        return this.currentUserProfile;
    }

    public DocumentModel getSelectedUserProfile() throws ClientException {
        DocumentModel selectedUser = this.userManagementActions.getSelectedUser();
        if (selectedUser == null) {
            return null;
        }
        if (this.userProfileDocument == null) {
            UserProfileService userProfileService = (UserProfileService)Framework.getService(UserProfileService.class);
            this.userProfileDocument = userProfileService.getUserProfile(selectedUser, this.documentManager);
        }
        return this.userProfileDocument;
    }

    @Observer(value={"currentTabChanged_MAIN_TABS", "currentTabChanged_NUXEO_ADMIN", "currentTabChanged_USER_CENTER", "currentTabChanged_UsersGroupsManager_sub_tab", "currentTabChanged_UsersGroupsHome_sub_tab", "currentTabSelected_MAIN_TABS", "currentTabSelected_NUXEO_ADMIN", "currentTabSelected_USER_CENTER", "currentTabSelected_UsersGroupsManager_sub_tab", "currentTabSelected_UsersGroupsHome_sub_tab", "usersListingChanged", "selectedUserChanged"}, create=false)
    @BypassInterceptors
    public void resetState() {
        this.userProfileDocument = null;
        this.currentUserProfile = null;
    }
}

