/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test;

import java.net.URL;
import org.jmock.MockObjectTestCase;
import org.nuxeo.runtime.RuntimeService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.TestRuntime;

public abstract class NXRuntimeTestCase
extends MockObjectTestCase {
    protected RuntimeService runtime;

    protected NXRuntimeTestCase() {
    }

    protected NXRuntimeTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.runtime = Framework.getRuntime();
        if (this.runtime != null) {
            Framework.shutdown();
            this.runtime = null;
        }
        this.runtime = new TestRuntime();
        Framework.initialize((RuntimeService)this.runtime);
        this.deploy("EventService.xml");
        this.deploy("DeploymentService.xml");
    }

    protected void tearDown() throws Exception {
        Framework.shutdown();
        this.runtime = null;
        super.tearDown();
    }

    public static URL getResource(String resource) {
        return Thread.currentThread().getContextClassLoader().getResource(resource);
    }

    public void deploy(String bundle) {
        URL url = NXRuntimeTestCase.getResource(bundle);
        NXRuntimeTestCase.assertNotNull((String)("Test resource not found: " + bundle), (Object)url);
        NXRuntimeTestCase.assertEquals((Object)this.runtime, (Object)Framework.getRuntime());
        try {
            this.runtime.getContext().deploy(url);
        }
        catch (Exception e) {
            e.printStackTrace();
            NXRuntimeTestCase.fail((String)("Failed to deploy bundle " + bundle));
        }
    }

    public void undeploy(String bundle) {
        URL url = NXRuntimeTestCase.getResource(bundle);
        NXRuntimeTestCase.assertNotNull((String)("Test resource not found: " + bundle), (Object)url);
        NXRuntimeTestCase.assertEquals((Object)this.runtime, (Object)Framework.getRuntime());
        try {
            this.runtime.getContext().undeploy(url);
        }
        catch (Exception e) {
            e.printStackTrace();
            NXRuntimeTestCase.fail((String)("Failed to undeploy bundle " + bundle));
        }
    }
}

