/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.core.io;

import fr.opensagres.xdocreport.core.io.StreamCancelable;
import java.io.IOException;
import java.io.Writer;

public class MultiWriter
extends Writer
implements StreamCancelable {
    private Writer[] writers;

    public MultiWriter(Writer ... writers) {
        this.writers = new Writer[writers.length];
        for (int i = 0; i < writers.length; ++i) {
            this.writers[i] = writers[i];
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        for (Writer w : this.writers) {
            w.write(cbuf, off, len);
            w.flush();
        }
    }

    public void flush() throws IOException {
        for (Writer w : this.writers) {
            w.flush();
        }
    }

    public void close() throws IOException {
        for (Writer w : this.writers) {
            w.close();
        }
    }

    public void cancel() {
        for (Writer w : this.writers) {
            if (!(w instanceof StreamCancelable)) continue;
            ((StreamCancelable)((Object)w)).cancel();
        }
    }

    public Writer getWriter(int index) {
        return this.writers[index];
    }
}

