/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.webdav.jaxrs.xml.elements;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public final class Rfc3339DateTimeFormat
extends SimpleDateFormat {
    private static final String DEFAULT_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";

    public Rfc3339DateTimeFormat() {
        super(DEFAULT_PATTERN, Locale.US);
        this.calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    }

    @Override
    public final Date parse(String text) throws ParseException {
        String patchedText = this.ignoreTimeOffsetColon(text);
        String pattern = this.buildPatternVariant(patchedText);
        if (!pattern.equals(DEFAULT_PATTERN)) {
            this.applyPattern(pattern);
        }
        return super.parse(patchedText);
    }

    private final String buildPatternVariant(String text) {
        StringBuilder pattern = new StringBuilder("yyyy-MM-dd'T'HH:mm:ss");
        this.addFractionToPattern(pattern, text);
        this.addTimeOffsetToPattern(pattern, text);
        return pattern.toString();
    }

    private final void addFractionToPattern(StringBuilder pattern, String text) {
        if (text.lastIndexOf(46) != -1) {
            pattern.append(".SSS");
        }
    }

    private final void addTimeOffsetToPattern(StringBuilder pattern, String text) {
        boolean appendAsLiteral;
        boolean bl = appendAsLiteral = text.charAt(text.length() - 1) == 'Z';
        if (appendAsLiteral) {
            pattern.append('\'');
        }
        pattern.append('Z');
        if (appendAsLiteral) {
            pattern.append('\'');
        }
    }

    private final String ignoreTimeOffsetColon(String text) throws ParseException {
        if (text.charAt(text.length() - 1) == 'Z') {
            return text;
        }
        if (text.charAt(text.length() - 3) != ':') {
            throw new ParseException("According to RFC 3339 time offset must contain colon separator.", text.length() - 2);
        }
        return new StringBuilder(text).deleteCharAt(text.length() - 3).toString();
    }
}

