/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.locale;

import java.io.Serializable;
import java.util.Locale;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.international.LocaleSelector;
import org.jboss.seam.international.TimeZoneSelector;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.platform.web.common.locale.LocaleProvider;
import org.nuxeo.runtime.api.Framework;

@Name(value="clientLocaleInitializer")
@Scope(value=ScopeType.SESSION)
@Startup
public class LocaleStartup
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Log log = LogFactory.getLog(LocaleStartup.class);
    @In(create=true)
    protected CoreSession documentManager;
    protected String tzId;

    public static LocaleStartup instance() {
        if (!Contexts.isSessionContextActive()) {
            return null;
        }
        return (LocaleStartup)Component.getInstance(LocaleStartup.class, (ScopeType)ScopeType.SESSION);
    }

    public String getTzId() {
        return this.tzId;
    }

    public void setTzId(String id) {
        this.tzId = id;
    }

    @Observer(value={"org.nuxeo.ecm.web.userSessionStarted"})
    public void handleUserSessionStarted(CoreSession session) {
        this.setupTimeZone(session);
        this.setupLocale(session);
    }

    public void setupTimeZone(CoreSession session) {
        TimeZoneSelector tzSelector = TimeZoneSelector.instance();
        tzSelector.setCookieEnabled(true);
        tzSelector.initTimeZone();
    }

    public void setupLocale(CoreSession session) {
        Locale locale = null;
        try {
            locale = ((LocaleProvider)Framework.getLocalService(LocaleProvider.class)).getLocale(session);
        }
        catch (ClientException e) {
            log.warn((Object)"Couldn't get locale from LocaleProvider, trying request locale and default locale", (Throwable)e);
        }
        if (locale == null) {
            log.debug((Object)"Locale not set, falling back to request locale");
            locale = FacesContext.getCurrentInstance().getExternalContext().getRequestLocale();
        }
        if (locale == null) {
            log.debug((Object)"Locale not set, falling back to default locale");
            locale = Locale.getDefault();
        }
        LocaleSelector localeSelector = LocaleSelector.instance();
        localeSelector.setLocale(locale);
        localeSelector.setCookieEnabled(true);
        localeSelector.select();
    }
}

