/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.security;

import java.io.Serializable;
import java.util.ArrayList;
import javax.faces.model.SelectItem;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.common.utils.i18n.Labeler;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;

@Name(value="permissionActionListManager")
@Scope(value=ScopeType.SESSION)
public class PermissionActionListManager
implements Serializable {
    private static final long serialVersionUID = -327848199566592785L;
    private static final Labeler labeler = new Labeler("label.security");
    protected String selectedGrant;
    @In(create=true)
    private transient ResourcesAccessor resourcesAccessor;

    public SelectItem[] getPermissionActionItems() {
        ArrayList<String> permissionActions = new ArrayList<String>();
        ArrayList<SelectItem> jsfModelList = new ArrayList<SelectItem>();
        permissionActions.add("Grant");
        permissionActions.add("Deny");
        for (String permissionAction : permissionActions) {
            String label = labeler.makeLabel(permissionAction);
            SelectItem it = new SelectItem((Object)permissionAction, this.resourcesAccessor.getMessages().get(label));
            jsfModelList.add(it);
        }
        SelectItem[] permissionActionItems = jsfModelList.toArray(new SelectItem[0]);
        return permissionActionItems;
    }

    public String getSelectedGrant() {
        return this.selectedGrant;
    }

    public void setSelectedGrant(String selectedPermission) {
        this.selectedGrant = selectedPermission;
    }
}

