/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.wi.backend.wss;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;
import org.nuxeo.wss.WSSException;
import org.nuxeo.wss.spi.AbstractWSSListItem;
import org.nuxeo.wss.spi.WSSListItem;

public class NuxeoListItem
extends AbstractWSSListItem
implements WSSListItem {
    private static final Log log = LogFactory.getLog(NuxeoListItem.class);
    protected DocumentModel doc;
    protected String corePathPrefix;
    protected String urlRoot;
    protected String virtualName = null;
    protected String virtualRootNodeName = null;

    protected CoreSession getSession() {
        return CoreInstance.getInstance().getSession(this.doc.getSessionId());
    }

    public NuxeoListItem(DocumentModel doc, String corePathPrefix, String urlRoot) {
        this.doc = doc;
        this.corePathPrefix = corePathPrefix;
        this.urlRoot = urlRoot;
    }

    protected Date getCheckoutDate() {
        Lock lock = null;
        try {
            lock = this.getSession().getLockInfo(this.doc.getRef());
        }
        catch (ClientException e) {
            log.error((Object)"Unable to get lock", (Throwable)e);
        }
        if (lock != null) {
            return lock.getCreated().getTime();
        }
        return Calendar.getInstance().getTime();
    }

    protected Date getCheckoutExpiryDate() {
        Date to = this.getCheckoutDate();
        if (to != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(to);
            cal.add(12, 20);
            return cal.getTime();
        }
        return Calendar.getInstance().getTime();
    }

    public Date getCreationDate() {
        try {
            Calendar modified = (Calendar)this.doc.getPropertyValue("dc:created");
            if (modified != null) {
                return modified.getTime();
            }
        }
        catch (ClientException e) {
            log.error((Object)"Unable to get creation date", (Throwable)e);
        }
        return Calendar.getInstance().getTime();
    }

    public Date getModificationDate() {
        try {
            Calendar modified = (Calendar)this.doc.getPropertyValue("dc:modified");
            if (modified != null) {
                return modified.getTime();
            }
        }
        catch (ClientException e) {
            log.error((Object)"Unable to get modification date", (Throwable)e);
        }
        return Calendar.getInstance().getTime();
    }

    public void checkOut(String userName) throws WSSException {
        try {
            Lock lock = this.getSession().getLockInfo(this.doc.getRef());
            if (lock == null) {
                this.getSession().setLock(this.doc.getRef());
            } else if (!userName.equals(this.getCheckoutUser())) {
                throw new WSSException("Document is already locked by another user");
            }
        }
        catch (ClientException e) {
            throw new WSSException("Error while locking", (Throwable)e);
        }
    }

    public String getCheckoutUser() {
        Lock lock = null;
        try {
            lock = this.getSession().getLockInfo(this.doc.getRef());
        }
        catch (ClientException e) {
            log.error((Object)"Unable to get lock", (Throwable)e);
        }
        if (lock != null) {
            return lock.getOwner();
        }
        return null;
    }

    public String getDescription() {
        try {
            return (String)((Object)this.doc.getPropertyValue("dc:description"));
        }
        catch (Exception e) {
            log.error((Object)"Unable to get description", (Throwable)e);
            return "";
        }
    }

    public String getEtag() {
        return this.doc.getId();
    }

    public String getLastModificator() {
        return null;
    }

    public String getName() {
        if (this.virtualName != null) {
            return this.virtualName;
        }
        return this.doc.getName();
    }

    public int getSize() {
        BlobHolder bh;
        int size = 0;
        if (!this.doc.isFolder() && (bh = (BlobHolder)this.doc.getAdapter(BlobHolder.class)) != null) {
            try {
                Blob blob = bh.getBlob();
                if (blob != null) {
                    size = (int)blob.getLength();
                }
            }
            catch (ClientException e) {
                log.error((Object)"Unable to get blob Size", (Throwable)e);
            }
        }
        if (size == 0) {
            size = 10;
        }
        return size;
    }

    public InputStream getStream() {
        BlobHolder bh = (BlobHolder)this.doc.getAdapter(BlobHolder.class);
        if (bh != null) {
            try {
                Blob blob = bh.getBlob();
                if (blob != null) {
                    return blob.getStream();
                }
            }
            catch (Exception e) {
                log.error((Object)"Unable to get Stream", (Throwable)e);
            }
        }
        return null;
    }

    public String getSubPath() {
        String path = this.doc.getPathAsString();
        if (this.corePathPrefix != null) {
            path = path.replace(this.corePathPrefix, "");
        }
        if (this.virtualName != null) {
            Path vPath = new Path(path);
            vPath = vPath.removeFirstSegments(1);
            path = new Path(this.virtualName).append(vPath).toString();
        } else if (this.virtualRootNodeName != null) {
            path = new Path(this.virtualRootNodeName).append(path).toString();
        }
        Path completePath = new Path(this.urlRoot);
        completePath = completePath.append(path);
        path = completePath.toString();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }

    public String getRelativeFilePath(String siteRootPath) {
        String filename;
        String path = this.getRelativeSubPath(siteRootPath);
        if (!this.doc.isFolder() && (filename = this.getFileName()) != null) {
            path = new Path(path).removeLastSegments(1).append(filename).toString();
        }
        return path;
    }

    protected String getFileName() {
        BlobHolder bh = (BlobHolder)this.doc.getAdapter(BlobHolder.class);
        if (bh != null) {
            try {
                Blob blob = bh.getBlob();
                if (blob != null) {
                    return blob.getFilename();
                }
            }
            catch (ClientException e) {
                log.error((Object)"Unable to get filename", (Throwable)e);
            }
        }
        return null;
    }

    public String getType() {
        if (this.doc.isFolder()) {
            return "folder";
        }
        return "file";
    }

    public void setDescription(String description) {
        try {
            this.doc.setPropertyValue("dc:description", (Serializable)((Object)description));
        }
        catch (Exception e) {
            log.error((Object)"Error while setting description", (Throwable)e);
        }
    }

    public void setStream(InputStream is, String fileName) throws WSSException {
        BlobHolder bh = (BlobHolder)this.doc.getAdapter(BlobHolder.class);
        if (bh != null) {
            StreamingBlob blob = StreamingBlob.createFromStream((InputStream)is);
            if (fileName != null) {
                blob.setFilename(fileName);
            }
            try {
                Blob oldBlob = bh.getBlob();
                if (oldBlob == null && this.doc.hasSchema("common")) {
                    this.doc.setProperty("common", "icon", null);
                }
                bh.setBlob((Blob)blob);
                this.doc.putContextData("VersioningOption", (Serializable)VersioningOption.MINOR);
                this.doc = this.getSession().saveDocument(this.doc);
            }
            catch (ClientException e) {
                log.error((Object)"Error while setting stream", (Throwable)e);
            }
        } else {
            log.error((Object)("Update of type " + this.doc.getType() + " is not supported for now"));
        }
    }

    public void uncheckOut(String userName) throws WSSException {
        block3: {
            try {
                Lock lock = this.getSession().getLockInfo(this.doc.getRef());
                if (lock == null) break block3;
                if (userName.equals(lock.getOwner())) {
                    this.getSession().removeLock(this.doc.getRef());
                    break block3;
                }
                throw new WSSException("Document is locked by another user");
            }
            catch (ClientException e) {
                throw new WSSException("Error while unlocking", (Throwable)e);
            }
        }
    }

    public String getDisplayName() {
        if (this.doc.isFolder()) {
            try {
                return this.doc.getTitle();
            }
            catch (ClientException e) {
                return this.getName();
            }
        }
        String fileName = this.getFileName();
        if (fileName == null) {
            fileName = this.getName();
        }
        return fileName;
    }

    protected String getExtension() {
        String fileName = this.getFileName();
        if (fileName == null) {
            return super.getExtension();
        }
        return new Path(fileName).getFileExtension();
    }

    public void setVirtualName(String virtualName) {
        this.virtualName = virtualName;
    }

    public void setVirtualRootNodeName(String virtualRootNodeName) {
        this.virtualRootNodeName = virtualRootNodeName;
    }

    public DocumentModel getDoc() {
        return this.doc;
    }

    public String getAuthor() {
        try {
            return (String)((Object)this.doc.getPropertyValue("dc:creator"));
        }
        catch (Exception e) {
            return "";
        }
    }

    protected String getIconFromType() {
        if ("Workspace".equals(this.doc.getType())) {
            return "workspace.gif";
        }
        return super.getIconFromType();
    }

    public boolean isFolderish() {
        return this.doc.isFolder();
    }

    public boolean canCheckOut(String userName) {
        boolean canCheckOut = super.canCheckOut(userName);
        if (canCheckOut) {
            try {
                return this.getSession().hasPermission(this.doc.getRef(), "WriteProperties");
            }
            catch (ClientException e) {
                log.error((Object)"Error during permission check", (Throwable)e);
                return false;
            }
        }
        return canCheckOut;
    }

    public boolean canUnCheckOut(String userName) {
        boolean canUnCheckOut = super.canUnCheckOut(userName);
        if (canUnCheckOut) {
            try {
                return this.getSession().hasPermission(this.doc.getRef(), "WriteProperties");
            }
            catch (ClientException e) {
                log.error((Object)"Error during permission check", (Throwable)e);
                return false;
            }
        }
        return canUnCheckOut;
    }
}

