/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.wi.service;

import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.wi.backend.BackendFactory;
import org.nuxeo.ecm.platform.wi.backend.SearchBackendFactory;
import org.nuxeo.ecm.platform.wi.backend.wss.DefaultNuxeoItemFactory;
import org.nuxeo.ecm.platform.wi.backend.wss.NuxeoListItem;
import org.nuxeo.ecm.platform.wi.backend.wss.WSSListItemFactory;
import org.nuxeo.ecm.platform.wi.service.BackendFactoryDescriptor;
import org.nuxeo.ecm.platform.wi.service.DocTypesDescriptor;
import org.nuxeo.ecm.platform.wi.service.ItemFactoryDescriptor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

public class WIPluggableBackendManager
extends DefaultComponent {
    protected static BackendFactory backendFactory = new SearchBackendFactory();
    protected static WSSListItemFactory itemFactory = new DefaultNuxeoItemFactory();
    public static String BACKEND_FACTORY_XP = "backendFactory";
    public static String ITEM_FACTORY_XP = "itemFactory";
    public static String DOC_TYPES_XP = "docTypes";
    public static String leafDocType = "File";
    public static String folderishDocType = "Folder";
    public static final ComponentName NAME = new ComponentName("org.nuxeo.ecm.platform.wi.service.WIPluggableBackendManager");

    public static WIPluggableBackendManager instance() {
        return (WIPluggableBackendManager)((Object)Framework.getRuntime().getComponent(NAME));
    }

    public BackendFactory getBackendFactory() {
        return backendFactory;
    }

    public NuxeoListItem createItem(DocumentModel doc, String corePathPrefix, String urlRoot) {
        return itemFactory.createItem(doc, corePathPrefix, urlRoot);
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (BACKEND_FACTORY_XP.equals(extensionPoint)) {
            BackendFactoryDescriptor desc = (BackendFactoryDescriptor)contribution;
            Class<?> factoryClass = desc.getFactoryClass();
            backendFactory = (BackendFactory)factoryClass.newInstance();
        } else if (ITEM_FACTORY_XP.equals(extensionPoint)) {
            ItemFactoryDescriptor desc = (ItemFactoryDescriptor)contribution;
            Class<?> factoryClass = desc.getFactoryClass();
            itemFactory = (WSSListItemFactory)factoryClass.newInstance();
        } else if (DOC_TYPES_XP.equals(extensionPoint)) {
            DocTypesDescriptor desc = (DocTypesDescriptor)contribution;
            if (desc.getFolderishDocType() != null) {
                folderishDocType = desc.getFolderishDocType();
            }
            if (desc.getLeafDocType() != null) {
                leafDocType = desc.getLeafDocType();
            }
        }
    }
}

