/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.ldap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.directory.AbstractReference;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.ldap.LDAPDirectory;
import org.nuxeo.ecm.directory.ldap.LDAPDirectoryDescriptor;
import org.nuxeo.ecm.directory.ldap.LDAPDirectoryProxy;
import org.nuxeo.ecm.directory.ldap.LDAPFilterMatcher;
import org.nuxeo.ecm.directory.ldap.LDAPSession;
import org.nuxeo.ecm.directory.ldap.LdapScope;

@XObject(value="ldapTreeReference")
public class LDAPTreeReference
extends AbstractReference {
    private static final Log log = LogFactory.getLog(LDAPTreeReference.class);
    public static final List<String> EMPTY_STRING_LIST = Collections.emptyList();
    protected LDAPDirectoryDescriptor targetDirectoryDescriptor;
    protected int scope;

    @XNode(value="@field")
    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    protected LDAPFilterMatcher getFilterMatcher() {
        return new LDAPFilterMatcher();
    }

    @XNode(value="@directory")
    public void setTargetDirectoryName(String targetDirectoryName) {
        this.targetDirectoryName = targetDirectoryName;
    }

    public int getScope() {
        return this.scope;
    }

    @XNode(value="@scope")
    public void setScope(String scope) throws DirectoryException {
        if (scope == null) {
            this.scope = 1;
            return;
        }
        Integer searchScope = LdapScope.getIntegerScope(scope);
        if (searchScope == null) {
            throw new DirectoryException("Invalid search scope: " + scope + ". Valid options: object, onelevel, subtree");
        }
        this.scope = searchScope;
    }

    public Directory getSourceDirectory() throws DirectoryException {
        Directory sourceDir = super.getSourceDirectory();
        if (sourceDir instanceof LDAPDirectoryProxy) {
            return ((LDAPDirectoryProxy)sourceDir).getDirectory();
        }
        throw new DirectoryException(this.sourceDirectoryName + " is not a LDAPDirectory and thus cannot be used in a reference for " + this.fieldName);
    }

    public Directory getTargetDirectory() throws DirectoryException {
        Directory targetDir = super.getTargetDirectory();
        if (targetDir instanceof LDAPDirectoryProxy) {
            return ((LDAPDirectoryProxy)targetDir).getDirectory();
        }
        throw new DirectoryException(this.targetDirectoryName + " is not a LDAPDirectory and thus cannot be referenced as target by " + this.fieldName);
    }

    protected LDAPDirectory getTargetLDAPDirectory() throws DirectoryException {
        return (LDAPDirectory)this.getTargetDirectory();
    }

    protected LDAPDirectory getSourceLDAPDirectory() throws DirectoryException {
        return (LDAPDirectory)this.getSourceDirectory();
    }

    protected LDAPDirectoryDescriptor getTargetDirectoryDescriptor() throws DirectoryException {
        if (this.targetDirectoryDescriptor == null) {
            this.targetDirectoryDescriptor = this.getTargetLDAPDirectory().getConfig();
        }
        return this.targetDirectoryDescriptor;
    }

    public void addLinks(String sourceId, List<String> targetIds) throws DirectoryException {
    }

    public void addLinks(List<String> sourceIds, String targetId) throws DirectoryException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSourceIdsForTarget(String targetId) throws DirectoryException {
        TreeSet<String> sourceIds = new TreeSet<String>();
        String targetDn = null;
        LDAPDirectory targetDir = this.getTargetLDAPDirectory();
        LDAPSession targetSession = (LDAPSession)targetDir.getSession();
        try {
            SearchResult targetLdapEntry = targetSession.getLdapEntry(targetId, true);
            if (targetLdapEntry == null) {
                List<String> list = EMPTY_STRING_LIST;
                return list;
            }
            targetDn = LDAPTreeReference.pseudoNormalizeDn(targetLdapEntry.getNameInNamespace());
        }
        catch (NamingException e) {
            throw new DirectoryException("error fetching " + targetId, (Throwable)e);
        }
        finally {
            targetSession.close();
        }
        LDAPDirectory sourceDirectory = this.getSourceLDAPDirectory();
        String parentDn = this.getParentDn(targetDn);
        String filterExpr = String.format("(&%s)", sourceDirectory.getBaseFilter());
        Object[] filterArgs = new String[]{};
        LDAPSession sourceSession = (LDAPSession)sourceDirectory.getSession();
        SearchControls sctls = sourceDirectory.getSearchControls(true);
        sctls.setSearchScope(0);
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("LDAPReference.getSourceIdsForTarget(%s): LDAP search search base='%s' filter='%s' args='%s' scope='%s' [%s]", new Object[]{targetId, parentDn, filterExpr, StringUtils.join((Object[])filterArgs, (String)", "), sctls.getSearchScope(), this}));
            }
            NamingEnumeration<SearchResult> results = sourceSession.dirContext.search(parentDn, filterExpr, filterArgs, sctls);
            try {
                while (results.hasMore()) {
                    Object value;
                    Attributes attributes = results.next().getAttributes();
                    Attribute attr = attributes.get(sourceSession.idAttribute);
                    if (attr == null || (value = attr.get()) == null) continue;
                    sourceIds.add(value.toString());
                    break;
                }
            }
            finally {
                results.close();
            }
        }
        catch (NamingException e) {
            throw new DirectoryException("error during reference search for " + targetDn, (Throwable)e);
        }
        finally {
            sourceSession.close();
        }
        return new ArrayList<String>(sourceIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getTargetIdsForSource(String sourceId) throws DirectoryException {
        TreeSet<String> targetIds = new TreeSet<String>();
        String sourceDn = null;
        LDAPDirectory sourceDir = this.getSourceLDAPDirectory();
        LDAPSession sourceSession = (LDAPSession)sourceDir.getSession();
        try {
            SearchResult sourceLdapEntry = sourceSession.getLdapEntry(sourceId, true);
            if (sourceLdapEntry == null) {
                throw new DirectoryException(sourceId + " does not exist in " + this.sourceDirectoryName);
            }
            sourceDn = LDAPTreeReference.pseudoNormalizeDn(sourceLdapEntry.getNameInNamespace());
        }
        catch (NamingException e) {
            throw new DirectoryException("error fetching " + sourceId, (Throwable)e);
        }
        finally {
            sourceSession.close();
        }
        LDAPDirectory targetDirectory = this.getTargetLDAPDirectory();
        String filterExpr = String.format("(&%s)", targetDirectory.getBaseFilter());
        Object[] filterArgs = new String[]{};
        LDAPSession targetSession = (LDAPSession)targetDirectory.getSession();
        SearchControls sctls = targetDirectory.getSearchControls(true);
        sctls.setSearchScope(this.getScope());
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("LDAPReference.getTargetIdsForSource(%s): LDAP search search base='%s' filter='%s' args='%s' scope='%s' [%s]", new Object[]{sourceId, sourceDn, filterExpr, StringUtils.join((Object[])filterArgs, (String)", "), sctls.getSearchScope(), this}));
            }
            NamingEnumeration<SearchResult> results = targetSession.dirContext.search(sourceDn, filterExpr, filterArgs, sctls);
            try {
                while (results.hasMore()) {
                    String targetId;
                    Object value;
                    Attributes attributes = results.next().getAttributes();
                    Attribute attr = attributes.get(targetSession.idAttribute);
                    if (attr == null || (value = attr.get()) == null || sourceId.equals(targetId = value.toString())) continue;
                    targetIds.add(targetId);
                }
            }
            finally {
                results.close();
            }
        }
        catch (NamingException e) {
            throw new DirectoryException("error during reference search for " + sourceDn, (Throwable)e);
        }
        finally {
            targetSession.close();
        }
        return new ArrayList<String>(targetIds);
    }

    protected static String pseudoNormalizeDn(String dn) throws InvalidNameException {
        LdapName ldapName = new LdapName(dn);
        ArrayList<String> rdns = new ArrayList<String>();
        for (Rdn rdn : ldapName.getRdns()) {
            String value = rdn.getValue().toString().toLowerCase().replaceAll(",", "\\\\,");
            String rdnStr = rdn.getType().toLowerCase() + "=" + value;
            rdns.add(0, rdnStr);
        }
        return StringUtils.join(rdns, (char)',');
    }

    protected String getParentDn(String dn) {
        if (dn != null) {
            try {
                LdapName ldapName = new LdapName(dn);
                ldapName.remove(ldapName.size() - 1);
                String parentDn = ldapName.toString();
                return parentDn;
            }
            catch (InvalidNameException ex) {
                return null;
            }
        }
        return null;
    }

    public void removeLinksForSource(String sourceId) throws DirectoryException {
    }

    public void removeLinksForTarget(String targetId) throws DirectoryException {
    }

    public void setSourceIdsForTarget(String targetId, List<String> sourceIds) throws DirectoryException {
    }

    public void setTargetIdsForSource(String sourceId, List<String> targetIds) throws DirectoryException {
    }

    public String toString() {
        return String.format("LDAPTreeReference to resolve field='%s' of sourceDirectory='%s' with targetDirectory='%s'", this.fieldName, this.sourceDirectoryName, this.targetDirectoryName);
    }

    protected AbstractReference newInstance() {
        return new LDAPTreeReference();
    }

    public LDAPTreeReference clone() {
        LDAPTreeReference clone = (LDAPTreeReference)super.clone();
        clone.scope = this.scope;
        return clone;
    }
}

