/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.center;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.service.AbstractDocumentViewCodec;
import org.nuxeo.runtime.api.Framework;

public class UserCodec
extends AbstractDocumentViewCodec {
    public static final String PREFIX = "user";
    public static final String DEFAULT_VIEW_ID = "view_home";
    public static final String DEFAULT_USERS_TAB = "USER_CENTER:UsersGroupsHome:UsersHome";
    public static final String GET_URL_PATTERN = "/([a-zA-Z_0-9\\-\\.@]*)?(/([a-zA-Z_0-9\\-\\.]*))?/?(\\?((.*)?))?";

    public String getPrefix() {
        if (this.prefix != null) {
            return this.prefix;
        }
        return PREFIX;
    }

    public DocumentView getDocumentViewFromUrl(String url) {
        Pattern pattern = Pattern.compile(this.getPrefix() + GET_URL_PATTERN);
        Matcher m = pattern.matcher(url);
        if (m.matches() && m.groupCount() >= 1) {
            String query;
            HashMap<String, String> params;
            String username = m.group(1);
            String viewId = m.group(3);
            if (viewId == null || "".equals(viewId)) {
                viewId = DEFAULT_VIEW_ID;
            }
            if ((params = URIUtils.getRequestParameters((String)(query = m.group(5)))) == null) {
                params = new HashMap<String, String>();
            }
            params.put("username", username);
            params.put("showUser", "true");
            if (!params.containsKey("tabIds")) {
                params.put("tabIds", DEFAULT_USERS_TAB);
            }
            DocumentLocationImpl docLoc = new DocumentLocationImpl(this.getDefaultRepositoryName(), null);
            return new DocumentViewImpl((DocumentLocation)docLoc, viewId, params);
        }
        return null;
    }

    private String getDefaultRepositoryName() {
        try {
            return ((RepositoryManager)Framework.getService(RepositoryManager.class)).getDefaultRepository().getName();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getUrlFromDocumentView(DocumentView docView) {
        String username = docView.getParameter("username");
        if (username != null) {
            docView.removeParameter("username");
            ArrayList<String> items = new ArrayList<String>();
            items.add(this.getPrefix());
            items.add(username);
            String viewId = docView.getViewId();
            if (viewId != null) {
                items.add(viewId);
            }
            String uri = StringUtils.join(items, (String)"/");
            HashMap parameters = docView.getParameters();
            if (parameters == null) {
                parameters = new HashMap();
            }
            return URIUtils.addParametersToURIQuery((String)uri, (Map)parameters);
        }
        return null;
    }
}

