/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.configuration;

import java.util.HashSet;
import java.util.Set;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import org.apache.directory.server.core.configuration.ConfigurationException;
import org.apache.directory.shared.ldap.exception.LdapConfigurationException;
import org.apache.directory.shared.ldap.message.AttributesImpl;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.Normalizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartitionConfiguration {
    public static final String SYSTEM_PARTITION_NAME = "system";
    public static final String DEFAULT_PARTITION_IMPLEMENTATION = "org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmPartition";
    public static final int DEFAULT_CACHE_SIZE = 10000;
    private String id;
    private int cacheSize = -1;
    private String suffix;
    private Set<Object> indexedAttributes;
    private Attributes contextEntry = new AttributesImpl(true);
    private String partitionClassName = "org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmPartition";

    protected PartitionConfiguration() {
        this.setIndexedAttributes(new HashSet<Object>());
    }

    public String getId() {
        return this.id;
    }

    protected void setId(String id) {
        this.id = id = id.trim();
    }

    public Set<Object> getIndexedAttributes() {
        HashSet<Object> newSet = new HashSet<Object>();
        newSet.addAll(this.indexedAttributes);
        return newSet;
    }

    protected void setIndexedAttributes(Set<Object> indexedAttributes) {
        this.indexedAttributes = indexedAttributes;
    }

    public String getPartitionClassName() {
        return this.partitionClassName;
    }

    protected void setPartitionClassName(String partitionClassName) {
        if (partitionClassName == null) {
            throw new NullPointerException("partitionClassName");
        }
        this.partitionClassName = partitionClassName;
    }

    public Attributes getContextEntry() {
        return (Attributes)this.contextEntry.clone();
    }

    protected void setContextEntry(Attributes rootEntry) {
        this.contextEntry = (Attributes)rootEntry.clone();
    }

    public String getSuffix() {
        return this.suffix;
    }

    public Name getNormalizedSuffix(Normalizer normalizer) throws NamingException {
        return new LdapDN(normalizer.normalize((Object)this.suffix).toString());
    }

    protected void setSuffix(String suffix) throws NamingException {
        suffix = suffix.trim();
        try {
            new LdapDN(suffix);
        }
        catch (NamingException e) {
            throw new LdapConfigurationException("Failed to parse the suffix: " + suffix, (Throwable)e);
        }
        this.suffix = suffix;
    }

    public void validate() {
        if (this.getId() == null || this.getId().length() == 0) {
            throw new ConfigurationException("Name is not specified.");
        }
        if (this.getSuffix() == null) {
            throw new ConfigurationException("Suffix is not specified.");
        }
        if (this.getPartitionClassName() == null) {
            throw new ConfigurationException("PartitionClassName is not specified.");
        }
    }

    protected void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }
}

