/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.directory.server.core.configuration.AuthenticatorConfiguration;
import org.apache.directory.server.core.configuration.Configuration;
import org.apache.directory.server.core.configuration.ConfigurationException;
import org.apache.directory.server.core.configuration.InterceptorConfiguration;
import org.apache.directory.server.core.configuration.MutableAuthenticatorConfiguration;
import org.apache.directory.server.core.configuration.MutableInterceptorConfiguration;
import org.apache.directory.server.core.configuration.PartitionConfiguration;
import org.apache.directory.shared.ldap.ldif.Entry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartupConfiguration
extends Configuration {
    private static final String STRONG_AUTHENTICATOR = "org.apache.directory.server.core.authn.StrongAuthenticator";
    private static final String SIMPLE_AUTHENTICATOR = "org.apache.directory.server.core.authn.SimpleAuthenticator";
    private static final String ANONYMOUS_AUTHENTICATOR = "org.apache.directory.server.core.authn.AnonymousAuthenticator";
    public static final String NORMALIZATION_SERVICE_NAME = "normalizationService";
    private static final String NORMALIZATION_SERVICE_CLASS = "org.apache.directory.server.core.normalization.NormalizationService";
    public static final String AUTHENTICATION_SERVICE_NAME = "authenticationService";
    private static final String AUTHENTICATION_SERVICE_CLASS = "org.apache.directory.server.core.authn.AuthenticationService";
    public static final String REFERRAL_SERVICE_NAME = "referralService";
    private static final String REFERRAL_SERVICE_CLASS = "org.apache.directory.server.core.referral.ReferralService";
    public static final String AUTHORIZATION_SERVICE_NAME = "authorizationService";
    private static final String AUTHORIZATION_SERVICE_CLASS = "org.apache.directory.server.core.authz.AuthorizationService";
    public static final String DEFAULT_AUTHORIZATION_SERVICE_NAME = "defaultAuthorizationService";
    private static final String DEFAULT_AUTHORIZATION_SERVICE_CLASS = "org.apache.directory.server.core.authz.DefaultAuthorizationService";
    public static final String EXCEPTION_SERVICE_NAME = "exceptionService";
    private static final String EXCEPTION_SERVICE_CLASS = "org.apache.directory.server.core.exception.ExceptionService";
    public static final String OPERATIONAL_ATTRIBUTE_SERVICE_NAME = "operationalAttributeService";
    private static final String OPERATIONAL_ATTRIBUTE_SERVICE_CLASS = "org.apache.directory.server.core.operational.OperationalAttributeService";
    public static final String SCHEMA_SERVICE_NAME = "schemaService";
    private static final String SCHEMA_SERVICE_CLASS = "org.apache.directory.server.core.schema.SchemaService";
    public static final String SUBENTRY_SERVICE_NAME = "subentryService";
    private static final String SUBENTRY_SERVICE_CLASS = "org.apache.directory.server.core.subtree.SubentryService";
    public static final String COLLECTIVE_ATTRIBUTE_SERVICE_NAME = "collectiveAttributeService";
    private static final String COLLECTIVE_ATTRIBUTE_SERVICE_CLASS = "org.apache.directory.server.core.collective.CollectiveAttributeService";
    public static final String EVENT_SERVICE_NAME = "eventService";
    private static final String EVENT_SERVICE_CLASS = "org.apache.directory.server.core.event.EventService";
    public static final String TRIGGER_SERVICE_NAME = "triggerService";
    private static final String TRIGGER_SERVICE_CLASS = "org.apache.directory.server.core.trigger.TriggerService";
    private static final Logger log = LoggerFactory.getLogger(StartupConfiguration.class);
    private static final long serialVersionUID = 4826762196566871677L;
    public static final int MAX_THREADS_DEFAULT = 32;
    public static final int MAX_SIZE_LIMIT_DEFAULT = 100;
    public static final int MAX_TIME_LIMIT_DEFAULT = 10000;
    private File workingDirectory = new File("server-work");
    private boolean exitVmOnShutdown = true;
    private boolean shutdownHookEnabled = true;
    private boolean allowAnonymousAccess = true;
    private boolean accessControlEnabled = false;
    private boolean denormalizeOpAttrsEnabled = false;
    private int maxThreads = 32;
    private int maxSizeLimit = 100;
    private int maxTimeLimit = 10000;
    private Set<AuthenticatorConfiguration> authenticatorConfigurations;
    private List<InterceptorConfiguration> interceptorConfigurations;
    private PartitionConfiguration systemPartitionConfiguration;
    private Set<? extends PartitionConfiguration> partitionConfigurations = new HashSet<PartitionConfiguration>();
    private List<Entry> testEntries = new ArrayList<Entry>();

    public StartupConfiguration() {
        this.setDefaultAuthenticatorConfigurations();
        this.setDefaultInterceptorConfigurations();
    }

    public StartupConfiguration(String instanceId) {
        this.setDefaultAuthenticatorConfigurations();
        this.setDefaultInterceptorConfigurations();
        this.setInstanceId(instanceId);
    }

    private void setDefaultAuthenticatorConfigurations() {
        HashSet<AuthenticatorConfiguration> set = new HashSet<AuthenticatorConfiguration>();
        set.add(new MutableAuthenticatorConfiguration("Anonymous", ANONYMOUS_AUTHENTICATOR));
        set.add(new MutableAuthenticatorConfiguration("Simple", SIMPLE_AUTHENTICATOR));
        set.add(new MutableAuthenticatorConfiguration("Strong", STRONG_AUTHENTICATOR));
        this.setAuthenticatorConfigurations(set);
    }

    private void setDefaultInterceptorConfigurations() {
        ArrayList<InterceptorConfiguration> list = new ArrayList<InterceptorConfiguration>();
        MutableInterceptorConfiguration interceptorCfg = new MutableInterceptorConfiguration();
        ((InterceptorConfiguration)interceptorCfg).setName(NORMALIZATION_SERVICE_NAME);
        ((InterceptorConfiguration)interceptorCfg).setInterceptorClassName(NORMALIZATION_SERVICE_CLASS);
        list.add(interceptorCfg);
        interceptorCfg = new MutableInterceptorConfiguration();
        ((InterceptorConfiguration)interceptorCfg).setName(AUTHENTICATION_SERVICE_NAME);
        ((InterceptorConfiguration)interceptorCfg).setInterceptorClassName(AUTHENTICATION_SERVICE_CLASS);
        list.add(interceptorCfg);
        interceptorCfg = new MutableInterceptorConfiguration();
        ((InterceptorConfiguration)interceptorCfg).setName(REFERRAL_SERVICE_NAME);
        ((InterceptorConfiguration)interceptorCfg).setInterceptorClassName(REFERRAL_SERVICE_CLASS);
        list.add(interceptorCfg);
        interceptorCfg = new MutableInterceptorConfiguration();
        ((InterceptorConfiguration)interceptorCfg).setName(AUTHORIZATION_SERVICE_NAME);
        ((InterceptorConfiguration)interceptorCfg).setInterceptorClassName(AUTHORIZATION_SERVICE_CLASS);
        list.add(interceptorCfg);
        interceptorCfg = new MutableInterceptorConfiguration();
        ((InterceptorConfiguration)interceptorCfg).setName(DEFAULT_AUTHORIZATION_SERVICE_NAME);
        ((InterceptorConfiguration)interceptorCfg).setInterceptorClassName(DEFAULT_AUTHORIZATION_SERVICE_CLASS);
        list.add(interceptorCfg);
        interceptorCfg = new MutableInterceptorConfiguration();
        ((InterceptorConfiguration)interceptorCfg).setName(EXCEPTION_SERVICE_NAME);
        ((InterceptorConfiguration)interceptorCfg).setInterceptorClassName(EXCEPTION_SERVICE_CLASS);
        list.add(interceptorCfg);
        interceptorCfg = new MutableInterceptorConfiguration();
        ((InterceptorConfiguration)interceptorCfg).setName(OPERATIONAL_ATTRIBUTE_SERVICE_NAME);
        ((InterceptorConfiguration)interceptorCfg).setInterceptorClassName(OPERATIONAL_ATTRIBUTE_SERVICE_CLASS);
        list.add(interceptorCfg);
        interceptorCfg = new MutableInterceptorConfiguration();
        ((InterceptorConfiguration)interceptorCfg).setName(SCHEMA_SERVICE_NAME);
        ((InterceptorConfiguration)interceptorCfg).setInterceptorClassName(SCHEMA_SERVICE_CLASS);
        list.add(interceptorCfg);
        interceptorCfg = new MutableInterceptorConfiguration();
        ((InterceptorConfiguration)interceptorCfg).setName(SUBENTRY_SERVICE_NAME);
        ((InterceptorConfiguration)interceptorCfg).setInterceptorClassName(SUBENTRY_SERVICE_CLASS);
        list.add(interceptorCfg);
        interceptorCfg = new MutableInterceptorConfiguration();
        ((InterceptorConfiguration)interceptorCfg).setName(COLLECTIVE_ATTRIBUTE_SERVICE_NAME);
        ((InterceptorConfiguration)interceptorCfg).setInterceptorClassName(COLLECTIVE_ATTRIBUTE_SERVICE_CLASS);
        list.add(interceptorCfg);
        interceptorCfg = new MutableInterceptorConfiguration();
        ((InterceptorConfiguration)interceptorCfg).setName(EVENT_SERVICE_NAME);
        ((InterceptorConfiguration)interceptorCfg).setInterceptorClassName(EVENT_SERVICE_CLASS);
        list.add(interceptorCfg);
        interceptorCfg = new MutableInterceptorConfiguration();
        ((InterceptorConfiguration)interceptorCfg).setName(TRIGGER_SERVICE_NAME);
        ((InterceptorConfiguration)interceptorCfg).setInterceptorClassName(TRIGGER_SERVICE_CLASS);
        list.add(interceptorCfg);
        this.setInterceptorConfigurations(list);
    }

    public Set<AuthenticatorConfiguration> getAuthenticatorConfigurations() {
        HashSet<AuthenticatorConfiguration> cloned = new HashSet<AuthenticatorConfiguration>(this.authenticatorConfigurations.size());
        cloned.addAll(this.authenticatorConfigurations);
        return cloned;
    }

    protected void setAuthenticatorConfigurations(Set<AuthenticatorConfiguration> authenticatorConfigurations) {
        HashSet<String> names = new HashSet<String>();
        for (AuthenticatorConfiguration cfg : authenticatorConfigurations) {
            cfg.validate();
            String name = cfg.getName();
            if (names.contains(name)) {
                log.error("The authenticator nammed '{}' has already been registred.", (Object)name);
                throw new ConfigurationException("Duplicate authenticator name: " + name);
            }
            names.add(name);
        }
        this.authenticatorConfigurations = authenticatorConfigurations;
    }

    public Set<PartitionConfiguration> getPartitionConfigurations() {
        HashSet<PartitionConfiguration> cloned = new HashSet<PartitionConfiguration>();
        cloned.addAll(this.partitionConfigurations);
        return cloned;
    }

    protected void setPartitionConfigurations(Set<? extends PartitionConfiguration> contextParitionConfigurations) {
        HashSet<? extends PartitionConfiguration> cloned = new HashSet<PartitionConfiguration>();
        cloned.addAll(contextParitionConfigurations);
        HashSet<String> names = new HashSet<String>();
        for (PartitionConfiguration partitionConfiguration : cloned) {
            partitionConfiguration.validate();
            String id = partitionConfiguration.getId();
            if (names.contains(id)) {
                throw new ConfigurationException("Duplicate partition id: " + id);
            }
            names.add(id);
        }
        this.partitionConfigurations = cloned;
    }

    public boolean isAccessControlEnabled() {
        return this.accessControlEnabled;
    }

    protected void setAccessControlEnabled(boolean accessControlEnabled) {
        this.accessControlEnabled = accessControlEnabled;
    }

    public boolean isAllowAnonymousAccess() {
        return this.allowAnonymousAccess;
    }

    protected void setAllowAnonymousAccess(boolean enableAnonymousAccess) {
        this.allowAnonymousAccess = enableAnonymousAccess;
    }

    public List<InterceptorConfiguration> getInterceptorConfigurations() {
        ArrayList<InterceptorConfiguration> cloned = new ArrayList<InterceptorConfiguration>();
        cloned.addAll(this.interceptorConfigurations);
        return cloned;
    }

    protected void setInterceptorConfigurations(List<InterceptorConfiguration> interceptorConfigurations) {
        ArrayList<InterceptorConfiguration> cloned = new ArrayList<InterceptorConfiguration>();
        cloned.addAll(interceptorConfigurations);
        HashSet<String> names = new HashSet<String>();
        for (InterceptorConfiguration cfg : cloned) {
            cfg.validate();
            String name = cfg.getName();
            if (names.contains(name)) {
                throw new ConfigurationException("Duplicate interceptor name: " + name);
            }
            names.add(name);
        }
        this.interceptorConfigurations = interceptorConfigurations;
    }

    public List<Entry> getTestEntries() {
        ArrayList<Entry> cloned = new ArrayList<Entry>();
        cloned.addAll(this.testEntries);
        return cloned;
    }

    protected void setTestEntries(List<Entry> testEntries) {
        ArrayList<Entry> cloned = new ArrayList<Entry>();
        cloned.addAll(testEntries);
        this.testEntries = testEntries;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    protected void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    @Override
    public void validate() {
        this.setWorkingDirectory(this.workingDirectory);
    }

    protected void setShutdownHookEnabled(boolean shutdownHookEnabled) {
        this.shutdownHookEnabled = shutdownHookEnabled;
    }

    public boolean isShutdownHookEnabled() {
        return this.shutdownHookEnabled;
    }

    protected void setExitVmOnShutdown(boolean exitVmOnShutdown) {
        this.exitVmOnShutdown = exitVmOnShutdown;
    }

    public boolean isExitVmOnShutdown() {
        return this.exitVmOnShutdown;
    }

    protected void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
        if (maxThreads < 1) {
            throw new IllegalArgumentException("Number of max threads should be greater than 0");
        }
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    protected void setMaxSizeLimit(int maxSizeLimit) {
        this.maxSizeLimit = maxSizeLimit;
    }

    public int getMaxSizeLimit() {
        return this.maxSizeLimit;
    }

    protected void setMaxTimeLimit(int maxTimeLimit) {
        this.maxTimeLimit = maxTimeLimit;
    }

    public int getMaxTimeLimit() {
        return this.maxTimeLimit;
    }

    protected void setSystemPartitionConfiguration(PartitionConfiguration systemPartitionConfiguration) {
        this.systemPartitionConfiguration = systemPartitionConfiguration;
    }

    public PartitionConfiguration getSystemPartitionConfiguration() {
        return this.systemPartitionConfiguration;
    }

    public boolean isDenormalizeOpAttrsEnabled() {
        return this.denormalizeOpAttrsEnabled;
    }

    protected void setDenormalizeOpAttrsEnabled(boolean denormalizeOpAttrsEnabled) {
        this.denormalizeOpAttrsEnabled = denormalizeOpAttrsEnabled;
    }
}

