/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.interceptor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.naming.ConfigurationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import org.apache.directory.server.core.DirectoryServiceConfiguration;
import org.apache.directory.server.core.configuration.InterceptorConfiguration;
import org.apache.directory.server.core.interceptor.Interceptor;
import org.apache.directory.server.core.interceptor.InterceptorException;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddContextPartitionOperationContext;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.GetMatchedNameOperationContext;
import org.apache.directory.server.core.interceptor.context.GetRootDSEOperationContext;
import org.apache.directory.server.core.interceptor.context.GetSuffixOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.ListSuffixOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.RemoveContextPartitionOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.interceptor.context.UnbindOperationContext;
import org.apache.directory.server.core.invocation.Invocation;
import org.apache.directory.server.core.invocation.InvocationStack;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.shared.ldap.exception.LdapConfigurationException;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorChain {
    private static final Logger log = LoggerFactory.getLogger(InterceptorChain.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    private final Interceptor FINAL_INTERCEPTOR = new Interceptor(){
        private PartitionNexus nexus;

        @Override
        public void init(DirectoryServiceConfiguration factoryCfg, InterceptorConfiguration cfg) {
            this.nexus = factoryCfg.getPartitionNexus();
        }

        @Override
        public void destroy() {
        }

        @Override
        public boolean compare(NextInterceptor next, CompareOperationContext opContext) throws NamingException {
            return this.nexus.compare(opContext);
        }

        @Override
        public Attributes getRootDSE(NextInterceptor next, GetRootDSEOperationContext opContext) throws NamingException {
            return this.nexus.getRootDSE(opContext);
        }

        @Override
        public LdapDN getMatchedName(NextInterceptor next, GetMatchedNameOperationContext opContext) throws NamingException {
            return (LdapDN)this.nexus.getMatchedName(opContext).clone();
        }

        @Override
        public LdapDN getSuffix(NextInterceptor next, GetSuffixOperationContext opContext) throws NamingException {
            return (LdapDN)this.nexus.getSuffix(opContext).clone();
        }

        @Override
        public Iterator<String> listSuffixes(NextInterceptor next, ListSuffixOperationContext opContext) throws NamingException {
            return this.nexus.listSuffixes(opContext);
        }

        @Override
        public void delete(NextInterceptor next, DeleteOperationContext opContext) throws NamingException {
            this.nexus.delete(opContext);
        }

        @Override
        public void add(NextInterceptor next, AddOperationContext opContext) throws NamingException {
            this.nexus.add(opContext);
        }

        @Override
        public void modify(NextInterceptor next, ModifyOperationContext opContext) throws NamingException {
            this.nexus.modify(opContext);
        }

        @Override
        public NamingEnumeration<SearchResult> list(NextInterceptor next, ListOperationContext opContext) throws NamingException {
            return this.nexus.list(opContext);
        }

        @Override
        public NamingEnumeration<SearchResult> search(NextInterceptor next, SearchOperationContext opContext) throws NamingException {
            return this.nexus.search(opContext);
        }

        @Override
        public Attributes lookup(NextInterceptor next, LookupOperationContext opContext) throws NamingException {
            return (Attributes)this.nexus.lookup(opContext).clone();
        }

        @Override
        public boolean hasEntry(NextInterceptor next, EntryOperationContext opContext) throws NamingException {
            return this.nexus.hasEntry(opContext);
        }

        @Override
        public void rename(NextInterceptor next, RenameOperationContext opContext) throws NamingException {
            this.nexus.rename(opContext);
        }

        @Override
        public void move(NextInterceptor next, MoveOperationContext opContext) throws NamingException {
            this.nexus.move(opContext);
        }

        @Override
        public void moveAndRename(NextInterceptor next, MoveAndRenameOperationContext opContext) throws NamingException {
            this.nexus.moveAndRename(opContext);
        }

        @Override
        public void addContextPartition(NextInterceptor next, AddContextPartitionOperationContext opContext) throws NamingException {
            this.nexus.addContextPartition(opContext);
        }

        @Override
        public void removeContextPartition(NextInterceptor next, RemoveContextPartitionOperationContext opContext) throws NamingException {
            this.nexus.removeContextPartition(opContext);
        }

        @Override
        public void bind(NextInterceptor next, BindOperationContext opContext) throws NamingException {
            this.nexus.bind(opContext);
        }

        @Override
        public void unbind(NextInterceptor next, UnbindOperationContext opContext) throws NamingException {
            this.nexus.unbind(opContext);
        }
    };
    private final Map<String, Entry> name2entry = new HashMap<String, Entry>();
    private final Entry tail;
    private Entry head = this.tail = new Entry("tail", null, null, this.FINAL_INTERCEPTOR);
    private DirectoryServiceConfiguration factoryCfg;

    public synchronized void init(DirectoryServiceConfiguration factoryCfg) throws NamingException {
        this.factoryCfg = factoryCfg;
        this.FINAL_INTERCEPTOR.init(factoryCfg, null);
        ListIterator<InterceptorConfiguration> i = factoryCfg.getStartupConfiguration().getInterceptorConfigurations().listIterator();
        Interceptor interceptor = null;
        try {
            while (i.hasNext()) {
                InterceptorConfiguration cfg = i.next();
                if (IS_DEBUG) {
                    log.debug("Adding interceptor " + cfg.getName());
                }
                this.register(cfg);
            }
        }
        catch (Throwable t) {
            this.destroy();
            if (t instanceof NamingException) {
                throw (NamingException)t;
            }
            throw new InterceptorException(interceptor, "Failed to initialize interceptor chain.", t);
        }
    }

    public synchronized void destroy() {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        Entry e = this.tail;
        do {
            entries.add(e);
        } while ((e = e.prevEntry) != null);
        for (Entry entry : entries) {
            if (entry == this.tail) continue;
            try {
                this.deregister(entry.getName());
            }
            catch (Throwable t) {
                log.warn("Failed to deregister an interceptor: " + entry.getName(), t);
            }
        }
    }

    public Interceptor get(String interceptorName) {
        Entry e = this.name2entry.get(interceptorName);
        if (e == null) {
            return null;
        }
        return e.interceptor;
    }

    public synchronized List<Interceptor> getAll() {
        ArrayList<Interceptor> result = new ArrayList<Interceptor>();
        Entry e = this.head;
        do {
            result.add(e.interceptor);
        } while ((e = e.nextEntry) != this.tail);
        return result;
    }

    public synchronized void addFirst(InterceptorConfiguration cfg) throws NamingException {
        this.register0(cfg, this.head);
    }

    public synchronized void addLast(InterceptorConfiguration cfg) throws NamingException {
        this.register0(cfg, this.tail);
    }

    public synchronized void addBefore(String nextInterceptorName, InterceptorConfiguration cfg) throws NamingException {
        Entry e = this.name2entry.get(nextInterceptorName);
        if (e == null) {
            throw new ConfigurationException("Interceptor not found: " + nextInterceptorName);
        }
        this.register0(cfg, e);
    }

    public synchronized String remove(String interceptorName) throws NamingException {
        return this.deregister(interceptorName);
    }

    public synchronized void addAfter(String prevInterceptorName, InterceptorConfiguration cfg) throws NamingException {
        Entry e = this.name2entry.get(prevInterceptorName);
        if (e == null) {
            throw new ConfigurationException("Interceptor not found: " + prevInterceptorName);
        }
        this.register0(cfg, e.nextEntry);
    }

    private void register(InterceptorConfiguration cfg) throws NamingException {
        this.checkAddable(cfg);
        this.register0(cfg, this.tail);
    }

    private String deregister(String name) throws ConfigurationException {
        Entry entry = this.checkOldName(name);
        Entry prevEntry = entry.prevEntry;
        Entry nextEntry = entry.nextEntry;
        if (nextEntry == null) {
            return null;
        }
        if (prevEntry == null) {
            nextEntry.prevEntry = null;
            this.head = nextEntry;
        } else {
            prevEntry.nextEntry = nextEntry;
            nextEntry.prevEntry = prevEntry;
        }
        this.name2entry.remove(name);
        entry.interceptor.destroy();
        return entry.getName();
    }

    private Interceptor getInterceptorInstance(InterceptorConfiguration interceptorConfiguration) throws NamingException {
        Class<?> interceptorClass = null;
        Interceptor interceptor = null;
        try {
            interceptorClass = Class.forName(interceptorConfiguration.getInterceptorClassName());
        }
        catch (ClassNotFoundException e) {
            LdapConfigurationException lce = new LdapConfigurationException("Failed to load interceptor class '" + interceptorConfiguration.getInterceptorClassName() + "' for interceptor named '" + interceptorConfiguration.getName());
            lce.setRootCause((Throwable)e);
            throw lce;
        }
        try {
            interceptor = (Interceptor)interceptorClass.newInstance();
        }
        catch (Exception e) {
            LdapConfigurationException lce = new LdapConfigurationException("Failed while trying to instantiate interceptor class '" + interceptorConfiguration.getInterceptorClassName() + "' for interceptor named '" + interceptorConfiguration.getName());
            lce.setRootCause((Throwable)e);
            throw lce;
        }
        return interceptor;
    }

    private void register0(InterceptorConfiguration cfg, Entry nextEntry) throws NamingException {
        Entry newEntry;
        String name = cfg.getName();
        Interceptor interceptor = this.getInterceptorInstance(cfg);
        interceptor.init(this.factoryCfg, cfg);
        if (nextEntry == this.head) {
            newEntry = new Entry(cfg.getName(), null, this.head, interceptor);
            this.head.prevEntry = newEntry;
            this.head = newEntry;
        } else if (this.head == this.tail) {
            newEntry = new Entry(cfg.getName(), null, this.tail, interceptor);
            this.tail.prevEntry = newEntry;
            this.head = newEntry;
        } else {
            newEntry = new Entry(cfg.getName(), nextEntry.prevEntry, nextEntry, interceptor);
            nextEntry.prevEntry.nextEntry = newEntry;
            nextEntry.prevEntry = newEntry;
        }
        this.name2entry.put(name, newEntry);
    }

    private Entry checkOldName(String baseName) throws ConfigurationException {
        Entry e = this.name2entry.get(baseName);
        if (e == null) {
            throw new ConfigurationException("Unknown interceptor name:" + baseName);
        }
        return e;
    }

    private void checkAddable(InterceptorConfiguration cfg) throws ConfigurationException {
        if (this.name2entry.containsKey(cfg.getName())) {
            throw new ConfigurationException("Other interceptor is using name '" + cfg.getName() + "'");
        }
    }

    private Entry getStartingEntry() {
        if (InvocationStack.getInstance().isEmpty()) {
            return this.head;
        }
        Invocation invocation = InvocationStack.getInstance().peek();
        if (!invocation.hasBypass()) {
            return this.head;
        }
        if (invocation.isBypassed("*")) {
            return this.tail;
        }
        Entry next = this.head;
        while (next != this.tail) {
            if (invocation.isBypassed(next.getName())) {
                next = next.nextEntry;
                continue;
            }
            return next;
        }
        return this.tail;
    }

    public Attributes getRootDSE(GetRootDSEOperationContext opContext) throws NamingException {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.interceptor;
        NextInterceptor next = entry.nextInterceptor;
        try {
            return head.getRootDSE(next, opContext);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
            throw new InternalError();
        }
    }

    public LdapDN getMatchedName(GetMatchedNameOperationContext opContext) throws NamingException {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.interceptor;
        NextInterceptor next = entry.nextInterceptor;
        try {
            return head.getMatchedName(next, opContext);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
            throw new InternalError();
        }
    }

    public LdapDN getSuffix(GetSuffixOperationContext opContext) throws NamingException {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.interceptor;
        NextInterceptor next = entry.nextInterceptor;
        try {
            return head.getSuffix(next, opContext);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
            throw new InternalError();
        }
    }

    public boolean compare(CompareOperationContext opContext) throws NamingException {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.interceptor;
        NextInterceptor next = entry.nextInterceptor;
        try {
            return head.compare(next, opContext);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
            throw new InternalError();
        }
    }

    public Iterator<String> listSuffixes(ListSuffixOperationContext opContext) throws NamingException {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.interceptor;
        NextInterceptor next = entry.nextInterceptor;
        try {
            return head.listSuffixes(next, opContext);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
            throw new InternalError();
        }
    }

    public void addContextPartition(AddContextPartitionOperationContext opContext) throws NamingException {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.interceptor;
        NextInterceptor next = entry.nextInterceptor;
        try {
            head.addContextPartition(next, opContext);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
            throw new InternalError();
        }
    }

    public void removeContextPartition(RemoveContextPartitionOperationContext opContext) throws NamingException {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.interceptor;
        NextInterceptor next = entry.nextInterceptor;
        try {
            head.removeContextPartition(next, opContext);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
            throw new InternalError();
        }
    }

    public void delete(DeleteOperationContext opContext) throws NamingException {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.interceptor;
        NextInterceptor next = entry.nextInterceptor;
        try {
            head.delete(next, opContext);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
        }
    }

    public void add(AddOperationContext opContext) throws NamingException {
        Entry node = this.getStartingEntry();
        Interceptor head = node.interceptor;
        NextInterceptor next = node.nextInterceptor;
        try {
            head.add(next, opContext);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
        }
    }

    public void bind(BindOperationContext opContext) throws NamingException {
        Entry node = this.getStartingEntry();
        Interceptor head = node.interceptor;
        NextInterceptor next = node.nextInterceptor;
        try {
            head.bind(next, opContext);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
        }
    }

    public void unbind(UnbindOperationContext opContext) throws NamingException {
        Entry node = this.getStartingEntry();
        Interceptor head = node.interceptor;
        NextInterceptor next = node.nextInterceptor;
        try {
            head.unbind(next, opContext);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
        }
    }

    public void modify(ModifyOperationContext opContext) throws NamingException {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.interceptor;
        NextInterceptor next = entry.nextInterceptor;
        try {
            head.modify(next, opContext);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
        }
    }

    public NamingEnumeration<SearchResult> list(ListOperationContext opContext) throws NamingException {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.interceptor;
        NextInterceptor next = entry.nextInterceptor;
        try {
            return head.list(next, opContext);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
            throw new InternalError();
        }
    }

    public NamingEnumeration<SearchResult> search(SearchOperationContext opContext) throws NamingException {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.interceptor;
        NextInterceptor next = entry.nextInterceptor;
        try {
            return head.search(next, opContext);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
            throw new InternalError();
        }
    }

    public Attributes lookup(LookupOperationContext opContext) throws NamingException {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.interceptor;
        NextInterceptor next = entry.nextInterceptor;
        try {
            return head.lookup(next, opContext);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
            throw new InternalError();
        }
    }

    public boolean hasEntry(EntryOperationContext opContext) throws NamingException {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.interceptor;
        NextInterceptor next = entry.nextInterceptor;
        try {
            return head.hasEntry(next, opContext);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
            throw new InternalError();
        }
    }

    public void rename(RenameOperationContext opContext) throws NamingException {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.interceptor;
        NextInterceptor next = entry.nextInterceptor;
        try {
            head.rename(next, opContext);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
        }
    }

    public void move(MoveOperationContext opContext) throws NamingException {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.interceptor;
        NextInterceptor next = entry.nextInterceptor;
        try {
            head.move(next, opContext);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
        }
    }

    public void moveAndRename(MoveAndRenameOperationContext opContext) throws NamingException {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.interceptor;
        NextInterceptor next = entry.nextInterceptor;
        try {
            head.moveAndRename(next, opContext);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
        }
    }

    private static void throwInterceptorException(Interceptor interceptor, Throwable e) throws InterceptorException {
        throw new InterceptorException(interceptor, "Unexpected exception.", e);
    }

    private class Entry {
        private Entry prevEntry;
        private Entry nextEntry;
        private final String name;
        private final Interceptor interceptor;
        private final NextInterceptor nextInterceptor;

        private final String getName() {
            return this.name;
        }

        private Entry(String name, Entry prevEntry, Entry nextEntry, Interceptor interceptor) {
            this.name = name;
            if (interceptor == null) {
                throw new NullPointerException("interceptor");
            }
            this.prevEntry = prevEntry;
            this.nextEntry = nextEntry;
            this.interceptor = interceptor;
            this.nextInterceptor = new NextInterceptor(){

                private Entry getNextEntry() {
                    if (InvocationStack.getInstance().isEmpty()) {
                        return Entry.this.nextEntry;
                    }
                    Invocation invocation = InvocationStack.getInstance().peek();
                    if (!invocation.hasBypass()) {
                        return Entry.this.nextEntry;
                    }
                    Entry next = Entry.this.nextEntry;
                    while (next != InterceptorChain.this.tail) {
                        if (invocation.isBypassed(next.getName())) {
                            next = next.nextEntry;
                            continue;
                        }
                        return next;
                    }
                    return next;
                }

                @Override
                public boolean compare(CompareOperationContext opContext) throws NamingException {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        return interceptor.compare(next.nextInterceptor, opContext);
                    }
                    catch (NamingException ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                        throw new InternalError();
                    }
                }

                @Override
                public Attributes getRootDSE(GetRootDSEOperationContext opContext) throws NamingException {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        return interceptor.getRootDSE(next.nextInterceptor, opContext);
                    }
                    catch (NamingException ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                        throw new InternalError();
                    }
                }

                @Override
                public LdapDN getMatchedName(GetMatchedNameOperationContext opContext) throws NamingException {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        return interceptor.getMatchedName(next.nextInterceptor, opContext);
                    }
                    catch (NamingException ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                        throw new InternalError();
                    }
                }

                @Override
                public LdapDN getSuffix(GetSuffixOperationContext opContext) throws NamingException {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        return interceptor.getSuffix(next.nextInterceptor, opContext);
                    }
                    catch (NamingException ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                        throw new InternalError();
                    }
                }

                @Override
                public Iterator<String> listSuffixes(ListSuffixOperationContext opContext) throws NamingException {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        return interceptor.listSuffixes(next.nextInterceptor, opContext);
                    }
                    catch (NamingException ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                        throw new InternalError();
                    }
                }

                @Override
                public void delete(DeleteOperationContext opContext) throws NamingException {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        interceptor.delete(next.nextInterceptor, opContext);
                    }
                    catch (NamingException ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                    }
                }

                @Override
                public void add(AddOperationContext opContext) throws NamingException {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        interceptor.add(next.nextInterceptor, opContext);
                    }
                    catch (NamingException ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                    }
                }

                @Override
                public void modify(ModifyOperationContext opContext) throws NamingException {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        interceptor.modify(next.nextInterceptor, opContext);
                    }
                    catch (NamingException ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                    }
                }

                @Override
                public NamingEnumeration<SearchResult> list(ListOperationContext opContext) throws NamingException {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        return interceptor.list(next.nextInterceptor, opContext);
                    }
                    catch (NamingException ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                        throw new InternalError();
                    }
                }

                @Override
                public NamingEnumeration<SearchResult> search(SearchOperationContext opContext) throws NamingException {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        return interceptor.search(next.nextInterceptor, opContext);
                    }
                    catch (NamingException ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                        throw new InternalError();
                    }
                }

                @Override
                public Attributes lookup(LookupOperationContext opContext) throws NamingException {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        return interceptor.lookup(next.nextInterceptor, opContext);
                    }
                    catch (NamingException ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                        throw new InternalError();
                    }
                }

                @Override
                public boolean hasEntry(EntryOperationContext opContext) throws NamingException {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        return interceptor.hasEntry(next.nextInterceptor, opContext);
                    }
                    catch (NamingException ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                        throw new InternalError();
                    }
                }

                @Override
                public void rename(RenameOperationContext opContext) throws NamingException {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        interceptor.rename(next.nextInterceptor, opContext);
                    }
                    catch (NamingException ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                    }
                }

                @Override
                public void move(MoveOperationContext opContext) throws NamingException {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        interceptor.move(next.nextInterceptor, opContext);
                    }
                    catch (NamingException ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                    }
                }

                @Override
                public void moveAndRename(MoveAndRenameOperationContext opContext) throws NamingException {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        interceptor.moveAndRename(next.nextInterceptor, opContext);
                    }
                    catch (NamingException ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                    }
                }

                @Override
                public void bind(BindOperationContext opContext) throws NamingException {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        interceptor.bind(next.nextInterceptor, opContext);
                    }
                    catch (NamingException ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                    }
                }

                @Override
                public void unbind(UnbindOperationContext opContext) throws NamingException {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        interceptor.unbind(next.nextInterceptor, opContext);
                    }
                    catch (NamingException ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                    }
                }

                @Override
                public void addContextPartition(AddContextPartitionOperationContext opContext) throws NamingException {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        interceptor.addContextPartition(next.nextInterceptor, opContext);
                    }
                    catch (NamingException ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                        throw new InternalError();
                    }
                }

                @Override
                public void removeContextPartition(RemoveContextPartitionOperationContext opContext) throws NamingException {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.interceptor;
                    try {
                        interceptor.removeContextPartition(next.nextInterceptor, opContext);
                    }
                    catch (NamingException ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                        throw new InternalError();
                    }
                }
            };
        }
    }
}

