/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.interceptor.context;

import javax.naming.NamingException;
import org.apache.directory.server.core.configuration.PartitionConfiguration;
import org.apache.directory.server.core.interceptor.context.EmptyOperationContext;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.shared.ldap.exception.LdapConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddContextPartitionOperationContext
extends EmptyOperationContext {
    private static final Logger log = LoggerFactory.getLogger(AddContextPartitionOperationContext.class);
    private PartitionConfiguration partitionConfiguration;
    private Partition partition;

    public AddContextPartitionOperationContext(PartitionConfiguration cfg) {
        this.partitionConfiguration = cfg;
    }

    public AddContextPartitionOperationContext(PartitionConfiguration cfg, Partition partition) {
        this(cfg);
        this.partition = partition;
    }

    public String toString() {
        return "AddContextPartitionOperationContext for partition context '" + this.partitionConfiguration.getId() + "'";
    }

    public PartitionConfiguration getPartitionConfiguration() {
        return this.partitionConfiguration;
    }

    public void setPartitionConfiguration(PartitionConfiguration partitionConfiguration) {
        this.partitionConfiguration = partitionConfiguration;
    }

    public Partition getPartition() throws NamingException {
        Class<?> partitionClass;
        if (this.partition != null) {
            return this.partition;
        }
        if (this.partitionConfiguration == null) {
            throw new IllegalStateException("Cannot get instance of partition without a proper partition configuration.");
        }
        try {
            partitionClass = Class.forName(this.partitionConfiguration.getPartitionClassName());
        }
        catch (ClassNotFoundException e) {
            String msg = "Could not load partition implementation class '" + this.partitionConfiguration.getPartitionClassName() + "' for partition with id " + this.partitionConfiguration.getId();
            log.error(msg);
            throw new LdapConfigurationException(msg, (Throwable)e);
        }
        try {
            this.partition = (Partition)partitionClass.newInstance();
        }
        catch (InstantiationException e) {
            String msg = "No default constructor in partition implementation class '" + this.partitionConfiguration.getPartitionClassName() + "' for partition with id " + this.partitionConfiguration.getId();
            log.error(msg);
            throw new LdapConfigurationException(msg, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            String msg = "Default constructor for partition implementation class '" + this.partitionConfiguration.getPartitionClassName() + "' for partition with id " + this.partitionConfiguration.getId() + " is not publicly accessible.";
            log.error(msg);
            throw new LdapConfigurationException(msg, (Throwable)e);
        }
        return this.partition;
    }
}

