/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.operational;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.directory.server.core.DirectoryServiceConfiguration;
import org.apache.directory.server.core.configuration.InterceptorConfiguration;
import org.apache.directory.server.core.enumeration.SearchResultFilter;
import org.apache.directory.server.core.enumeration.SearchResultFilteringEnumeration;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.invocation.Invocation;
import org.apache.directory.server.core.invocation.InvocationStack;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.shared.ldap.message.AttributeImpl;
import org.apache.directory.shared.ldap.message.AttributesImpl;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.name.AttributeTypeAndValue;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.UsageEnum;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.apache.directory.shared.ldap.util.DateUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationalAttributeService
extends BaseInterceptor {
    private final SearchResultFilter DENORMALIZING_SEARCH_FILTER = new SearchResultFilter(){

        public boolean accept(Invocation invocation, SearchResult result, SearchControls controls) throws NamingException {
            if (controls.getReturningAttributes() != null) {
                return OperationalAttributeService.this.filterDenormalized(result.getAttributes());
            }
            return true;
        }
    };
    private final SearchResultFilter SEARCH_FILTER = new SearchResultFilter(){

        public boolean accept(Invocation invocation, SearchResult result, SearchControls controls) throws NamingException {
            if (controls.getReturningAttributes() == null) {
                return OperationalAttributeService.this.filter(result.getAttributes());
            }
            return true;
        }
    };
    private PartitionNexus nexus;
    private AttributeTypeRegistry registry;
    private boolean isDenormalizeOpAttrsEnabled;
    private LdapDN subschemaSubentryDn;

    @Override
    public void init(DirectoryServiceConfiguration factoryCfg, InterceptorConfiguration cfg) throws NamingException {
        this.nexus = factoryCfg.getPartitionNexus();
        this.registry = factoryCfg.getRegistries().getAttributeTypeRegistry();
        this.isDenormalizeOpAttrsEnabled = factoryCfg.getStartupConfiguration().isDenormalizeOpAttrsEnabled();
        String subschemaSubentry = (String)this.nexus.getRootDSE(null).get("subschemaSubentry").get();
        this.subschemaSubentryDn = new LdapDN(subschemaSubentry);
        this.subschemaSubentryDn.normalize(factoryCfg.getRegistries().getAttributeTypeRegistry().getNormalizerMapping());
    }

    @Override
    public void destroy() {
    }

    @Override
    public void add(NextInterceptor nextInterceptor, AddOperationContext opContext) throws NamingException {
        String principal = OperationalAttributeService.getPrincipal().getName();
        Attributes entry = opContext.getEntry();
        AttributeImpl attribute = new AttributeImpl("creatorsName");
        attribute.add(principal);
        entry.put((Attribute)attribute);
        attribute = new AttributeImpl("createTimestamp");
        attribute.add(DateUtils.getGeneralizedTime());
        entry.put((Attribute)attribute);
        nextInterceptor.add(opContext);
    }

    @Override
    public void modify(NextInterceptor nextInterceptor, ModifyOperationContext opContext) throws NamingException {
        ArrayList<ModificationItemImpl> modItemList = new ArrayList<ModificationItemImpl>(opContext.getModItems().length + 2);
        Collections.addAll(modItemList, opContext.getModItems());
        AttributeImpl attribute = new AttributeImpl("modifiersName");
        attribute.add(OperationalAttributeService.getPrincipal().getName());
        modItemList.add(new ModificationItemImpl(2, (Attribute)attribute));
        attribute = new AttributeImpl("modifyTimestamp");
        attribute.add(DateUtils.getGeneralizedTime());
        modItemList.add(new ModificationItemImpl(2, (Attribute)attribute));
        nextInterceptor.modify(opContext);
    }

    @Override
    public void rename(NextInterceptor nextInterceptor, RenameOperationContext opContext) throws NamingException {
        nextInterceptor.rename(opContext);
        AttributesImpl attributes = new AttributesImpl(true);
        AttributeImpl attribute = new AttributeImpl("modifiersName");
        attribute.add(OperationalAttributeService.getPrincipal().getName());
        attributes.put((Attribute)attribute);
        attribute = new AttributeImpl("modifyTimestamp");
        attribute.add(DateUtils.getGeneralizedTime());
        attributes.put((Attribute)attribute);
        LdapDN newDn = (LdapDN)opContext.getDn().clone();
        newDn.remove(opContext.getDn().size() - 1);
        newDn.add(opContext.getNewRdn());
        newDn.normalize(this.registry.getNormalizerMapping());
        ModificationItemImpl[] items = ModifyOperationContext.createModItems((Attributes)attributes, 2);
        ModifyOperationContext newModify = new ModifyOperationContext(newDn, items);
        this.nexus.modify(newModify);
    }

    @Override
    public void move(NextInterceptor nextInterceptor, MoveOperationContext opContext) throws NamingException {
        nextInterceptor.move(opContext);
        AttributesImpl attributes = new AttributesImpl(true);
        AttributeImpl attribute = new AttributeImpl("modifiersName");
        attribute.add(OperationalAttributeService.getPrincipal().getName());
        attributes.put((Attribute)attribute);
        attribute = new AttributeImpl("modifyTimestamp");
        attribute.add(DateUtils.getGeneralizedTime());
        attributes.put((Attribute)attribute);
        ModificationItemImpl[] items = ModifyOperationContext.createModItems((Attributes)attributes, 2);
        ModifyOperationContext newModify = new ModifyOperationContext(opContext.getParent(), items);
        this.nexus.modify(newModify);
    }

    @Override
    public void moveAndRename(NextInterceptor nextInterceptor, MoveAndRenameOperationContext opContext) throws NamingException {
        nextInterceptor.moveAndRename(opContext);
        AttributesImpl attributes = new AttributesImpl(true);
        AttributeImpl attribute = new AttributeImpl("modifiersName");
        attribute.add(OperationalAttributeService.getPrincipal().getName());
        attributes.put((Attribute)attribute);
        attribute = new AttributeImpl("modifyTimestamp");
        attribute.add(DateUtils.getGeneralizedTime());
        attributes.put((Attribute)attribute);
        ModificationItemImpl[] items = ModifyOperationContext.createModItems((Attributes)attributes, 2);
        ModifyOperationContext newModify = new ModifyOperationContext(opContext.getParent(), items);
        this.nexus.modify(newModify);
    }

    @Override
    public Attributes lookup(NextInterceptor nextInterceptor, LookupOperationContext opContext) throws NamingException {
        Attributes result = nextInterceptor.lookup(opContext);
        if (result == null) {
            return null;
        }
        if (opContext.getAttrsId() == null) {
            this.filter(result);
        } else {
            this.filter(opContext, result);
        }
        return result;
    }

    public NamingEnumeration list(NextInterceptor nextInterceptor, ListOperationContext opContext) throws NamingException {
        NamingEnumeration<SearchResult> e = nextInterceptor.list(opContext);
        Invocation invocation = InvocationStack.getInstance().peek();
        return new SearchResultFilteringEnumeration(e, new SearchControls(), invocation, this.SEARCH_FILTER, "List Operational Filter");
    }

    @Override
    public NamingEnumeration<SearchResult> search(NextInterceptor nextInterceptor, SearchOperationContext opContext) throws NamingException {
        Invocation invocation = InvocationStack.getInstance().peek();
        NamingEnumeration<SearchResult> e = nextInterceptor.search(opContext);
        SearchControls searchCtls = opContext.getSearchControls();
        if (searchCtls.getReturningAttributes() != null) {
            if (this.isDenormalizeOpAttrsEnabled) {
                return new SearchResultFilteringEnumeration(e, searchCtls, invocation, this.DENORMALIZING_SEARCH_FILTER, "Search Operational Filter denormalized");
            }
            return e;
        }
        return new SearchResultFilteringEnumeration(e, searchCtls, invocation, this.SEARCH_FILTER, "Search Operational Filter");
    }

    private boolean filter(Attributes attributes) throws NamingException {
        NamingEnumeration<String> list = attributes.getIDs();
        while (list.hasMore()) {
            String attrId = list.next();
            AttributeType type = null;
            if (this.registry.hasAttributeType(attrId)) {
                type = this.registry.lookup(attrId);
            }
            if (type == null || type.getUsage() == UsageEnum.USER_APPLICATIONS) continue;
            attributes.remove(attrId);
        }
        return true;
    }

    private void filter(LookupOperationContext lookupContext, Attributes entry) throws NamingException {
        LdapDN dn = lookupContext.getDn();
        List<String> ids = lookupContext.getAttrsId();
        if (ids == null) {
            this.filter(entry);
            return;
        }
        if (dn.size() == 0) {
            HashSet<String> idsSet = new HashSet<String>(ids.size());
            for (String id : ids) {
                idsSet.add(id.toLowerCase());
            }
            NamingEnumeration<String> list = entry.getIDs();
            while (list.hasMore()) {
                String attrId = ((String)list.nextElement()).toLowerCase();
                if (idsSet.contains(attrId)) continue;
                entry.remove(attrId);
            }
        }
        this.denormalizeEntryOpAttrs(entry);
    }

    public void denormalizeEntryOpAttrs(Attributes entry) throws NamingException {
        if (this.isDenormalizeOpAttrsEnabled) {
            LdapDN modifiersName;
            AttributeType type = this.registry.lookup("creatorsName");
            Attribute attr = AttributeUtils.getAttribute((Attributes)entry, (AttributeType)type);
            if (attr != null) {
                LdapDN creatorsName = new LdapDN((String)attr.get());
                attr.clear();
                attr.add(this.denormalizeTypes(creatorsName).getUpName());
            }
            type = null;
            type = this.registry.lookup("modifiersName");
            attr = null;
            attr = AttributeUtils.getAttribute((Attributes)entry, (AttributeType)type);
            if (attr != null) {
                modifiersName = new LdapDN((String)attr.get());
                attr.clear();
                attr.add(this.denormalizeTypes(modifiersName).getUpName());
            }
            type = null;
            type = this.registry.lookup("schemaModifiersName");
            attr = null;
            attr = AttributeUtils.getAttribute((Attributes)entry, (AttributeType)type);
            if (attr != null) {
                modifiersName = new LdapDN((String)attr.get());
                attr.clear();
                attr.add(this.denormalizeTypes(modifiersName).getUpName());
            }
        }
    }

    public LdapDN denormalizeTypes(LdapDN dn) throws NamingException {
        LdapDN newDn = new LdapDN();
        for (int ii = 0; ii < dn.size(); ++ii) {
            Rdn rdn = dn.getRdn(ii);
            if (rdn.size() == 0) {
                newDn.add(new Rdn());
                continue;
            }
            if (rdn.size() == 1) {
                String name = this.registry.lookup(rdn.getNormType()).getName();
                String value = (String)rdn.getAtav().getValue();
                newDn.add(new Rdn(name, name, value, value));
                continue;
            }
            StringBuffer buf = new StringBuffer();
            Iterator jj = rdn.iterator();
            while (jj.hasNext()) {
                AttributeTypeAndValue atav = (AttributeTypeAndValue)jj.next();
                String type = this.registry.lookup(rdn.getNormType()).getName();
                buf.append(type).append('=').append(atav.getValue());
                if (!jj.hasNext()) continue;
                buf.append('+');
            }
            newDn.add(new Rdn(buf.toString()));
        }
        return newDn;
    }

    private boolean filterDenormalized(Attributes entry) throws NamingException {
        this.denormalizeEntryOpAttrs(entry);
        return true;
    }
}

