/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.directory.server.core.DirectoryServiceConfiguration;
import org.apache.directory.server.core.configuration.PartitionConfiguration;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.partition.impl.btree.BTreePartitionConfiguration;
import org.apache.directory.server.core.partition.impl.btree.BTreeSearchResultEnumeration;
import org.apache.directory.server.core.partition.impl.btree.DefaultOptimizer;
import org.apache.directory.server.core.partition.impl.btree.DefaultSearchEngine;
import org.apache.directory.server.core.partition.impl.btree.ExpressionEnumerator;
import org.apache.directory.server.core.partition.impl.btree.ExpressionEvaluator;
import org.apache.directory.server.core.partition.impl.btree.Index;
import org.apache.directory.server.core.partition.impl.btree.IndexConfiguration;
import org.apache.directory.server.core.partition.impl.btree.IndexNotFoundException;
import org.apache.directory.server.core.partition.impl.btree.NoOpOptimizer;
import org.apache.directory.server.core.partition.impl.btree.Optimizer;
import org.apache.directory.server.core.partition.impl.btree.SearchEngine;
import org.apache.directory.server.core.partition.impl.btree.gui.PartitionViewer;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.exception.LdapContextNotEmptyException;
import org.apache.directory.shared.ldap.exception.LdapNameNotFoundException;
import org.apache.directory.shared.ldap.message.AttributesImpl;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BTreePartition
implements Partition {
    private static final Logger log = LoggerFactory.getLogger(BTreePartition.class);
    private SearchEngine searchEngine = null;
    private Optimizer optimizer;
    private BTreePartitionConfiguration cfg;
    protected AttributeTypeRegistry attributeTypeRegistry = null;
    protected OidRegistry oidRegistry = null;
    private static final String[] ENTRY_DELETED_ATTRS = new String[]{"entrydeleted"};

    protected BTreePartition() {
    }

    @Override
    public BTreePartitionConfiguration getConfiguration() {
        return this.cfg;
    }

    @Override
    public String getId() {
        return this.cfg.getId();
    }

    public void initRegistries(Registries registries) {
        this.initRegistries1(registries);
    }

    protected void initRegistries1(Registries registries) {
        this.attributeTypeRegistry = registries.getAttributeTypeRegistry();
        this.oidRegistry = registries.getOidRegistry();
        ExpressionEvaluator evaluator = new ExpressionEvaluator(this, this.oidRegistry, this.attributeTypeRegistry);
        ExpressionEnumerator enumerator = new ExpressionEnumerator(this, this.attributeTypeRegistry, evaluator);
        this.searchEngine = new DefaultSearchEngine(this, evaluator, enumerator, this.optimizer);
    }

    protected void initIndices2(Set indices) throws NamingException {
        HashSet<String> sysOidSet = new HashSet<String>();
        sysOidSet.add("1.3.6.1.4.1.18060.0.4.1.2.3");
        sysOidSet.add("1.3.6.1.4.1.18060.0.4.1.2.4");
        sysOidSet.add("1.3.6.1.4.1.18060.0.4.1.2.2");
        sysOidSet.add("1.3.6.1.4.1.18060.0.4.1.2.1");
        sysOidSet.add("1.3.6.1.4.1.18060.0.4.1.2.5");
        sysOidSet.add("1.3.6.1.4.1.18060.0.4.1.2.6");
        sysOidSet.add("1.3.6.1.4.1.18060.0.4.1.2.7");
        HashSet<String> customAddedSystemIndices = new HashSet<String>();
        for (Object nextObject : indices) {
            String name = null;
            int cacheSize = 100;
            int numDupLimit = 512;
            if (nextObject instanceof String) {
                name = (String)nextObject;
                log.warn("Using default cache size of {} for index on attribute {}", (Object)new Integer(cacheSize), (Object)name);
            } else if (nextObject instanceof IndexConfiguration) {
                IndexConfiguration indexConfiguration = (IndexConfiguration)nextObject;
                name = indexConfiguration.getAttributeId();
                cacheSize = indexConfiguration.getCacheSize();
                numDupLimit = indexConfiguration.getDuplicateLimit();
                if (cacheSize <= 0) {
                    log.warn("Cache size {} for index on attribute is null or negative. Using default value.", (Object)new Integer(cacheSize), (Object)name);
                    cacheSize = 100;
                } else {
                    log.info("Using cache size of {} for index on attribute {}", (Object)new Integer(cacheSize), (Object)name);
                }
                if (cacheSize <= 0) {
                    log.warn("Duplicate limit {} for index on attribute is null or negative. Using default value.", (Object)new Integer(numDupLimit), (Object)name);
                    cacheSize = 100;
                } else {
                    log.info("Using duplicate limit of {} for index on attribute {}", (Object)new Integer(numDupLimit), (Object)name);
                }
            }
            String oid = this.oidRegistry.getOid(name);
            AttributeType type = this.attributeTypeRegistry.lookup(oid);
            if (sysOidSet.contains(oid)) {
                if (oid.equals("1.3.6.1.4.1.18060.0.4.1.2.3")) {
                    this.setExistanceIndexOn(type, cacheSize, numDupLimit);
                    customAddedSystemIndices.add("1.3.6.1.4.1.18060.0.4.1.2.3");
                    continue;
                }
                if (oid.equals("1.3.6.1.4.1.18060.0.4.1.2.4")) {
                    this.setHierarchyIndexOn(type, cacheSize, numDupLimit);
                    customAddedSystemIndices.add("1.3.6.1.4.1.18060.0.4.1.2.4");
                    continue;
                }
                if (oid.equals("1.3.6.1.4.1.18060.0.4.1.2.2")) {
                    this.setUpdnIndexOn(type, cacheSize, numDupLimit);
                    customAddedSystemIndices.add("1.3.6.1.4.1.18060.0.4.1.2.2");
                    continue;
                }
                if (oid.equals("1.3.6.1.4.1.18060.0.4.1.2.1")) {
                    this.setNdnIndexOn(type, cacheSize, numDupLimit);
                    customAddedSystemIndices.add("1.3.6.1.4.1.18060.0.4.1.2.1");
                    continue;
                }
                if (oid.equals("1.3.6.1.4.1.18060.0.4.1.2.5")) {
                    this.setOneAliasIndexOn(type, cacheSize, numDupLimit);
                    customAddedSystemIndices.add("1.3.6.1.4.1.18060.0.4.1.2.5");
                    continue;
                }
                if (oid.equals("1.3.6.1.4.1.18060.0.4.1.2.6")) {
                    this.setSubAliasIndexOn(type, cacheSize, numDupLimit);
                    customAddedSystemIndices.add("1.3.6.1.4.1.18060.0.4.1.2.6");
                    continue;
                }
                if (oid.equals("1.3.6.1.4.1.18060.0.4.1.2.7")) {
                    this.setAliasIndexOn(type, cacheSize, numDupLimit);
                    customAddedSystemIndices.add("1.3.6.1.4.1.18060.0.4.1.2.7");
                    continue;
                }
                throw new NamingException("Unidentified system index " + oid);
            }
            this.addIndexOn(type, cacheSize, numDupLimit);
        }
        for (String systemIndexName : sysOidSet) {
            if (customAddedSystemIndices.contains(systemIndexName)) continue;
            AttributeType type = this.attributeTypeRegistry.lookup(systemIndexName);
            log.warn("Using default cache size of {} for index on attribute {}", (Object)new Integer(100), (Object)systemIndexName);
            if (systemIndexName.equals("1.3.6.1.4.1.18060.0.4.1.2.3")) {
                this.setExistanceIndexOn(type, 100, 512);
                continue;
            }
            if (systemIndexName.equals("1.3.6.1.4.1.18060.0.4.1.2.4")) {
                this.setHierarchyIndexOn(type, 100, 512);
                continue;
            }
            if (systemIndexName.equals("1.3.6.1.4.1.18060.0.4.1.2.2")) {
                this.setUpdnIndexOn(type, 100, 512);
                continue;
            }
            if (systemIndexName.equals("1.3.6.1.4.1.18060.0.4.1.2.1")) {
                this.setNdnIndexOn(type, 100, 512);
                continue;
            }
            if (systemIndexName.equals("1.3.6.1.4.1.18060.0.4.1.2.5")) {
                this.setOneAliasIndexOn(type, 100, 512);
                continue;
            }
            if (systemIndexName.equals("1.3.6.1.4.1.18060.0.4.1.2.6")) {
                this.setSubAliasIndexOn(type, 100, 512);
                continue;
            }
            if (systemIndexName.equals("1.3.6.1.4.1.18060.0.4.1.2.7")) {
                this.setAliasIndexOn(type, 100, 512);
                continue;
            }
            throw new NamingException("Unidentified system index " + systemIndexName);
        }
    }

    protected void initSuffixEntry3(String suffix, Attributes entry) throws NamingException {
        Attributes suffixOnDisk = this.getSuffixEntry();
        if (suffixOnDisk == null) {
            LdapDN dn = new LdapDN(suffix);
            LdapDN normalizedSuffix = LdapDN.normalize((LdapDN)dn, (Map)this.attributeTypeRegistry.getNormalizerMapping());
            this.add(new AddOperationContext(normalizedSuffix, entry));
        }
    }

    protected void initOptimizerAndConfiguration0(PartitionConfiguration cfg) throws NamingException {
        if (cfg instanceof BTreePartitionConfiguration) {
            this.cfg = (BTreePartitionConfiguration)cfg;
            this.optimizer = !this.cfg.isOptimizerEnabled() ? new NoOpOptimizer() : new DefaultOptimizer(this);
        } else {
            this.cfg = BTreePartitionConfiguration.convert(cfg);
            this.optimizer = new DefaultOptimizer(this);
        }
    }

    @Override
    public void init(DirectoryServiceConfiguration factoryCfg, PartitionConfiguration cfg) throws NamingException {
        this.initOptimizerAndConfiguration0(cfg);
        this.initRegistries1(factoryCfg.getRegistries());
        this.initIndices2(cfg.getIndexedAttributes());
        this.initSuffixEntry3(cfg.getSuffix(), cfg.getContextEntry());
    }

    public SearchEngine getSearchEngine() {
        return this.searchEngine;
    }

    @Override
    public void delete(DeleteOperationContext opContext) throws NamingException {
        LdapDN dn = opContext.getDn();
        Long id = this.getEntryId(dn.getNormName());
        if (id == null) {
            throw new LdapNameNotFoundException("Could not find entry at '" + dn + "' to delete it!");
        }
        if (this.getChildCount(id) > 0) {
            LdapContextNotEmptyException cnee = new LdapContextNotEmptyException("[66] Cannot delete entry " + dn + " it has children!");
            cnee.setRemainingName((Name)dn);
            throw cnee;
        }
        this.delete(id);
    }

    @Override
    public abstract void add(AddOperationContext var1) throws NamingException;

    @Override
    public abstract void modify(ModifyOperationContext var1) throws NamingException;

    public NamingEnumeration list(ListOperationContext opContext) throws NamingException {
        BTreeSearchResultEnumeration list = new BTreeSearchResultEnumeration(ENTRY_DELETED_ATTRS, this.list(this.getEntryId(opContext.getDn().getNormName())), this, this.attributeTypeRegistry);
        return list;
    }

    @Override
    public NamingEnumeration<SearchResult> search(SearchOperationContext opContext) throws NamingException {
        SearchControls searchCtls = opContext.getSearchControls();
        String[] attrIds = searchCtls.getReturningAttributes();
        NamingEnumeration underlying = null;
        underlying = this.searchEngine.search((Name)opContext.getDn(), opContext.getEnv(), opContext.getFilter(), searchCtls);
        return new BTreeSearchResultEnumeration(attrIds, underlying, this, this.attributeTypeRegistry);
    }

    @Override
    public Attributes lookup(LookupOperationContext opContext) throws NamingException {
        Attributes entry = this.lookup(this.getEntryId(opContext.getDn().getNormName()));
        if (opContext.getAttrsId() == null || opContext.getAttrsId().size() == 0) {
            return entry;
        }
        AttributesImpl retval = new AttributesImpl();
        for (String attrId : opContext.getAttrsId()) {
            Attribute attr = entry.get(attrId);
            if (attr == null) continue;
            retval.put(attr);
        }
        return retval;
    }

    @Override
    public boolean hasEntry(EntryOperationContext opContext) throws NamingException {
        return null != this.getEntryId(opContext.getDn().getNormName());
    }

    @Override
    public abstract void rename(RenameOperationContext var1) throws NamingException;

    @Override
    public abstract void move(MoveOperationContext var1) throws NamingException;

    @Override
    public abstract void moveAndRename(MoveAndRenameOperationContext var1) throws NamingException;

    @Override
    public abstract void sync() throws NamingException;

    @Override
    public abstract void destroy();

    @Override
    public abstract boolean isInitialized();

    public void inspect() throws Exception {
        PartitionViewer viewer = new PartitionViewer(this, this.searchEngine);
        viewer.execute();
    }

    public abstract void addIndexOn(AttributeType var1, int var2, int var3) throws NamingException;

    public abstract boolean hasUserIndexOn(String var1) throws NamingException;

    public abstract boolean hasSystemIndexOn(String var1) throws NamingException;

    public abstract Index getExistanceIndex();

    public abstract Index getHierarchyIndex();

    public abstract Index getUpdnIndex();

    public abstract Index getNdnIndex();

    public abstract Index getOneAliasIndex();

    public abstract Index getSubAliasIndex();

    public abstract Index getAliasIndex();

    public abstract void setAliasIndexOn(AttributeType var1, int var2, int var3) throws NamingException;

    public abstract void setExistanceIndexOn(AttributeType var1, int var2, int var3) throws NamingException;

    public abstract void setHierarchyIndexOn(AttributeType var1, int var2, int var3) throws NamingException;

    public abstract void setUpdnIndexOn(AttributeType var1, int var2, int var3) throws NamingException;

    public abstract void setNdnIndexOn(AttributeType var1, int var2, int var3) throws NamingException;

    public abstract void setOneAliasIndexOn(AttributeType var1, int var2, int var3) throws NamingException;

    public abstract void setSubAliasIndexOn(AttributeType var1, int var2, int var3) throws NamingException;

    public abstract Index getUserIndex(String var1) throws IndexNotFoundException;

    public abstract Index getSystemIndex(String var1) throws IndexNotFoundException;

    public abstract Long getEntryId(String var1) throws NamingException;

    public abstract String getEntryDn(Long var1) throws NamingException;

    public abstract Long getParentId(String var1) throws NamingException;

    public abstract Long getParentId(Long var1) throws NamingException;

    public abstract String getEntryUpdn(Long var1) throws NamingException;

    public abstract String getEntryUpdn(String var1) throws NamingException;

    public abstract Attributes lookup(Long var1) throws NamingException;

    public abstract void delete(Long var1) throws NamingException;

    public abstract NamingEnumeration list(Long var1) throws NamingException;

    public abstract int getChildCount(Long var1) throws NamingException;

    public abstract Attributes getSuffixEntry() throws NamingException;

    public abstract void setProperty(String var1, String var2) throws NamingException;

    public abstract String getProperty(String var1) throws NamingException;

    public abstract Iterator getUserIndices();

    public abstract Iterator getSystemIndices();

    public abstract Attributes getIndices(Long var1) throws NamingException;

    public abstract int count() throws NamingException;
}

