/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.referral;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.directory.server.core.DirectoryServiceConfiguration;
import org.apache.directory.server.core.configuration.InterceptorConfiguration;
import org.apache.directory.server.core.enumeration.ReferralHandlingEnumeration;
import org.apache.directory.server.core.enumeration.SearchResultFilter;
import org.apache.directory.server.core.enumeration.SearchResultFilteringEnumeration;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddContextPartitionOperationContext;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.RemoveContextPartitionOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.invocation.Invocation;
import org.apache.directory.server.core.invocation.InvocationStack;
import org.apache.directory.server.core.jndi.ServerLdapContext;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.core.partition.PartitionNexusProxy;
import org.apache.directory.server.core.referral.ReferralLut;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.shared.ldap.NotImplementedException;
import org.apache.directory.shared.ldap.codec.util.LdapURL;
import org.apache.directory.shared.ldap.codec.util.LdapURLEncodingException;
import org.apache.directory.shared.ldap.exception.LdapNamingException;
import org.apache.directory.shared.ldap.exception.LdapReferralException;
import org.apache.directory.shared.ldap.filter.AssertionEnum;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.SimpleNode;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferralService
extends BaseInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ReferralService.class);
    private static final String IGNORE = "ignore";
    private static final String THROW_FINDING_BASE = "throw-finding-base";
    private static final String THROW = "throw";
    private static final String FOLLOW = "follow";
    private static final Collection<String> SEARCH_BYPASS;
    private ReferralLut lut = new ReferralLut();
    private PartitionNexus nexus;
    private Hashtable env;
    private AttributeTypeRegistry attrRegistry;
    private OidRegistry oidRegistry;

    static boolean hasValue(Attribute attr, String value) throws NamingException {
        if (attr == null) {
            return false;
        }
        for (int ii = 0; ii < attr.size(); ++ii) {
            if (!(attr.get(ii) instanceof String) || !value.equalsIgnoreCase((String)attr.get(ii))) continue;
            return true;
        }
        return false;
    }

    static boolean isReferral(Attributes entry) throws NamingException {
        Attribute oc = entry.get("objectClass");
        if (oc == null) {
            log.warn("could not find objectClass attribute in entry: " + entry);
            return false;
        }
        for (int ii = 0; ii < oc.size(); ++ii) {
            if (!"referral".equalsIgnoreCase((String)oc.get(ii))) continue;
            Attribute ref = entry.get("ref");
            if (ref == null) {
                String message = "An entry with a 'referral' ObjectClass must contains a 'ref' Attribute";
                log.error(message);
                throw new NamingException(message);
            }
            NamingEnumeration<?> refs = ref.getAll();
            while (refs.hasMoreElements()) {
                Object refObj = refs.nextElement();
                if (refObj instanceof String) {
                    String refVal = (String)refObj;
                    try {
                        String message;
                        LdapURL ldapUrl = new LdapURL(refVal);
                        if (ldapUrl.getScope() != 0) {
                            message = "An LDAPURL should not contains a scope";
                            log.error(message);
                            throw new NamingException(message);
                        }
                        if (!StringTools.isEmpty((String)ldapUrl.getFilter())) {
                            message = "An LDAPURL should not contains filters";
                            log.error(message);
                            throw new NamingException(message);
                        }
                        if (ldapUrl.getAttributes() != null && ldapUrl.getAttributes().size() != 0) {
                            message = "An LDAPURL should not contains any description attribute list";
                            log.error(message);
                            throw new NamingException(message);
                        }
                        if (ldapUrl.getExtensions() != null && ldapUrl.getExtensions().size() != 0) {
                            message = "An LDAPURL should not contains any extension";
                            log.error(message);
                            throw new NamingException(message);
                        }
                        if (ldapUrl.getCriticalExtensions() != null && ldapUrl.getCriticalExtensions().size() != 0) {
                            message = "An LDAPURL should not contains any critical extension";
                            log.error(message);
                            throw new NamingException(message);
                        }
                        LdapDN dn = ldapUrl.getDn();
                        if (dn != null && !dn.isEmpty()) continue;
                        String message2 = "An LDAPURL should contains a non-empty DN";
                        log.error(message2);
                        throw new NamingException(message2);
                    }
                    catch (LdapURLEncodingException luee) {
                        continue;
                    }
                }
                String message = "Invalid referral value, it should be a String";
                log.error(message);
                throw new NamingException(message);
            }
            return true;
        }
        return false;
    }

    @Override
    public void init(DirectoryServiceConfiguration dsConfig, InterceptorConfiguration cfg) throws NamingException {
        this.nexus = dsConfig.getPartitionNexus();
        this.attrRegistry = dsConfig.getRegistries().getAttributeTypeRegistry();
        this.oidRegistry = dsConfig.getRegistries().getOidRegistry();
        this.env = dsConfig.getEnvironment();
        Iterator<String> suffixes = this.nexus.listSuffixes(null);
        while (suffixes.hasNext()) {
            LdapDN suffix = new LdapDN(suffixes.next());
            this.addReferrals(this.nexus.search(new SearchOperationContext(suffix, this.env, ReferralService.getReferralFilter(), ReferralService.getControls())), suffix);
        }
    }

    public void doReferralException(LdapDN farthest, LdapDN targetUpdn, Attribute refs) throws NamingException {
        ArrayList<String> list = new ArrayList<String>(refs.size());
        for (int ii = 0; ii < refs.size(); ++ii) {
            String val = (String)refs.get(ii);
            if (!val.startsWith("ldap")) {
                list.add(val);
                continue;
            }
            LdapURL ldapUrl = new LdapURL();
            try {
                ldapUrl.parse(val.toCharArray());
            }
            catch (LdapURLEncodingException e) {
                log.error("Bad URL (" + val + ") for ref in " + farthest + ".  Reference will be ignored.");
            }
            LdapDN urlDn = new LdapDN(ldapUrl.getDn().toNormName());
            urlDn.normalize(this.attrRegistry.getNormalizerMapping());
            if (urlDn.equals((Object)farthest)) {
                StringBuilder buf = new StringBuilder();
                buf.append(ldapUrl.getScheme());
                buf.append(ldapUrl.getHost());
                if (ldapUrl.getPort() > 0) {
                    buf.append(":");
                    buf.append(ldapUrl.getPort());
                }
                list.add(buf.toString());
                continue;
            }
            int diff = targetUpdn.size() - farthest.size();
            LdapDN extra = new LdapDN();
            for (int jj = 0; jj < diff; ++jj) {
                extra.add(targetUpdn.get(farthest.size() + jj));
            }
            urlDn.addAll((Name)extra);
            StringBuilder buf = new StringBuilder();
            buf.append(ldapUrl.getScheme());
            buf.append(ldapUrl.getHost());
            if (ldapUrl.getPort() > 0) {
                buf.append(":");
                buf.append(ldapUrl.getPort());
            }
            buf.append("/");
            buf.append(LdapURL.urlEncode((String)urlDn.getUpName(), (boolean)false));
            list.add(buf.toString());
        }
        LdapReferralException lre = new LdapReferralException(list);
        throw lre;
    }

    @Override
    public void add(NextInterceptor next, AddOperationContext opContext) throws NamingException {
        LdapDN farthest;
        Invocation invocation = InvocationStack.getInstance().peek();
        ServerLdapContext caller = (ServerLdapContext)invocation.getCaller();
        String refval = (String)caller.getEnvironment().get("java.naming.referral");
        LdapDN name = opContext.getDn();
        Attributes entry = opContext.getEntry();
        if (refval == null || refval.equals(IGNORE)) {
            next.add(opContext);
            if (ReferralService.isReferral(entry)) {
                this.lut.referralAdded(name);
            }
            return;
        }
        if (refval.equals(THROW)) {
            farthest = this.lut.getFarthestReferralAncestor(name);
            if (farthest == null) {
                next.add(opContext);
                if (ReferralService.isReferral(entry)) {
                    this.lut.referralAdded(name);
                }
                return;
            }
        } else {
            if (refval.equals(FOLLOW)) {
                throw new NotImplementedException("follow referral handling mode not implemented");
            }
            throw new LdapNamingException("Undefined value for java.naming.referral key: " + refval, ResultCodeEnum.OTHER);
        }
        Attributes referral = invocation.getProxy().lookup(new LookupOperationContext(farthest), PartitionNexusProxy.LOOKUP_BYPASS);
        AttributeType refsType = this.attrRegistry.lookup(this.oidRegistry.getOid("ref"));
        Attribute refs = AttributeUtils.getAttribute((Attributes)referral, (AttributeType)refsType);
        this.doReferralException(farthest, new LdapDN(name.getUpName()), refs);
    }

    @Override
    public boolean compare(NextInterceptor next, CompareOperationContext opContext) throws NamingException {
        LdapDN name = opContext.getDn();
        Invocation invocation = InvocationStack.getInstance().peek();
        ServerLdapContext caller = (ServerLdapContext)invocation.getCaller();
        String refval = (String)caller.getEnvironment().get("java.naming.referral");
        if (refval == null || refval.equals(IGNORE)) {
            return next.compare(opContext);
        }
        if (refval.equals(THROW)) {
            LdapDN farthest = this.lut.getFarthestReferralAncestor(name);
            if (farthest == null) {
                return next.compare(opContext);
            }
            Attributes referral = invocation.getProxy().lookup(new LookupOperationContext(farthest), PartitionNexusProxy.LOOKUP_BYPASS);
            Attribute refs = referral.get("ref");
            this.doReferralException(farthest, new LdapDN(name.getUpName()), refs);
            return false;
        }
        if (refval.equals(FOLLOW)) {
            throw new NotImplementedException("follow referral handling mode not implemented");
        }
        throw new LdapNamingException("Undefined value for java.naming.referral key: " + refval, ResultCodeEnum.OTHER);
    }

    @Override
    public void delete(NextInterceptor next, DeleteOperationContext opContext) throws NamingException {
        LdapDN farthest;
        LdapDN name = opContext.getDn();
        Invocation invocation = InvocationStack.getInstance().peek();
        ServerLdapContext caller = (ServerLdapContext)invocation.getCaller();
        String refval = (String)caller.getEnvironment().get("java.naming.referral");
        if (refval == null || refval.equals(IGNORE)) {
            next.delete(opContext);
            if (this.lut.isReferral(name)) {
                this.lut.referralDeleted(name);
            }
            return;
        }
        if (refval.equals(THROW)) {
            farthest = this.lut.getFarthestReferralAncestor(name);
            if (farthest == null) {
                next.delete(opContext);
                if (this.lut.isReferral(name)) {
                    this.lut.referralDeleted(name);
                }
                return;
            }
        } else {
            if (refval.equals(FOLLOW)) {
                throw new NotImplementedException("follow referral handling mode not implemented");
            }
            throw new LdapNamingException("Undefined value for java.naming.referral key: " + refval, ResultCodeEnum.OTHER);
        }
        Attributes referral = invocation.getProxy().lookup(new LookupOperationContext(farthest), PartitionNexusProxy.LOOKUP_BYPASS);
        Attribute refs = referral.get("ref");
        this.doReferralException(farthest, new LdapDN(name.getUpName()), refs);
    }

    @Override
    public void move(NextInterceptor next, MoveOperationContext opContext) throws NamingException {
        LdapDN oldName = opContext.getDn();
        Invocation invocation = InvocationStack.getInstance().peek();
        ServerLdapContext caller = (ServerLdapContext)invocation.getCaller();
        String refval = (String)caller.getEnvironment().get("java.naming.referral");
        LdapDN newName = (LdapDN)opContext.getParent().clone();
        newName.add(oldName.get(oldName.size() - 1));
        if (refval == null || refval.equals(IGNORE)) {
            next.move(opContext);
            if (this.lut.isReferral(oldName)) {
                this.lut.referralChanged(oldName, newName);
            }
            return;
        }
        if (refval.equals(THROW)) {
            LdapDN farthestSrc = this.lut.getFarthestReferralAncestor(oldName);
            LdapDN farthestDst = this.lut.getFarthestReferralAncestor(newName);
            if (farthestSrc == null && farthestDst == null && !this.lut.isReferral(newName)) {
                next.move(opContext);
                if (this.lut.isReferral(oldName)) {
                    this.lut.referralChanged(oldName, newName);
                }
                return;
            }
            if (farthestSrc != null) {
                Attributes referral = invocation.getProxy().lookup(new LookupOperationContext(farthestSrc), PartitionNexusProxy.LOOKUP_BYPASS);
                Attribute refs = referral.get("ref");
                this.doReferralException(farthestSrc, new LdapDN(oldName.getUpName()), refs);
            } else {
                if (farthestDst != null) {
                    throw new LdapNamingException(farthestDst + " ancestor is a referral for modifyDn on " + newName + " so it affects multiple DSAs", ResultCodeEnum.AFFECTS_MULTIPLE_DSAS);
                }
                if (this.lut.isReferral(newName)) {
                    throw new LdapNamingException(newName + " exists and is a referral for modifyDn destination so it affects multiple DSAs", ResultCodeEnum.AFFECTS_MULTIPLE_DSAS);
                }
            }
            throw new IllegalStateException("If you get this exception the server's logic was flawed in handling a modifyDn operation while processing referrals.  Report this as a bug!");
        }
        if (refval.equals(FOLLOW)) {
            throw new NotImplementedException("follow referral handling mode not implemented");
        }
        throw new LdapNamingException("Undefined value for java.naming.referral key: " + refval, ResultCodeEnum.OTHER);
    }

    @Override
    public void moveAndRename(NextInterceptor next, MoveAndRenameOperationContext opContext) throws NamingException {
        LdapDN oldName = opContext.getDn();
        Invocation invocation = InvocationStack.getInstance().peek();
        ServerLdapContext caller = (ServerLdapContext)invocation.getCaller();
        String refval = (String)caller.getEnvironment().get("java.naming.referral");
        LdapDN newName = (LdapDN)opContext.getParent().clone();
        newName.add(opContext.getNewRdn());
        if (refval == null || refval.equals(IGNORE)) {
            next.moveAndRename(opContext);
            if (this.lut.isReferral(oldName)) {
                this.lut.referralChanged(oldName, newName);
            }
            return;
        }
        if (refval.equals(THROW)) {
            LdapDN farthestSrc = this.lut.getFarthestReferralAncestor(oldName);
            LdapDN farthestDst = this.lut.getFarthestReferralAncestor(newName);
            if (farthestSrc == null && farthestDst == null && !this.lut.isReferral(newName)) {
                next.moveAndRename(opContext);
                if (this.lut.isReferral(oldName)) {
                    this.lut.referralChanged(oldName, newName);
                }
                return;
            }
            if (farthestSrc != null) {
                Attributes referral = invocation.getProxy().lookup(new LookupOperationContext(farthestSrc), PartitionNexusProxy.LOOKUP_BYPASS);
                Attribute refs = referral.get("ref");
                this.doReferralException(farthestSrc, new LdapDN(oldName.getUpName()), refs);
            } else {
                if (farthestDst != null) {
                    throw new LdapNamingException(farthestDst + " ancestor is a referral for modifyDn on " + newName + " so it affects multiple DSAs", ResultCodeEnum.AFFECTS_MULTIPLE_DSAS);
                }
                if (this.lut.isReferral(newName)) {
                    throw new LdapNamingException(newName + " exists and is a referral for modifyDn destination so it affects multiple DSAs", ResultCodeEnum.AFFECTS_MULTIPLE_DSAS);
                }
            }
            throw new IllegalStateException("If you get this exception the server's logic was flawed in handling a modifyDn operation while processing referrals.  Report this as a bug!");
        }
        if (refval.equals(FOLLOW)) {
            throw new NotImplementedException("follow referral handling mode not implemented");
        }
        throw new LdapNamingException("Undefined value for java.naming.referral key: " + refval, ResultCodeEnum.OTHER);
    }

    @Override
    public void rename(NextInterceptor next, RenameOperationContext opContext) throws NamingException {
        LdapDN oldName = opContext.getDn();
        Invocation invocation = InvocationStack.getInstance().peek();
        ServerLdapContext caller = (ServerLdapContext)invocation.getCaller();
        String refval = (String)caller.getEnvironment().get("java.naming.referral");
        LdapDN newName = (LdapDN)oldName.clone();
        newName.remove(oldName.size() - 1);
        LdapDN newRdnName = new LdapDN(opContext.getNewRdn());
        newRdnName.normalize(this.attrRegistry.getNormalizerMapping());
        newName.add(newRdnName.toNormName());
        if (refval == null || refval.equals(IGNORE)) {
            next.rename(opContext);
            if (this.lut.isReferral(oldName)) {
                this.lut.referralChanged(oldName, newName);
            }
            return;
        }
        if (refval.equals(THROW)) {
            LdapDN farthestSrc = this.lut.getFarthestReferralAncestor(oldName);
            LdapDN farthestDst = this.lut.getFarthestReferralAncestor(newName);
            if (farthestSrc == null && farthestDst == null && !this.lut.isReferral(newName)) {
                next.rename(opContext);
                if (this.lut.isReferral(oldName)) {
                    this.lut.referralChanged(oldName, newName);
                }
                return;
            }
            if (farthestSrc != null) {
                Attributes referral = invocation.getProxy().lookup(new LookupOperationContext(farthestSrc), PartitionNexusProxy.LOOKUP_BYPASS);
                Attribute refs = referral.get("ref");
                this.doReferralException(farthestSrc, new LdapDN(oldName.getUpName()), refs);
            } else {
                if (farthestDst != null) {
                    throw new LdapNamingException(farthestDst + " ancestor is a referral for modifyDn on " + newName + " so it affects multiple DSAs", ResultCodeEnum.AFFECTS_MULTIPLE_DSAS);
                }
                if (this.lut.isReferral(newName)) {
                    throw new LdapNamingException(newName + " exists and is a referral for modifyDn destination so it affects multiple DSAs", ResultCodeEnum.AFFECTS_MULTIPLE_DSAS);
                }
            }
            throw new IllegalStateException("If you get this exception the server's logic was flawed in handling a modifyDn operation while processing referrals.  Report this as a bug!");
        }
        if (refval.equals(FOLLOW)) {
            throw new NotImplementedException("follow referral handling mode not implemented");
        }
        throw new LdapNamingException("Undefined value for java.naming.referral key: " + refval, ResultCodeEnum.OTHER);
    }

    private void checkModify(LdapDN name, ModificationItemImpl[] mods) throws NamingException {
        boolean isTargetReferral = this.lut.isReferral(name);
        block5: for (int ii = 0; ii < mods.length; ++ii) {
            if (!mods[ii].getAttribute().getID().equalsIgnoreCase("objectClass")) continue;
            boolean modsOcHasReferral = ReferralService.hasValue(mods[ii].getAttribute(), "referral");
            switch (mods[ii].getModificationOp()) {
                case 1: {
                    if (!modsOcHasReferral || isTargetReferral) break block5;
                    this.lut.referralAdded(name);
                    break block5;
                }
                case 3: {
                    if (!modsOcHasReferral || !isTargetReferral) break block5;
                    this.lut.referralDeleted(name);
                    break block5;
                }
                case 2: {
                    if (isTargetReferral && !modsOcHasReferral) {
                        this.lut.referralDeleted(name);
                        break block5;
                    }
                    if (isTargetReferral || !modsOcHasReferral) break block5;
                    this.lut.referralAdded(name);
                    break block5;
                }
                default: {
                    throw new IllegalStateException("undefined modification operation");
                }
            }
        }
    }

    @Override
    public void modify(NextInterceptor next, ModifyOperationContext opContext) throws NamingException {
        LdapDN farthest;
        Invocation invocation = InvocationStack.getInstance().peek();
        ServerLdapContext caller = (ServerLdapContext)invocation.getCaller();
        String refval = (String)caller.getEnvironment().get("java.naming.referral");
        LdapDN name = opContext.getDn();
        ModificationItemImpl[] mods = opContext.getModItems();
        if (refval == null || refval.equals(IGNORE)) {
            next.modify(opContext);
            this.checkModify(name, mods);
            return;
        }
        if (refval.equals(THROW)) {
            farthest = this.lut.getFarthestReferralAncestor(name);
            if (farthest == null) {
                next.modify(opContext);
                this.checkModify(name, mods);
                return;
            }
        } else {
            if (refval.equals(FOLLOW)) {
                throw new NotImplementedException("follow referral handling mode not implemented");
            }
            throw new LdapNamingException("Undefined value for java.naming.referral key: " + refval, ResultCodeEnum.OTHER);
        }
        Attributes referral = invocation.getProxy().lookup(new LookupOperationContext(farthest), PartitionNexusProxy.LOOKUP_BYPASS);
        Attribute refs = referral.get("ref");
        this.doReferralException(farthest, new LdapDN(name.getUpName()), refs);
    }

    static ExprNode getReferralFilter() {
        return new SimpleNode("objectClass", "referral", AssertionEnum.EQUALITY);
    }

    static SearchControls getControls() {
        SearchControls controls = new SearchControls();
        controls.setReturningObjFlag(false);
        controls.setSearchScope(2);
        return controls;
    }

    @Override
    public void addContextPartition(NextInterceptor next, AddContextPartitionOperationContext opContext) throws NamingException {
        next.addContextPartition(opContext);
        Partition partition = opContext.getPartition();
        LdapDN suffix = partition.getSuffix();
        Invocation invocation = InvocationStack.getInstance().peek();
        NamingEnumeration<SearchResult> list = invocation.getProxy().search(new SearchOperationContext(suffix, this.env, ReferralService.getReferralFilter(), ReferralService.getControls()), SEARCH_BYPASS);
        this.addReferrals(list, suffix);
    }

    @Override
    public void removeContextPartition(NextInterceptor next, RemoveContextPartitionOperationContext opContext) throws NamingException {
        Invocation invocation = InvocationStack.getInstance().peek();
        NamingEnumeration<SearchResult> list = invocation.getProxy().search(new SearchOperationContext(opContext.getDn(), this.env, ReferralService.getReferralFilter(), ReferralService.getControls()), SEARCH_BYPASS);
        this.deleteReferrals(list, opContext.getDn());
        next.removeContextPartition(opContext);
    }

    private void addReferrals(NamingEnumeration referrals, LdapDN base) throws NamingException {
        while (referrals.hasMore()) {
            SearchResult r = (SearchResult)referrals.next();
            LdapDN referral = null;
            LdapDN result = new LdapDN(r.getName());
            result.normalize(this.attrRegistry.getNormalizerMapping());
            if (r.isRelative()) {
                referral = (LdapDN)base.clone();
                referral.addAll((Name)result);
            } else {
                referral = result;
            }
            this.lut.referralAdded(result);
        }
    }

    private void deleteReferrals(NamingEnumeration referrals, LdapDN base) throws NamingException {
        while (referrals.hasMore()) {
            SearchResult r = (SearchResult)referrals.next();
            LdapDN referral = null;
            LdapDN result = new LdapDN(r.getName());
            result.normalize(this.attrRegistry.getNormalizerMapping());
            if (r.isRelative()) {
                referral = (LdapDN)base.clone();
                referral.addAll((Name)result);
            } else {
                referral = result;
            }
            this.lut.referralDeleted(result);
        }
    }

    @Override
    public NamingEnumeration<SearchResult> search(NextInterceptor next, SearchOperationContext opContext) throws NamingException {
        Invocation invocation = InvocationStack.getInstance().peek();
        ServerLdapContext caller = (ServerLdapContext)invocation.getCaller();
        String refval = (String)caller.getEnvironment().get("java.naming.referral");
        if (refval == null || refval.equals(IGNORE)) {
            return next.search(opContext);
        }
        LdapDN base = opContext.getDn();
        SearchControls controls = opContext.getSearchControls();
        if (refval.equals(THROW_FINDING_BASE)) {
            LdapDN farthest;
            if (this.lut.isReferral(base)) {
                Attributes referral = invocation.getProxy().lookup(new LookupOperationContext(base), PartitionNexusProxy.LOOKUP_BYPASS);
                Attribute refs = referral.get("ref");
                this.doReferralExceptionOnSearchBase(base, refs, controls.getSearchScope());
            }
            if ((farthest = this.lut.getFarthestReferralAncestor(base)) == null) {
                return next.search(opContext);
            }
            Attributes referral = invocation.getProxy().lookup(new LookupOperationContext(farthest), PartitionNexusProxy.LOOKUP_BYPASS);
            Attribute refs = referral.get("ref");
            this.doReferralExceptionOnSearchBase(farthest, new LdapDN(base.getUpName()), refs, controls.getSearchScope());
            throw new IllegalStateException("Should never get here: shutting up compiler");
        }
        if (refval.equals(THROW)) {
            LdapDN farthest;
            if (this.lut.isReferral(base)) {
                Attributes referral = invocation.getProxy().lookup(new LookupOperationContext(base), PartitionNexusProxy.LOOKUP_BYPASS);
                Attribute refs = referral.get("ref");
                this.doReferralExceptionOnSearchBase(base, refs, controls.getSearchScope());
            }
            if ((farthest = this.lut.getFarthestReferralAncestor(base)) == null) {
                SearchResultFilteringEnumeration srfe = (SearchResultFilteringEnumeration)next.search(opContext);
                return new ReferralHandlingEnumeration(srfe, this.lut, this.attrRegistry, this.nexus, controls.getSearchScope(), true);
            }
            Attributes referral = invocation.getProxy().lookup(new LookupOperationContext(farthest), PartitionNexusProxy.LOOKUP_BYPASS);
            Attribute refs = referral.get("ref");
            this.doReferralExceptionOnSearchBase(farthest, new LdapDN(base.getUpName()), refs, controls.getSearchScope());
            throw new IllegalStateException("Should never get here: shutting up compiler");
        }
        if (refval.equals(FOLLOW)) {
            throw new NotImplementedException("follow referral handling mode not implemented");
        }
        throw new LdapNamingException("Undefined value for java.naming.referral key: " + refval, ResultCodeEnum.OTHER);
    }

    public void doReferralExceptionOnSearchBase(LdapDN base, Attribute refs, int scope) throws NamingException {
        ArrayList<String> list = new ArrayList<String>(refs.size());
        for (int ii = 0; ii < refs.size(); ++ii) {
            String val = (String)refs.get(ii);
            if (!val.startsWith("ldap")) {
                list.add(val);
                continue;
            }
            LdapURL ldapUrl = new LdapURL();
            try {
                ldapUrl.parse(val.toCharArray());
            }
            catch (LdapURLEncodingException e) {
                log.error("Bad URL (" + val + ") for ref in " + base + ".  Reference will be ignored.");
            }
            StringBuilder buf = new StringBuilder();
            buf.append(ldapUrl.getScheme());
            buf.append(ldapUrl.getHost());
            if (ldapUrl.getPort() > 0) {
                buf.append(":");
                buf.append(ldapUrl.getPort());
            }
            buf.append("/");
            buf.append(LdapURL.urlEncode((String)ldapUrl.getDn().getUpName(), (boolean)false));
            buf.append("??");
            switch (scope) {
                case 2: {
                    buf.append("sub");
                    break;
                }
                case 1: {
                    buf.append("one");
                    break;
                }
                case 0: {
                    buf.append("base");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown recognized search scope: " + scope);
                }
            }
            list.add(buf.toString());
        }
        LdapReferralException lre = new LdapReferralException(list);
        throw lre;
    }

    public void doReferralExceptionOnSearchBase(LdapDN farthest, LdapDN targetUpdn, Attribute refs, int scope) throws NamingException {
        ArrayList<String> list = new ArrayList<String>(refs.size());
        for (int ii = 0; ii < refs.size(); ++ii) {
            String val = (String)refs.get(ii);
            if (!val.startsWith("ldap")) {
                list.add(val);
                continue;
            }
            LdapURL ldapUrl = new LdapURL();
            try {
                ldapUrl.parse(val.toCharArray());
            }
            catch (LdapURLEncodingException e) {
                log.error("Bad URL (" + val + ") for ref in " + farthest + ".  Reference will be ignored.");
            }
            LdapDN urlDn = new LdapDN(ldapUrl.getDn().toNormName());
            urlDn.normalize(this.attrRegistry.getNormalizerMapping());
            int diff = targetUpdn.size() - farthest.size();
            LdapDN extra = new LdapDN();
            for (int jj = 0; jj < diff; ++jj) {
                extra.add(targetUpdn.get(farthest.size() + jj));
            }
            urlDn.addAll((Name)extra);
            StringBuilder buf = new StringBuilder();
            buf.append(ldapUrl.getScheme());
            buf.append(ldapUrl.getHost());
            if (ldapUrl.getPort() > 0) {
                buf.append(":");
                buf.append(ldapUrl.getPort());
            }
            buf.append("/");
            buf.append(LdapURL.urlEncode((String)urlDn.getUpName(), (boolean)false));
            buf.append("??");
            switch (scope) {
                case 2: {
                    buf.append("sub");
                    break;
                }
                case 1: {
                    buf.append("one");
                    break;
                }
                case 0: {
                    buf.append("base");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown recognized search scope: " + scope);
                }
            }
            list.add(buf.toString());
        }
        LdapReferralException lre = new LdapReferralException(list);
        throw lre;
    }

    public boolean isReferral(String name) throws NamingException {
        if (this.lut.isReferral(name)) {
            return true;
        }
        LdapDN dn = new LdapDN(name);
        dn.normalize(this.attrRegistry.getNormalizerMapping());
        return this.lut.isReferral(dn);
    }

    public boolean isReferral(LdapDN name) throws NamingException {
        return this.lut.isReferral(name.isNormalized() ? name : LdapDN.normalize((LdapDN)name, (Map)this.attrRegistry.getNormalizerMapping()));
    }

    static {
        HashSet<String> c = new HashSet<String>();
        c.add("normalizationService");
        c.add("authenticationService");
        c.add("authorizationService");
        c.add("defaultAuthorizationService");
        c.add("schemaService");
        c.add("subentryService");
        c.add("operationalAttributeService");
        c.add("referralService");
        c.add("eventService");
        c.add("triggerService");
        SEARCH_BYPASS = Collections.unmodifiableCollection(c);
    }

    class ReferralFilter
    implements SearchResultFilter {
        ReferralFilter() {
        }

        public boolean accept(Invocation invocation, SearchResult result, SearchControls controls) throws NamingException {
            return false;
        }
    }
}

