/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import javax.naming.NamingException;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.schema.AbstractSchemaObject;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.MutableSchemaObject;
import org.apache.directory.shared.ldap.schema.NameForm;
import org.apache.directory.shared.ldap.schema.ObjectClass;

public class NameFormImpl
extends AbstractSchemaObject
implements NameForm,
MutableSchemaObject {
    private static final long serialVersionUID = 1L;
    private static final String[] EMPTY_STR_ARRAY = new String[0];
    private static final AttributeType[] EMPTY_ATTR_ARRAY = new AttributeType[0];
    private final Registries registries;
    private String objectClassOid;
    private String[] mayUseOids = EMPTY_STR_ARRAY;
    private AttributeType[] mayUse = EMPTY_ATTR_ARRAY;
    private String[] mustUseOids = EMPTY_STR_ARRAY;
    private AttributeType[] mustUse = EMPTY_ATTR_ARRAY;

    public NameFormImpl(String oid, Registries registries) {
        super(oid);
        this.registries = registries;
    }

    public void setMayUseOids(String[] mayUseOids) {
        if (mayUseOids == null) {
            this.mayUse = EMPTY_ATTR_ARRAY;
            this.mayUseOids = EMPTY_STR_ARRAY;
        } else {
            this.mayUse = new AttributeType[mayUseOids.length];
            this.mayUseOids = mayUseOids;
        }
    }

    public AttributeType[] getMayUse() throws NamingException {
        if (this.mayUseOids == null || this.mayUseOids.length == 0) {
            return EMPTY_ATTR_ARRAY;
        }
        for (int ii = 0; ii < this.mayUseOids.length; ++ii) {
            this.mayUse[ii] = this.registries.getAttributeTypeRegistry().lookup(this.mayUseOids[ii]);
        }
        return this.mayUse;
    }

    public void setMustUseOids(String[] mustUseOids) {
        if (mustUseOids == null) {
            this.mustUse = EMPTY_ATTR_ARRAY;
            this.mustUseOids = EMPTY_STR_ARRAY;
        } else {
            this.mustUse = new AttributeType[mustUseOids.length];
            this.mustUseOids = mustUseOids;
        }
    }

    public AttributeType[] getMustUse() throws NamingException {
        if (this.mustUseOids == null || this.mustUseOids.length == 0) {
            return EMPTY_ATTR_ARRAY;
        }
        for (int ii = 0; ii < this.mustUseOids.length; ++ii) {
            this.mustUse[ii] = this.registries.getAttributeTypeRegistry().lookup(this.mustUseOids[ii]);
        }
        return this.mustUse;
    }

    public void setObjectClassOid(String objectClassOid) {
        this.objectClassOid = objectClassOid;
    }

    public ObjectClass getObjectClass() throws NamingException {
        return this.registries.getObjectClassRegistry().lookup(this.objectClassOid);
    }

    public void setDescription(String description) {
        super.setDescription(description);
    }

    public void setObsolete(boolean obsolete) {
        super.setObsolete(obsolete);
    }

    public void setNames(String[] names) {
        super.setNames(names);
    }

    public void setSchema(String schema) {
        super.setSchema(schema);
    }
}

