/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.invocation.Invocation;
import org.apache.directory.server.core.invocation.InvocationStack;
import org.apache.directory.server.core.jndi.ServerLdapContext;
import org.apache.directory.server.core.schema.DescriptionParsers;
import org.apache.directory.server.core.schema.MetaAttributeTypeHandler;
import org.apache.directory.server.core.schema.MetaComparatorHandler;
import org.apache.directory.server.core.schema.MetaDitContentRuleHandler;
import org.apache.directory.server.core.schema.MetaDitStructureRuleHandler;
import org.apache.directory.server.core.schema.MetaMatchingRuleHandler;
import org.apache.directory.server.core.schema.MetaMatchingRuleUseHandler;
import org.apache.directory.server.core.schema.MetaNameFormHandler;
import org.apache.directory.server.core.schema.MetaNormalizerHandler;
import org.apache.directory.server.core.schema.MetaObjectClassHandler;
import org.apache.directory.server.core.schema.MetaSchemaHandler;
import org.apache.directory.server.core.schema.MetaSyntaxCheckerHandler;
import org.apache.directory.server.core.schema.MetaSyntaxHandler;
import org.apache.directory.server.core.schema.PartitionSchemaLoader;
import org.apache.directory.server.core.schema.SchemaChangeHandler;
import org.apache.directory.server.core.schema.SchemaPartitionDao;
import org.apache.directory.server.core.schema.SchemaSubentryModifier;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.ObjectClassRegistry;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.NotImplementedException;
import org.apache.directory.shared.ldap.exception.LdapInvalidNameException;
import org.apache.directory.shared.ldap.exception.LdapNamingException;
import org.apache.directory.shared.ldap.exception.LdapOperationNotSupportedException;
import org.apache.directory.shared.ldap.message.AttributeImpl;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.DITContentRule;
import org.apache.directory.shared.ldap.schema.DITStructureRule;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.MatchingRuleUse;
import org.apache.directory.shared.ldap.schema.NameForm;
import org.apache.directory.shared.ldap.schema.ObjectClass;
import org.apache.directory.shared.ldap.schema.SchemaObject;
import org.apache.directory.shared.ldap.schema.Syntax;
import org.apache.directory.shared.ldap.schema.syntax.AbstractSchemaDescription;
import org.apache.directory.shared.ldap.schema.syntax.ComparatorDescription;
import org.apache.directory.shared.ldap.schema.syntax.NormalizerDescription;
import org.apache.directory.shared.ldap.schema.syntax.SyntaxCheckerDescription;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.apache.directory.shared.ldap.util.DateUtils;

public class SchemaManager {
    private static final int COMPARATOR_INDEX = 0;
    private static final int NORMALIZER_INDEX = 1;
    private static final int SYNTAX_CHECKER_INDEX = 2;
    private static final int SYNTAX_INDEX = 3;
    private static final int MATCHING_RULE_INDEX = 4;
    private static final int ATTRIBUTE_TYPE_INDEX = 5;
    private static final int OBJECT_CLASS_INDEX = 6;
    private static final int MATCHING_RULE_USE_INDEX = 7;
    private static final int DIT_STRUCTURE_RULE_INDEX = 8;
    private static final int DIT_CONTENT_RULE_INDEX = 9;
    private static final int NAME_FORM_INDEX = 10;
    private static final Set<String> VALID_OU_VALUES = new HashSet<String>();
    private static final String[] opAttrs = new String[]{"comparators", "normalizers", "syntaxCheckers", "ldapSyntaxes", "matchingRules", "attributeTypes", "objectClasses", "matchingRuleUse", "ditStructureRules", "ditContentRules", "nameForms"};
    private static final String[] metaObjectClasses = new String[]{"metaComparator", "metaNormalizer", "metaSyntaxChecker", "metaSyntax", "metaMatchingRule", "metaAttributeType", "metaObjectClass", "metaMatchingRuleUse", "metaDITStructureRule", "metaDITContentRule", "metaNameForm"};
    private static final Collection<String> SCHEMA_MODIFICATION_ATTRIBUTES_UPDATE_BYPASS;
    private final PartitionSchemaLoader loader;
    private final MetaSchemaHandler metaSchemaHandler;
    private final Registries globalRegistries;
    private final AttributeType objectClassAT;
    private final SchemaSubentryModifier subentryModifier;
    private final SchemaChangeHandler[] schemaObjectHandlers = new SchemaChangeHandler[11];
    private final String comparatorsOid;
    private final String normalizersOid;
    private final String syntaxCheckersOid;
    private final String ldapSyntaxesOid;
    private final String matchingRulesOid;
    private final String attributeTypesOid;
    private final String objectClassesOid;
    private final String matchingRuleUseOid;
    private final String nameFormsOid;
    private final String ditContentRulesOid;
    private final String ditStructureRulesOid;
    private final DescriptionParsers parsers;
    private final Map<String, SchemaChangeHandler> opAttr2handlerMap = new HashMap<String, SchemaChangeHandler>();
    private final Map<String, SchemaChangeHandler> objectClass2handlerMap = new HashMap<String, SchemaChangeHandler>();
    private final Map<String, Integer> opAttr2handlerIndex = new HashMap<String, Integer>(11);

    public SchemaManager(Registries globalRegistries, PartitionSchemaLoader loader, SchemaPartitionDao dao) throws NamingException {
        this.loader = loader;
        this.globalRegistries = globalRegistries;
        this.objectClassAT = this.globalRegistries.getAttributeTypeRegistry().lookup("objectClass");
        this.metaSchemaHandler = new MetaSchemaHandler(this.globalRegistries, this.loader);
        this.schemaObjectHandlers[0] = new MetaComparatorHandler(globalRegistries, loader);
        this.schemaObjectHandlers[1] = new MetaNormalizerHandler(globalRegistries, loader);
        this.schemaObjectHandlers[2] = new MetaSyntaxCheckerHandler(globalRegistries, loader);
        this.schemaObjectHandlers[3] = new MetaSyntaxHandler(globalRegistries, loader, dao);
        this.schemaObjectHandlers[4] = new MetaMatchingRuleHandler(globalRegistries, loader, dao);
        this.schemaObjectHandlers[5] = new MetaAttributeTypeHandler(globalRegistries, loader, dao);
        this.schemaObjectHandlers[6] = new MetaObjectClassHandler(globalRegistries, loader, dao);
        this.schemaObjectHandlers[7] = new MetaMatchingRuleUseHandler(globalRegistries, loader);
        this.schemaObjectHandlers[8] = new MetaDitStructureRuleHandler(globalRegistries, loader);
        this.schemaObjectHandlers[9] = new MetaDitContentRuleHandler(globalRegistries, loader);
        this.schemaObjectHandlers[10] = new MetaNameFormHandler(globalRegistries, loader);
        this.subentryModifier = new SchemaSubentryModifier(dao);
        this.parsers = new DescriptionParsers(globalRegistries, dao);
        OidRegistry oidRegistry = globalRegistries.getOidRegistry();
        this.comparatorsOid = oidRegistry.getOid("comparators");
        this.opAttr2handlerIndex.put(this.comparatorsOid, new Integer(0));
        this.normalizersOid = oidRegistry.getOid("normalizers");
        this.opAttr2handlerIndex.put(this.normalizersOid, new Integer(1));
        this.syntaxCheckersOid = oidRegistry.getOid("syntaxCheckers");
        this.opAttr2handlerIndex.put(this.syntaxCheckersOid, new Integer(2));
        this.ldapSyntaxesOid = oidRegistry.getOid("ldapSyntaxes");
        this.opAttr2handlerIndex.put(this.ldapSyntaxesOid, new Integer(3));
        this.matchingRulesOid = oidRegistry.getOid("matchingRules");
        this.opAttr2handlerIndex.put(this.matchingRulesOid, new Integer(4));
        this.attributeTypesOid = oidRegistry.getOid("attributeTypes");
        this.opAttr2handlerIndex.put(this.attributeTypesOid, new Integer(5));
        this.objectClassesOid = oidRegistry.getOid("objectClasses");
        this.opAttr2handlerIndex.put(this.objectClassesOid, new Integer(6));
        this.matchingRuleUseOid = oidRegistry.getOid("matchingRuleUse");
        this.opAttr2handlerIndex.put(this.matchingRuleUseOid, new Integer(7));
        this.ditStructureRulesOid = oidRegistry.getOid("ditStructureRules");
        this.opAttr2handlerIndex.put(this.ditStructureRulesOid, new Integer(8));
        this.ditContentRulesOid = oidRegistry.getOid("ditContentRules");
        this.opAttr2handlerIndex.put(this.ditContentRulesOid, new Integer(9));
        this.nameFormsOid = oidRegistry.getOid("nameForms");
        this.opAttr2handlerIndex.put(this.nameFormsOid, new Integer(10));
        this.initHandlerMaps();
    }

    private void initHandlerMaps() throws NamingException {
        AttributeTypeRegistry atReg = this.globalRegistries.getAttributeTypeRegistry();
        for (int ii = 0; ii < opAttrs.length; ++ii) {
            AttributeType at = atReg.lookup(opAttrs[ii]);
            this.opAttr2handlerMap.put(at.getOid(), this.schemaObjectHandlers[ii]);
        }
        ObjectClassRegistry ocReg = this.globalRegistries.getObjectClassRegistry();
        for (int ii = 0; ii < metaObjectClasses.length; ++ii) {
            ObjectClass oc = ocReg.lookup(metaObjectClasses[ii]);
            this.objectClass2handlerMap.put(oc.getOid(), this.schemaObjectHandlers[ii]);
        }
    }

    public Registries getGlobalRegistries() {
        return this.globalRegistries;
    }

    public Registries getRegistries(LdapDN dn) throws NamingException {
        throw new NotImplementedException();
    }

    public void add(LdapDN name, Attributes entry) throws NamingException {
        Attribute oc = AttributeUtils.getAttribute((Attributes)entry, (AttributeType)this.objectClassAT);
        for (int ii = 0; ii < oc.size(); ++ii) {
            String oid = this.globalRegistries.getOidRegistry().getOid((String)oc.get(ii));
            if (!this.objectClass2handlerMap.containsKey(oid)) continue;
            SchemaChangeHandler handler = this.objectClass2handlerMap.get(oid);
            handler.add(name, entry);
            this.updateSchemaModificationAttributes();
            return;
        }
        if (AttributeUtils.containsValue((Attribute)oc, (Object)"metaSchema", (AttributeType)this.objectClassAT)) {
            this.metaSchemaHandler.add(name, entry);
            this.updateSchemaModificationAttributes();
            return;
        }
        if (AttributeUtils.containsValue((Attribute)oc, (Object)"organizationalUnit", (AttributeType)this.objectClassAT)) {
            if (name.size() != 3) {
                throw new LdapInvalidNameException("Schema entity containers of objectClass organizationalUnit should be 3 name components in length.", ResultCodeEnum.NAMING_VIOLATION);
            }
            String ouValue = (String)name.getRdn().getValue();
            if (!VALID_OU_VALUES.contains(ouValue = ouValue.trim().toLowerCase())) {
                throw new LdapInvalidNameException("Expecting organizationalUnit with one of the following names: " + VALID_OU_VALUES, ResultCodeEnum.NAMING_VIOLATION);
            }
            return;
        }
        throw new LdapOperationNotSupportedException(ResultCodeEnum.UNWILLING_TO_PERFORM);
    }

    public void delete(LdapDN name, Attributes entry, boolean doCascadeDelete) throws NamingException {
        Attribute oc = AttributeUtils.getAttribute((Attributes)entry, (AttributeType)this.objectClassAT);
        for (int ii = 0; ii < oc.size(); ++ii) {
            String oid = this.globalRegistries.getOidRegistry().getOid((String)oc.get(ii));
            if (!this.objectClass2handlerMap.containsKey(oid)) continue;
            SchemaChangeHandler handler = this.objectClass2handlerMap.get(oid);
            handler.delete(name, entry, doCascadeDelete);
            this.updateSchemaModificationAttributes();
            return;
        }
        if (AttributeUtils.containsValue((Attribute)oc, (Object)"metaSchema", (AttributeType)this.objectClassAT)) {
            this.metaSchemaHandler.delete(name, entry, doCascadeDelete);
            this.updateSchemaModificationAttributes();
            return;
        }
        if (AttributeUtils.containsValue((Attribute)oc, (Object)"organizationalUnit", (AttributeType)this.objectClassAT)) {
            if (name.size() != 3) {
                throw new LdapNamingException("Only schema entity containers of objectClass organizationalUnit with 3 name components in length can be deleted.", ResultCodeEnum.UNWILLING_TO_PERFORM);
            }
            String ouValue = (String)name.getRdn().getValue();
            if (!VALID_OU_VALUES.contains(ouValue = ouValue.trim().toLowerCase())) {
                throw new LdapInvalidNameException("Can only delete organizationalUnit entity containers with one of the following names: " + VALID_OU_VALUES, ResultCodeEnum.NAMING_VIOLATION);
            }
            return;
        }
        throw new LdapOperationNotSupportedException(ResultCodeEnum.UNWILLING_TO_PERFORM);
    }

    public void modify(LdapDN name, int modOp, Attributes mods, Attributes entry, Attributes targetEntry, boolean cascade) throws NamingException {
        Attribute oc = AttributeUtils.getAttribute((Attributes)entry, (AttributeType)this.objectClassAT);
        for (int ii = 0; ii < oc.size(); ++ii) {
            String oid = this.globalRegistries.getOidRegistry().getOid((String)oc.get(ii));
            if (!this.objectClass2handlerMap.containsKey(oid)) continue;
            SchemaChangeHandler handler = this.objectClass2handlerMap.get(oid);
            handler.modify(name, modOp, mods, entry, targetEntry, cascade);
            this.updateSchemaModificationAttributes();
            return;
        }
        if (AttributeUtils.containsValue((Attribute)oc, (Object)"metaSchema", (AttributeType)this.objectClassAT)) {
            this.metaSchemaHandler.modify(name, modOp, mods, entry, targetEntry, cascade);
            this.updateSchemaModificationAttributes();
            return;
        }
        throw new LdapOperationNotSupportedException(ResultCodeEnum.UNWILLING_TO_PERFORM);
    }

    public void modify(LdapDN name, ModificationItemImpl[] mods, Attributes entry, Attributes targetEntry, boolean doCascadeModify) throws NamingException {
        Attribute oc = AttributeUtils.getAttribute((Attributes)entry, (AttributeType)this.objectClassAT);
        for (int ii = 0; ii < oc.size(); ++ii) {
            String oid = this.globalRegistries.getOidRegistry().getOid((String)oc.get(ii));
            if (!this.objectClass2handlerMap.containsKey(oid)) continue;
            SchemaChangeHandler handler = this.objectClass2handlerMap.get(oid);
            handler.modify(name, mods, entry, targetEntry, doCascadeModify);
            this.updateSchemaModificationAttributes();
            return;
        }
        if (AttributeUtils.containsValue((Attribute)oc, (Object)"metaSchema", (AttributeType)this.objectClassAT)) {
            this.metaSchemaHandler.modify(name, mods, entry, targetEntry, doCascadeModify);
            this.updateSchemaModificationAttributes();
            return;
        }
        throw new LdapOperationNotSupportedException(ResultCodeEnum.UNWILLING_TO_PERFORM);
    }

    public void modifyRn(LdapDN name, String newRdn, boolean deleteOldRn, Attributes entry, boolean doCascadeModify) throws NamingException {
        Attribute oc = AttributeUtils.getAttribute((Attributes)entry, (AttributeType)this.objectClassAT);
        for (int ii = 0; ii < oc.size(); ++ii) {
            String oid = this.globalRegistries.getOidRegistry().getOid((String)oc.get(ii));
            if (!this.objectClass2handlerMap.containsKey(oid)) continue;
            SchemaChangeHandler handler = this.objectClass2handlerMap.get(oid);
            handler.rename(name, entry, newRdn, doCascadeModify);
            this.updateSchemaModificationAttributes();
            return;
        }
        if (AttributeUtils.containsValue((Attribute)oc, (Object)"metaSchema", (AttributeType)this.objectClassAT)) {
            this.metaSchemaHandler.rename(name, entry, newRdn, doCascadeModify);
            this.updateSchemaModificationAttributes();
            return;
        }
        throw new LdapOperationNotSupportedException(ResultCodeEnum.UNWILLING_TO_PERFORM);
    }

    public void replace(LdapDN oriChildName, LdapDN newParentName, Attributes entry, boolean cascade) throws NamingException {
        Attribute oc = AttributeUtils.getAttribute((Attributes)entry, (AttributeType)this.objectClassAT);
        for (int ii = 0; ii < oc.size(); ++ii) {
            String oid = this.globalRegistries.getOidRegistry().getOid((String)oc.get(ii));
            if (!this.objectClass2handlerMap.containsKey(oid)) continue;
            SchemaChangeHandler handler = this.objectClass2handlerMap.get(oid);
            handler.replace(oriChildName, newParentName, entry, cascade);
            this.updateSchemaModificationAttributes();
            return;
        }
        if (AttributeUtils.containsValue((Attribute)oc, (Object)"metaSchema", (AttributeType)this.objectClassAT)) {
            this.metaSchemaHandler.replace(oriChildName, newParentName, entry, cascade);
            this.updateSchemaModificationAttributes();
            return;
        }
        throw new LdapOperationNotSupportedException(ResultCodeEnum.UNWILLING_TO_PERFORM);
    }

    public void move(LdapDN oriChildName, LdapDN newParentName, String newRn, boolean deleteOldRn, Attributes entry, boolean cascade) throws NamingException {
        Attribute oc = AttributeUtils.getAttribute((Attributes)entry, (AttributeType)this.objectClassAT);
        for (int ii = 0; ii < oc.size(); ++ii) {
            String oid = this.globalRegistries.getOidRegistry().getOid((String)oc.get(ii));
            if (!this.objectClass2handlerMap.containsKey(oid)) continue;
            SchemaChangeHandler handler = this.objectClass2handlerMap.get(oid);
            handler.move(oriChildName, newParentName, newRn, deleteOldRn, entry, cascade);
            this.updateSchemaModificationAttributes();
            return;
        }
        if (AttributeUtils.containsValue((Attribute)oc, (Object)"metaSchema", (AttributeType)this.objectClassAT)) {
            this.metaSchemaHandler.move(oriChildName, newParentName, newRn, deleteOldRn, entry, cascade);
            this.updateSchemaModificationAttributes();
            return;
        }
        throw new LdapOperationNotSupportedException(ResultCodeEnum.UNWILLING_TO_PERFORM);
    }

    public void modifySchemaSubentry(LdapDN name, ModificationItemImpl[] mods, Attributes subentry, Attributes targetSubentry, boolean doCascadeModify) throws NamingException {
        block5: for (ModificationItemImpl mod : mods) {
            String opAttrOid = this.globalRegistries.getOidRegistry().getOid(mod.getAttribute().getID());
            switch (mod.getModificationOp()) {
                case 1: {
                    this.modifyAddOperation(opAttrOid, mod.getAttribute(), doCascadeModify);
                    continue block5;
                }
                case 3: {
                    this.modifyRemoveOperation(opAttrOid, mod.getAttribute(), doCascadeModify);
                    continue block5;
                }
                case 2: {
                    throw new LdapOperationNotSupportedException("Modify REPLACE operations on schema subentries are not allowed: it's just silly to destroy and recreate so many \nschema entities that reside in schema operational attributes.  Instead use \na targeted combination of modify ADD and REMOVE operations.", ResultCodeEnum.UNWILLING_TO_PERFORM);
                }
                default: {
                    throw new IllegalStateException("Undefined modify operation: " + mod.getModificationOp());
                }
            }
        }
        if (mods != null || mods.length > 0) {
            this.updateSchemaModificationAttributes();
        }
    }

    public void modifySchemaSubentry(LdapDN name, int modOp, Attributes mods, Attributes subentry, Attributes targetSubentry, boolean doCascadeModify) throws NamingException {
        NamingEnumeration<String> ids = mods.getIDs();
        switch (modOp) {
            case 1: {
                while (ids.hasMore()) {
                    String id = ids.next();
                    AttributeType opAttrAT = this.globalRegistries.getAttributeTypeRegistry().lookup(id);
                    this.modifyAddOperation(opAttrAT.getOid(), AttributeUtils.getAttribute((Attributes)mods, (AttributeType)opAttrAT), doCascadeModify);
                }
                break;
            }
            case 3: {
                while (ids.hasMore()) {
                    String id = ids.next();
                    AttributeType opAttrAT = this.globalRegistries.getAttributeTypeRegistry().lookup(id);
                    this.modifyRemoveOperation(opAttrAT.getOid(), AttributeUtils.getAttribute((Attributes)mods, (AttributeType)opAttrAT), doCascadeModify);
                }
                break;
            }
            case 2: {
                throw new LdapOperationNotSupportedException("Modify REPLACE operations on schema subentries are not allowed: it's just silly to destroy and recreate so many \nschema entities that reside in schema operational attributes.  Instead use \na targeted combination of modify ADD and REMOVE operations.", ResultCodeEnum.UNWILLING_TO_PERFORM);
            }
            default: {
                throw new IllegalStateException("Undefined modify operation: " + modOp);
            }
        }
        this.updateSchemaModificationAttributes();
    }

    public String getSchema(AbstractSchemaDescription desc) {
        if (desc.getExtensions().containsKey("X-SCHEMA")) {
            return (String)((List)desc.getExtensions().get("X-SCHEMA")).get(0);
        }
        return "other";
    }

    private void modifyRemoveOperation(String opAttrOid, Attribute mods, boolean doCascadeModify) throws NamingException {
        int index = this.opAttr2handlerIndex.get(opAttrOid);
        SchemaChangeHandler handler = this.opAttr2handlerMap.get(opAttrOid);
        switch (index) {
            case 0: {
                ComparatorDescription[] comparatorDescriptions;
                MetaComparatorHandler comparatorHandler = (MetaComparatorHandler)handler;
                for (ComparatorDescription comparatorDescription : comparatorDescriptions = this.parsers.parseComparators(mods)) {
                    comparatorHandler.delete(comparatorDescription.getNumericOid(), doCascadeModify);
                    this.subentryModifier.delete(comparatorDescription);
                }
                break;
            }
            case 1: {
                NormalizerDescription[] normalizerDescriptions;
                MetaNormalizerHandler normalizerHandler = (MetaNormalizerHandler)handler;
                for (NormalizerDescription normalizerDescription : normalizerDescriptions = this.parsers.parseNormalizers(mods)) {
                    normalizerHandler.delete(normalizerDescription.getNumericOid(), doCascadeModify);
                    this.subentryModifier.delete(normalizerDescription);
                }
                break;
            }
            case 2: {
                SyntaxCheckerDescription[] syntaxCheckerDescriptions;
                MetaSyntaxCheckerHandler syntaxCheckerHandler = (MetaSyntaxCheckerHandler)handler;
                for (SyntaxCheckerDescription syntaxCheckerDescription : syntaxCheckerDescriptions = this.parsers.parseSyntaxCheckers(mods)) {
                    syntaxCheckerHandler.delete(syntaxCheckerDescription.getNumericOid(), doCascadeModify);
                    this.subentryModifier.delete(syntaxCheckerDescription);
                }
                break;
            }
            case 3: {
                Syntax[] syntaxes;
                MetaSyntaxHandler syntaxHandler = (MetaSyntaxHandler)handler;
                for (Syntax syntax : syntaxes = this.parsers.parseSyntaxes(mods)) {
                    syntaxHandler.delete(syntax, doCascadeModify);
                    this.subentryModifier.deleteSchemaObject((SchemaObject)syntax);
                }
                break;
            }
            case 4: {
                MatchingRule[] mrs;
                MetaMatchingRuleHandler matchingRuleHandler = (MetaMatchingRuleHandler)handler;
                for (MatchingRule mr : mrs = this.parsers.parseMatchingRules(mods)) {
                    matchingRuleHandler.delete(mr, doCascadeModify);
                    this.subentryModifier.deleteSchemaObject((SchemaObject)mr);
                }
                break;
            }
            case 5: {
                AttributeType[] ats;
                MetaAttributeTypeHandler atHandler = (MetaAttributeTypeHandler)handler;
                for (AttributeType at : ats = this.parsers.parseAttributeTypes(mods)) {
                    atHandler.delete(at, doCascadeModify);
                    this.subentryModifier.deleteSchemaObject((SchemaObject)at);
                }
                break;
            }
            case 6: {
                ObjectClass[] ocs;
                MetaObjectClassHandler ocHandler = (MetaObjectClassHandler)handler;
                for (ObjectClass oc : ocs = this.parsers.parseObjectClasses(mods)) {
                    ocHandler.delete(oc, doCascadeModify);
                    this.subentryModifier.deleteSchemaObject((SchemaObject)oc);
                }
                break;
            }
            case 7: {
                MatchingRuleUse[] mrus;
                MetaMatchingRuleUseHandler mruHandler = (MetaMatchingRuleUseHandler)handler;
                for (MatchingRuleUse mru : mrus = this.parsers.parseMatchingRuleUses(mods)) {
                    mruHandler.delete(mru, doCascadeModify);
                    this.subentryModifier.deleteSchemaObject((SchemaObject)mru);
                }
                break;
            }
            case 8: {
                DITStructureRule[] dsrs;
                MetaDitStructureRuleHandler dsrHandler = (MetaDitStructureRuleHandler)handler;
                for (DITStructureRule dsr : dsrs = this.parsers.parseDitStructureRules(mods)) {
                    dsrHandler.delete(dsr, doCascadeModify);
                    this.subentryModifier.deleteSchemaObject((SchemaObject)dsr);
                }
                break;
            }
            case 9: {
                DITContentRule[] dcrs;
                MetaDitContentRuleHandler dcrHandler = (MetaDitContentRuleHandler)handler;
                for (DITContentRule dcr : dcrs = this.parsers.parseDitContentRules(mods)) {
                    dcrHandler.delete(dcr, doCascadeModify);
                    this.subentryModifier.deleteSchemaObject((SchemaObject)dcr);
                }
                break;
            }
            case 10: {
                NameForm[] nfs;
                MetaNameFormHandler nfHandler = (MetaNameFormHandler)handler;
                for (NameForm nf : nfs = this.parsers.parseNameForms(mods)) {
                    nfHandler.delete(nf, doCascadeModify);
                    this.subentryModifier.deleteSchemaObject((SchemaObject)nf);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unknown index into handler array: " + index);
            }
        }
    }

    private void modifyAddOperation(String opAttrOid, Attribute mods, boolean doCascadeModify) throws NamingException {
        int index = this.opAttr2handlerIndex.get(opAttrOid);
        SchemaChangeHandler handler = this.opAttr2handlerMap.get(opAttrOid);
        switch (index) {
            case 0: {
                ComparatorDescription[] comparatorDescriptions;
                MetaComparatorHandler comparatorHandler = (MetaComparatorHandler)handler;
                for (ComparatorDescription comparatorDescription : comparatorDescriptions = this.parsers.parseComparators(mods)) {
                    comparatorHandler.add(comparatorDescription);
                    this.subentryModifier.add(comparatorDescription);
                }
                break;
            }
            case 1: {
                NormalizerDescription[] normalizerDescriptions;
                MetaNormalizerHandler normalizerHandler = (MetaNormalizerHandler)handler;
                for (NormalizerDescription normalizerDescription : normalizerDescriptions = this.parsers.parseNormalizers(mods)) {
                    normalizerHandler.add(normalizerDescription);
                    this.subentryModifier.add(normalizerDescription);
                }
                break;
            }
            case 2: {
                SyntaxCheckerDescription[] syntaxCheckerDescriptions;
                MetaSyntaxCheckerHandler syntaxCheckerHandler = (MetaSyntaxCheckerHandler)handler;
                for (SyntaxCheckerDescription syntaxCheckerDescription : syntaxCheckerDescriptions = this.parsers.parseSyntaxCheckers(mods)) {
                    syntaxCheckerHandler.add(syntaxCheckerDescription);
                    this.subentryModifier.add(syntaxCheckerDescription);
                }
                break;
            }
            case 3: {
                Syntax[] syntaxes;
                MetaSyntaxHandler syntaxHandler = (MetaSyntaxHandler)handler;
                for (Syntax syntax : syntaxes = this.parsers.parseSyntaxes(mods)) {
                    syntaxHandler.add(syntax);
                    this.subentryModifier.addSchemaObject((SchemaObject)syntax);
                }
                break;
            }
            case 4: {
                MatchingRule[] mrs;
                MetaMatchingRuleHandler matchingRuleHandler = (MetaMatchingRuleHandler)handler;
                for (MatchingRule mr : mrs = this.parsers.parseMatchingRules(mods)) {
                    matchingRuleHandler.add(mr);
                    this.subentryModifier.addSchemaObject((SchemaObject)mr);
                }
                break;
            }
            case 5: {
                AttributeType[] ats;
                MetaAttributeTypeHandler atHandler = (MetaAttributeTypeHandler)handler;
                for (AttributeType at : ats = this.parsers.parseAttributeTypes(mods)) {
                    atHandler.add(at);
                    this.subentryModifier.addSchemaObject((SchemaObject)at);
                }
                break;
            }
            case 6: {
                ObjectClass[] ocs;
                MetaObjectClassHandler ocHandler = (MetaObjectClassHandler)handler;
                for (ObjectClass oc : ocs = this.parsers.parseObjectClasses(mods)) {
                    ocHandler.add(oc);
                    this.subentryModifier.addSchemaObject((SchemaObject)oc);
                }
                break;
            }
            case 7: {
                MatchingRuleUse[] mrus;
                MetaMatchingRuleUseHandler mruHandler = (MetaMatchingRuleUseHandler)handler;
                for (MatchingRuleUse mru : mrus = this.parsers.parseMatchingRuleUses(mods)) {
                    mruHandler.add(mru);
                    this.subentryModifier.addSchemaObject((SchemaObject)mru);
                }
                break;
            }
            case 8: {
                DITStructureRule[] dsrs;
                MetaDitStructureRuleHandler dsrHandler = (MetaDitStructureRuleHandler)handler;
                for (DITStructureRule dsr : dsrs = this.parsers.parseDitStructureRules(mods)) {
                    dsrHandler.add(dsr);
                    this.subentryModifier.addSchemaObject((SchemaObject)dsr);
                }
                break;
            }
            case 9: {
                DITContentRule[] dcrs;
                MetaDitContentRuleHandler dcrHandler = (MetaDitContentRuleHandler)handler;
                for (DITContentRule dcr : dcrs = this.parsers.parseDitContentRules(mods)) {
                    dcrHandler.add(dcr);
                    this.subentryModifier.addSchemaObject((SchemaObject)dcr);
                }
                break;
            }
            case 10: {
                NameForm[] nfs;
                MetaNameFormHandler nfHandler = (MetaNameFormHandler)handler;
                for (NameForm nf : nfs = this.parsers.parseNameForms(mods)) {
                    nfHandler.add(nf);
                    this.subentryModifier.addSchemaObject((SchemaObject)nf);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unknown index into handler array: " + index);
            }
        }
    }

    private void updateSchemaModificationAttributes() throws NamingException {
        Invocation invocation = InvocationStack.getInstance().peek();
        ServerLdapContext ctx = (ServerLdapContext)invocation.getCaller();
        String modifiersName = ctx.getPrincipal().getJndiName().getNormName();
        String modifyTimestamp = DateUtils.getGeneralizedTime();
        ModificationItemImpl[] mods = new ModificationItemImpl[]{new ModificationItemImpl(2, (Attribute)new AttributeImpl("schemaModifyTimestamp", (Object)modifyTimestamp)), new ModificationItemImpl(2, (Attribute)new AttributeImpl("schemaModifiersName", (Object)modifiersName))};
        LdapDN name = new LdapDN("cn=schemaModifications,ou=schema");
        name.normalize(this.globalRegistries.getAttributeTypeRegistry().getNormalizerMapping());
        invocation.getProxy().modify(new ModifyOperationContext(name, mods), SCHEMA_MODIFICATION_ATTRIBUTES_UPDATE_BYPASS);
    }

    static {
        VALID_OU_VALUES.add("normalizers".toLowerCase());
        VALID_OU_VALUES.add("comparators".toLowerCase());
        VALID_OU_VALUES.add("syntaxCheckers".toLowerCase());
        VALID_OU_VALUES.add("syntaxes".toLowerCase());
        VALID_OU_VALUES.add("matchingRules".toLowerCase());
        VALID_OU_VALUES.add("matchingRuleUse".toLowerCase());
        VALID_OU_VALUES.add("attributeTypes".toLowerCase());
        VALID_OU_VALUES.add("objectClasses".toLowerCase());
        VALID_OU_VALUES.add("nameForms".toLowerCase());
        VALID_OU_VALUES.add("ditContentRules".toLowerCase());
        VALID_OU_VALUES.add("ditStructureRules".toLowerCase());
        HashSet<String> set = new HashSet<String>();
        set.add("normalizationService");
        set.add("authenticationService");
        set.add("referralService");
        set.add("authorizationService");
        set.add("defaultAuthorizationService");
        set.add("exceptionService");
        set.add("schemaService");
        set.add("collectiveAttributeService");
        SCHEMA_MODIFICATION_ATTRIBUTES_UPDATE_BYPASS = Collections.unmodifiableCollection(set);
    }
}

