/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.webapp.action.EditorLinkActions;
import org.nuxeo.ecm.webapp.base.InputController;

@Name(value="editorLinkActions")
@Scope(value=ScopeType.CONVERSATION)
public class EditorLinkActionsBean
extends InputController
implements EditorLinkActions,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(EditorLinkActionsBean.class);
    private List<DocumentModel> resultDocuments;
    private boolean hasSearchResults = false;
    private String searchKeywords;
    @In(create=true, required=false)
    private CoreSession documentManager;

    @Override
    public boolean getHasSearchResults() {
        return this.hasSearchResults;
    }

    @Override
    public List<DocumentModel> getSearchDocumentResults() {
        return this.resultDocuments;
    }

    @Override
    public String searchDocuments() throws ClientException {
        log.debug((Object)("Entering searchDocuments with keywords: " + this.searchKeywords));
        this.resultDocuments = null;
        ArrayList<String> constraints = new ArrayList<String>();
        if (this.searchKeywords != null) {
            this.searchKeywords = this.searchKeywords.trim();
            if (this.searchKeywords.length() > 0 && !this.searchKeywords.equals("*")) {
                constraints.add(String.format("ecm:fulltext LIKE '%s'", this.searchKeywords));
            }
        }
        constraints.add("ecm:mixinType != 'Folderish'");
        constraints.add("ecm:mixinType != 'HiddenInNavigation'");
        constraints.add("ecm:isCheckedInVersion = 0");
        String query = String.format("SELECT * FROM Document WHERE %s", StringUtils.join((Object[])constraints.toArray(), (String)" AND "));
        log.debug((Object)("Query: " + query));
        this.resultDocuments = this.documentManager.query(query, 100);
        this.hasSearchResults = !this.resultDocuments.isEmpty();
        log.debug((Object)("query result contains: " + this.resultDocuments.size() + " docs."));
        return "test_popup";
    }

    @Override
    public String getSearchKeywords() {
        return this.searchKeywords;
    }

    @Override
    public void setSearchKeywords(String searchKeywords) {
        this.searchKeywords = searchKeywords;
    }
}

