/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.helpers;

import java.io.Serializable;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.jboss.seam.core.ConversationEntry;
import org.jboss.seam.core.Manager;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;

@Name(value="logoHelper")
@Scope(value=ScopeType.CONVERSATION)
public class LogoHelper
implements Serializable {
    private static final long serialVersionUID = 876540986876L;
    private static final String PAGE_NAME = "/showLogo.faces";
    private static final String DEFAULT_LOGO = "/img/default_logo.gif";
    private static final Log log = LogFactory.getLog(LogoHelper.class);
    @In(value="org.jboss.seam.core.manager")
    public transient Manager conversationManager;
    @In(create=true, required=false)
    transient NavigationContext navigationContext;
    @In(create=true, required=false)
    transient CoreSession documentManager;
    private String lastLogoHolderKey = "";
    private DocumentModel lastLogoHolder;
    private String lastURL = "";
    private String lastMainConversation = "";
    @RequestParameter
    String key;
    @RequestParameter
    String docRef;

    public String getLogoURL() {
        if (this.navigationContext == null || this.navigationContext.getCurrentServerLocation() == null) {
            this.lastLogoHolderKey = "";
            this.lastURL = "";
            return DEFAULT_LOGO;
        }
        DocumentModel ws = this.navigationContext.getCurrentWorkspace();
        return this.getLogoURL(ws);
    }

    public String getDefaultLogoURL() {
        return DEFAULT_LOGO;
    }

    public String getLogoURLFromDocRef(String docRef) {
        if (this.documentManager == null) {
            return DEFAULT_LOGO;
        }
        IdRef ref = new IdRef(docRef);
        try {
            DocumentModel doc = this.documentManager.getDocument((DocumentRef)ref);
            return this.getLogoURL(doc);
        }
        catch (ClientException e) {
            log.error((Object)e);
            return DEFAULT_LOGO;
        }
    }

    public String getLogoURL(DocumentModel doc) {
        String key;
        if (doc == null) {
            return DEFAULT_LOGO;
        }
        try {
            key = doc.getCacheKey();
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
        if (key.equals(this.lastLogoHolderKey)) {
            return this.lastURL;
        }
        Blob blob = LogoHelper.getBlob(doc);
        if (blob == null) {
            return DEFAULT_LOGO;
        }
        this.lastURL = "/showLogo.faces?key=" + key + "&docRef=" + doc.getRef().toString() + '&' + this.getConversationPropagationSuffix();
        try {
            this.lastLogoHolderKey = doc.getCacheKey();
        }
        catch (ClientException e) {
            this.lastLogoHolderKey = null;
        }
        this.lastLogoHolder = doc;
        return this.lastURL;
    }

    private static Blob getBlob(DocumentModel doc) {
        if (doc == null) {
            return null;
        }
        if (doc.hasSchema("file")) {
            try {
                return (Blob)doc.getProperty("file", "content");
            }
            catch (ClientException e) {
                return null;
            }
        }
        return null;
    }

    public String getLogo() {
        Blob imgBlob = null;
        if (this.key != null && this.key.equals(this.lastLogoHolderKey)) {
            imgBlob = LogoHelper.getBlob(this.lastLogoHolder);
        }
        if (imgBlob == null) {
            DocumentModel ob = this.navigationContext.getCurrentWorkspace();
            if (ob == null || !ob.getRef().toString().equals(this.docRef)) {
                IdRef ref = new IdRef(this.docRef);
                try {
                    ob = this.documentManager.getDocument((DocumentRef)ref);
                }
                catch (ClientException e) {
                    log.error((Object)e);
                }
            }
            imgBlob = LogoHelper.getBlob(ob);
        }
        FacesContext context = FacesContext.getCurrentInstance();
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        try {
            if (imgBlob == null || imgBlob.getMimeType() != null && !imgBlob.getMimeType().toLowerCase().startsWith("image")) {
                response.setContentType("image/gif");
                response.sendRedirect(context.getExternalContext().getRequestContextPath() + DEFAULT_LOGO);
                return null;
            }
            response.addHeader("Cache-Control", "max-age=600");
            response.addHeader("Cache-Control", "public");
            response.setContentType(imgBlob.getMimeType());
            response.getOutputStream().write(imgBlob.getByteArray());
            response.getOutputStream().close();
            response.flushBuffer();
            context.responseComplete();
        }
        catch (Exception e) {
            log.error((Object)"error while sending logo: ", (Throwable)e);
        }
        return null;
    }

    private String getLastOrMainConversationId(String cId) {
        if (!cId.startsWith("0NX")) {
            cId = this.lastMainConversation;
        }
        if (this.lastMainConversation == null || this.lastMainConversation.equals("")) {
            cId = "0NXMAIN";
        }
        return cId;
    }

    private String getConversationPropagationSuffix() {
        String suffix = "";
        if (!this.conversationManager.getCurrentConversationEntry().isNested()) {
            String cId = this.conversationManager.getCurrentConversationId();
            cId = this.getLastOrMainConversationId(cId);
            suffix = suffix + this.conversationManager.getConversationIdParameter() + '=' + cId;
        } else {
            ConversationEntry conv = this.conversationManager.getCurrentConversationEntry();
            String convId = (String)conv.getConversationIdStack().get(0);
            convId = this.getLastOrMainConversationId(convId);
            suffix = suffix + this.conversationManager.getConversationIdParameter() + '=' + convId;
        }
        return suffix;
    }
}

