/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.versioning;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.VersionModel;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.facet.VersioningDocument;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.versioning.api.VersionIncEditOptions;
import org.nuxeo.ecm.platform.versioning.api.VersioningActions;
import org.nuxeo.ecm.platform.versioning.api.VersioningManager;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.ecm.webapp.versioning.DocumentVersioning;
import org.nuxeo.ecm.webapp.versioning.VersionInfo;

@Name(value="documentVersioning")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class DocumentVersioningBean
implements DocumentVersioning,
Serializable {
    private static final long serialVersionUID = 75409841629876L;
    private static final Log log = LogFactory.getLog(DocumentVersioningBean.class);
    @In(create=true)
    protected transient ResourcesAccessor resourcesAccessor;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    protected Map<String, String> availableVersioningOptionsMap;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true)
    private transient VersioningManager versioningManager;
    private Boolean rendered;
    private VersioningActions selectedOption;

    @Override
    @Deprecated
    public Collection<VersioningActions> getCurrentItemVersioningOptions() {
        VersionIncEditOptions options = this.getCurrentAvailableVersioningOptions();
        return options == null ? Collections.emptyList() : options.getOptions();
    }

    @Override
    public Collection<VersionModel> getItemVersioningHistory(DocumentModel document) {
        List versions = Collections.emptyList();
        try {
            versions = this.documentManager.getVersionsForDocument(document.getRef());
            for (VersionModel model : versions) {
                DocumentModel ver = this.documentManager.getDocumentWithVersion(document.getRef(), model);
                if (ver == null) continue;
                model.setDescription(((VersioningDocument)ver.getAdapter(VersioningDocument.class)).getVersionLabel());
            }
        }
        catch (ClientException e) {
            log.error((Object)"Error retrieving versioning history ", (Throwable)e);
        }
        return versions;
    }

    @Override
    public Collection<VersionModel> getCurrentItemVersioningHistory() {
        return this.getItemVersioningHistory(this.navigationContext.getCurrentDocument());
    }

    @Override
    @Factory(value="currentDocumentIncrementationRules", scope=ScopeType.EVENT)
    public String factoryForIncrementationRules() {
        return null;
    }

    @Factory(autoCreate=true, value="currentDocumentVersionInfo", scope=ScopeType.EVENT)
    public VersionInfo getCurrentDocumentVersionInfo() throws ClientException {
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        String versionLabel = this.versioningManager.getVersionLabel(doc);
        boolean available = versionLabel != null && versionLabel.length() != 0;
        return new VersionInfo(versionLabel, available);
    }

    @Override
    @Deprecated
    public String getIncRulesResult() {
        return null;
    }

    @Observer(value={"documentSelectionChanged", "documentChanged"}, create=false)
    @BypassInterceptors
    public void resetVersioningOption() {
        this.availableVersioningOptionsMap = null;
        this.selectedOption = null;
        this.rendered = null;
    }

    @Override
    public Map<String, String> getAvailableVersioningOptionsMap() {
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> en : this.getVersioningOptionsMap(doc).entrySet()) {
            map.put(en.getValue(), en.getKey());
        }
        this.availableVersioningOptionsMap = map;
        return this.availableVersioningOptionsMap;
    }

    @Observer(value={"changeableDocumentCreated"}, create=false)
    @BypassInterceptors
    public void resetRenderingStatus() {
        this.rendered = Boolean.FALSE;
    }

    @Override
    public Map<String, String> getVersioningOptionsMap(DocumentModel doc) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        VersionIncEditOptions options = this.getAvailableVersioningOptions(doc);
        if (options != null) {
            for (VersioningActions option : options.getOptions()) {
                String label = "label.versioning.option." + option.toString();
                if (this.resourcesAccessor != null) {
                    label = (String)this.resourcesAccessor.getMessages().get(label);
                }
                map.put(option.name(), label);
            }
        }
        return map;
    }

    private VersionIncEditOptions getCurrentAvailableVersioningOptions() {
        return this.getAvailableVersioningOptions(this.navigationContext.getCurrentDocument());
    }

    private VersionIncEditOptions getAvailableVersioningOptions(DocumentModel doc) {
        try {
            return this.versioningManager.getVersionIncEditOptions(doc);
        }
        catch (ClientException e) {
            log.error((Object)"Error retrieving versioning options ", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getVersionLabel(DocumentModel doc) throws ClientException {
        return this.versioningManager.getVersionLabel(doc);
    }

    @Override
    public String getVersioningOptionInstanceId() {
        if (this.selectedOption == null) {
            VersionIncEditOptions options = this.getCurrentAvailableVersioningOptions();
            if (options != null) {
                this.selectedOption = options.getDefaultVersioningAction();
            }
            if (this.selectedOption == null) {
                this.selectedOption = VersioningActions.ACTION_NO_INCREMENT;
            }
        }
        return this.selectedOption.name();
    }

    @Override
    public void setVersioningOptionInstanceId(String optionId) throws ClientException {
        this.setVersioningOptionInstanceId(this.navigationContext.getCurrentDocument(), optionId);
    }

    @Override
    public void setVersioningOptionInstanceId(DocumentModel docModel, String optionId) throws ClientException {
        if (optionId != null) {
            this.selectedOption = VersioningActions.valueOf((String)optionId);
            this.setVersioningOptionInstanceId(docModel, this.selectedOption);
        }
    }

    @Override
    public void setVersioningOptionInstanceId(DocumentModel docModel, VersioningActions option) throws ClientException {
        Object vo = option == VersioningActions.ACTION_INCREMENT_MAJOR ? VersioningOption.MAJOR : (option == VersioningActions.ACTION_INCREMENT_MINOR ? VersioningOption.MINOR : null);
        docModel.putContextData("VersioningOption", (Serializable)vo);
    }

    @Override
    public void validateOptionSelection(FacesContext context, UIComponent component, Object value) {
        if (value != null) {
            return;
        }
        String bundleName = context.getApplication().getMessageBundle();
        Locale locale = context.getViewRoot().getLocale();
        String msg = I18NUtils.getMessageString((String)bundleName, (String)"error.versioning.none_selected", null, (Locale)locale);
        FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, msg);
        throw new ValidatorException(message);
    }

    @Override
    @Deprecated
    public void setCreateSnapshot(boolean createSnapshot) {
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        doc.putContextData(org.nuxeo.common.collections.ScopeType.REQUEST, "CREATE_SNAPSHOT_ON_SAVE", (Serializable)Boolean.valueOf(createSnapshot));
    }

    @Override
    @Deprecated
    public boolean getCreateSnapshot() throws ClientException {
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        return Boolean.TRUE.equals(doc.getContextData(org.nuxeo.common.collections.ScopeType.REQUEST, "CREATE_SNAPSHOT_ON_SAVE"));
    }

    @Override
    @Deprecated
    public boolean getDefaultCreateSnapshot() throws ClientException {
        return false;
    }

    @Override
    @Deprecated
    public boolean getDisplayCreateSnapshotOption() throws ClientException {
        return false;
    }

    @Override
    @Factory(value="renderVersioningOptionsForCurrentDocument", scope=ScopeType.EVENT)
    public boolean factoryForRenderVersioningOption() {
        return this.getRendered();
    }

    public boolean getRendered() {
        if (this.rendered == null) {
            Map<String, String> options;
            this.rendered = Boolean.FALSE;
            if (this.navigationContext.getCurrentDocument() != null && (options = this.getAvailableVersioningOptionsMap()) != null && options.size() > 1) {
                this.rendered = Boolean.TRUE;
            }
        }
        return this.rendered;
    }

    public void setRendered(Boolean rendered) {
        this.rendered = rendered;
    }
}

