/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.comment.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.DocumentModel;

public class UIComment
implements Comparable,
Serializable {
    private static final long serialVersionUID = 2457051749449691092L;
    private final DocumentModel comment;
    private final UIComment parent;
    private List<UIComment> children;

    public UIComment(UIComment parent, DocumentModel docModel) {
        this.parent = parent;
        this.comment = docModel;
        this.children = new ArrayList<UIComment>();
    }

    public String getId() {
        return this.comment.getId();
    }

    public List<UIComment> getChildren() {
        return this.children;
    }

    public void setChildren(List<UIComment> children) {
        this.children = children;
    }

    public boolean addChild(UIComment child) {
        return this.children.add(child);
    }

    public UIComment getParent() {
        return this.parent;
    }

    public boolean removeChild(UIComment child) {
        return this.children.remove(child);
    }

    public DataModel getDataModel() {
        return new ListDataModel(this.children);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof UIComment)) {
            return false;
        }
        UIComment temp = (UIComment)other;
        return this.comment.getId().equals(temp.comment.getId());
    }

    public int hashCode() {
        return this.comment.getId().hashCode();
    }

    public int compareTo(Object o) {
        Calendar otherDate;
        Calendar myDate;
        if (!(o instanceof UIComment)) {
            return -1;
        }
        DocumentModel other = ((UIComment)o).comment;
        try {
            myDate = (Calendar)this.comment.getProperty("dublincore", "created");
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
        try {
            otherDate = (Calendar)other.getProperty("dublincore", "created");
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
        return myDate.compareTo(otherDate);
    }

    public DocumentModel getComment() {
        return this.comment;
    }
}

