/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.del;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.LdapResponse;

public class DelResponse
extends LdapResponse {
    public int getMessageType() {
        return 8;
    }

    public int computeLength() {
        int ldapResponseLength = super.computeLength();
        return 1 + TLV.getNbBytes((int)ldapResponseLength) + ldapResponseLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)107);
            buffer.put(TLV.getBytes((int)this.getLdapResponseLength()));
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
        return super.encode(buffer);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Del Response\n");
        sb.append(super.toString());
        return sb.toString();
    }
}

