/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.filter;

import java.util.HashMap;
import java.util.Map;
import org.apache.directory.shared.ldap.filter.AssertionEnum;
import org.apache.directory.shared.ldap.filter.ExprNode;

public abstract class AbstractExprNode
implements ExprNode {
    private Map<String, Object> annotations;
    private final AssertionEnum assertionType;

    protected AbstractExprNode(AssertionEnum type) {
        this.assertionType = type;
    }

    public Object get(Object key) {
        if (null == this.annotations) {
            return null;
        }
        return this.annotations.get(key);
    }

    public void set(String key, Object value) {
        if (null == this.annotations) {
            this.annotations = new HashMap<String, Object>(2);
        }
        this.annotations.put(key, value);
    }

    protected Map getAnnotations() {
        return this.annotations;
    }

    public AssertionEnum getAssertionType() {
        return this.assertionType;
    }

    public static final String getOperationString(AssertionEnum assertionType) {
        String opstr = null;
        switch (assertionType) {
            case APPROXIMATE: {
                opstr = "~=";
                break;
            }
            case EQUALITY: {
                opstr = "=";
                break;
            }
            case EXTENSIBLE: {
                opstr = "extensible";
                break;
            }
            case GREATEREQ: {
                opstr = ">=";
                break;
            }
            case LESSEQ: {
                opstr = "<=";
                break;
            }
            case PRESENCE: {
                opstr = "=*";
                break;
            }
            case SUBSTRING: {
                opstr = "=";
                break;
            }
            default: {
                throw new IllegalArgumentException("Attribute value assertion type is undefined.");
            }
        }
        return opstr;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        AbstractExprNode otherExprNode = (AbstractExprNode)other;
        if (otherExprNode.getAssertionType() != this.assertionType) {
            return false;
        }
        Map<String, Object> otherAnnotations = otherExprNode.annotations;
        if (otherAnnotations == this.annotations) {
            return true;
        }
        return null != this.annotations && null != otherAnnotations && ((Object)this.annotations).equals(otherAnnotations);
    }

    public int hashCode() {
        int hash = 7;
        hash = hash * 31 + (this.assertionType == null ? 0 : this.assertionType.hashCode());
        hash = hash * 31 + (this.annotations == null ? 0 : ((Object)this.annotations).hashCode());
        return hash;
    }
}

