/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.subtree;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.subtree.SubtreeSpecification;

public class BaseSubtreeSpecification
implements SubtreeSpecification {
    private final LdapDN base;
    private final Set chopBefore;
    private final Set chopAfter;
    private final int minBaseDistance;
    private final int maxBaseDistance;
    private final ExprNode refinement;

    public BaseSubtreeSpecification() {
        this.base = new LdapDN();
        this.minBaseDistance = 0;
        this.maxBaseDistance = -1;
        this.chopAfter = Collections.EMPTY_SET;
        this.chopBefore = Collections.EMPTY_SET;
        this.refinement = null;
    }

    public BaseSubtreeSpecification(ExprNode refinement) {
        this.base = new LdapDN();
        this.minBaseDistance = 0;
        this.maxBaseDistance = -1;
        this.chopAfter = Collections.EMPTY_SET;
        this.chopBefore = Collections.EMPTY_SET;
        this.refinement = refinement;
    }

    public BaseSubtreeSpecification(LdapDN base) {
        this.base = base;
        this.minBaseDistance = 0;
        this.maxBaseDistance = -1;
        this.chopAfter = Collections.EMPTY_SET;
        this.chopBefore = Collections.EMPTY_SET;
        this.refinement = null;
    }

    public BaseSubtreeSpecification(LdapDN base, int minBaseDistance, int maxBaseDistance, Set chopAfter, Set chopBefore) {
        this(base, minBaseDistance, maxBaseDistance, chopAfter, chopBefore, null);
    }

    public BaseSubtreeSpecification(LdapDN base, int minBaseDistance, int maxBaseDistance, Set chopAfter, Set chopBefore, ExprNode refinement) {
        this.base = base;
        this.minBaseDistance = minBaseDistance;
        this.maxBaseDistance = maxBaseDistance < 0 ? -1 : maxBaseDistance;
        this.chopAfter = chopAfter;
        this.chopBefore = chopBefore;
        this.refinement = refinement;
    }

    public LdapDN getBase() {
        return this.base;
    }

    public Set getChopBeforeExclusions() {
        return this.chopBefore;
    }

    public Set getChopAfterExclusions() {
        return this.chopAfter;
    }

    public int getMinBaseDistance() {
        return this.minBaseDistance;
    }

    public int getMaxBaseDistance() {
        return this.maxBaseDistance;
    }

    public ExprNode getRefinement() {
        return this.refinement;
    }

    public void printToBuffer(StringBuffer buffer) {
        buffer.append('{');
        if (!this.base.isEmpty()) {
            buffer.append(' ');
            buffer.append("base");
            buffer.append(' ');
            buffer.append('\"');
            buffer.append(this.base.getUpName());
            buffer.append('\"');
            buffer.append(',');
        }
        if (this.minBaseDistance > 0) {
            buffer.append(' ');
            buffer.append("minimum");
            buffer.append(' ');
            buffer.append(this.minBaseDistance);
            buffer.append(',');
        }
        if (this.maxBaseDistance > -1) {
            buffer.append(' ');
            buffer.append("maximum");
            buffer.append(' ');
            buffer.append(this.maxBaseDistance);
            buffer.append(',');
        }
        if (!this.chopBefore.isEmpty() || !this.chopAfter.isEmpty()) {
            LdapDN dn;
            buffer.append(' ');
            buffer.append("specificExclusions");
            buffer.append(' ');
            buffer.append('{');
            Iterator it = this.chopBefore.iterator();
            while (it.hasNext()) {
                dn = (LdapDN)it.next();
                buffer.append(' ');
                buffer.append("chopBefore");
                buffer.append(':');
                buffer.append(' ');
                buffer.append('\"');
                buffer.append(dn.getUpName());
                buffer.append('\"');
                if (!it.hasNext()) continue;
                buffer.append(',');
                buffer.append(' ');
            }
            if (!this.chopBefore.isEmpty() && !this.chopAfter.isEmpty()) {
                buffer.append(',');
                buffer.append(' ');
            }
            it = this.chopAfter.iterator();
            while (it.hasNext()) {
                dn = (LdapDN)it.next();
                buffer.append(' ');
                buffer.append("chopAfter");
                buffer.append(':');
                buffer.append(' ');
                buffer.append('\"');
                buffer.append(dn.getUpName());
                buffer.append('\"');
                if (!it.hasNext()) continue;
                buffer.append(',');
                buffer.append(' ');
            }
            buffer.append(' ');
            buffer.append('}');
            buffer.append(',');
        }
        if (this.refinement != null) {
            buffer.append(' ');
            buffer.append("specificationFilter");
            buffer.append(' ');
            try {
                StringBuffer tempBuffer = new StringBuffer();
                this.refinement.printRefinementToBuffer(tempBuffer);
                buffer.append(tempBuffer);
            }
            catch (UnsupportedOperationException e) {
                this.refinement.printToBuffer(buffer);
            }
            buffer.append(',');
        }
        if (buffer.charAt(buffer.length() - 1) == ',') {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        buffer.append(' ');
        buffer.append('}');
    }
}

