/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.osgi.util.jar;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.jar.JarFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.osgi.util.jar.URLClassLoaderCloser;

public class JarFileFactoryCloser {
    private static final Log log = LogFactory.getLog(JarFileFactoryCloser.class);
    protected Object factory;
    protected Method factoryGetMethod;
    protected Method factoryCloseMethod;

    public JarFileFactoryCloser() {
        try {
            this.introspectClasses();
        }
        catch (Exception e) {
            log.error((Object)"Cannot introspect jar file factory class", (Throwable)e);
            this.factory = null;
        }
    }

    protected void introspectClasses() throws ClassNotFoundException, SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException, NoSuchMethodException {
        Class<?> jarURLConnectionClass = JarFileFactoryCloser.loadClass("sun.net.www.protocol.jar.JarURLConnection");
        Field jarFileFactoryField = jarURLConnectionClass.getDeclaredField("factory");
        jarFileFactoryField.setAccessible(true);
        this.factory = jarFileFactoryField.get(null);
        Class<?> factoryClass = JarFileFactoryCloser.loadClass("sun.net.www.protocol.jar.JarFileFactory");
        this.factoryGetMethod = factoryClass.getMethod("get", URL.class);
        this.factoryGetMethod.setAccessible(true);
        this.factoryCloseMethod = factoryClass.getMethod("close", JarFile.class);
        this.factoryCloseMethod.setAccessible(true);
    }

    protected static Class<?> loadClass(String name) throws ClassNotFoundException {
        return URLClassLoaderCloser.class.getClassLoader().loadClass(name);
    }

    public void close(URL location) throws IOException {
        if (this.factory == null) {
            return;
        }
        JarFile jar = null;
        try {
            jar = (JarFile)this.factoryGetMethod.invoke(this.factory, location);
            this.factoryCloseMethod.invoke(this.factory, jar);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot use reflection on jar file factory", e);
        }
        jar.close();
    }
}

