/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.localconfiguration.simple;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.localconfiguration.AbstractLocalConfiguration;
import org.nuxeo.ecm.platform.localconfiguration.simple.SimpleConfiguration;

public class SimpleConfigurationAdapter
extends AbstractLocalConfiguration<SimpleConfiguration>
implements SimpleConfiguration {
    private static final Log log = LogFactory.getLog(SimpleConfigurationAdapter.class);
    protected DocumentModel detachedDocument;
    protected Map<String, String> parameters;

    public SimpleConfigurationAdapter(DocumentModel doc) {
        this.loadFromDocument(doc);
    }

    protected void loadFromDocument(DocumentModel doc) {
        this.detachedDocument = doc;
        this.parameters = this.computeParametersFromDocument(doc);
    }

    protected Map<String, String> computeParametersFromDocument(DocumentModel doc) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        try {
            List parametersFromDocument = (List)((Object)doc.getPropertyValue("sconf:simpleconfigurationparameters"));
            if (parametersFromDocument != null) {
                for (Map parameter : parametersFromDocument) {
                    parameters.put((String)parameter.get("key"), (String)parameter.get("value"));
                }
            }
        }
        catch (ClientException e) {
            log.warn((Object)("Unable to retrieve SimpleConfiguration parameters: " + (Object)((Object)e)));
            log.debug((Object)e, (Throwable)e);
        }
        return parameters;
    }

    @Override
    public String get(String key) {
        return this.get(key, null);
    }

    @Override
    public String get(String key, String defaultValue) {
        String value = this.parameters.get(key);
        return value != null ? value : defaultValue;
    }

    @Override
    public String put(String key, String value) {
        return this.parameters.put(key, value);
    }

    @Override
    public void putAll(Map<String, String> parameters) {
        this.parameters.putAll(parameters);
    }

    public DocumentRef getDocumentRef() {
        return this.detachedDocument.getRef();
    }

    public boolean canMerge() {
        return true;
    }

    public SimpleConfiguration merge(SimpleConfiguration other) {
        if (other == null) {
            return this;
        }
        SimpleConfigurationAdapter adapter = (SimpleConfigurationAdapter)other;
        this.detachedDocument = adapter.detachedDocument;
        for (Map.Entry<String, String> otherParameter : adapter.parameters.entrySet()) {
            if (this.parameters.containsKey(otherParameter.getKey())) continue;
            this.parameters.put(otherParameter.getKey(), otherParameter.getValue());
        }
        return this;
    }

    public void save(CoreSession session) throws ClientException {
        List<Map<String, String>> parametersForDocument = this.computeParametersForDocument(this.parameters);
        this.detachedDocument.setPropertyValue("sconf:simpleconfigurationparameters", (Serializable)((Object)parametersForDocument));
        DocumentModel doc = session.saveDocument(this.detachedDocument);
        session.save();
        this.loadFromDocument(doc);
    }

    protected List<Map<String, String>> computeParametersForDocument(Map<String, String> parameters) {
        ArrayList<Map<String, String>> parametersForDocument = new ArrayList<Map<String, String>>();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            HashMap<String, String> parameter = new HashMap<String, String>();
            parameter.put("key", entry.getKey());
            parameter.put("value", entry.getValue());
            parametersForDocument.add(parameter);
        }
        return parametersForDocument;
    }
}

