/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.model;

import org.nuxeo.runtime.model.Adaptable;
import org.nuxeo.runtime.model.Component;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.Extension;

public class DefaultComponent
implements Component,
Adaptable {
    protected Long lastModified;

    @Override
    public void activate(ComponentContext context) throws Exception {
        this.setModifiedNow();
    }

    @Override
    public void deactivate(ComponentContext context) throws Exception {
        this.setModifiedNow();
    }

    @Override
    public void registerExtension(Extension extension) throws Exception {
        Object[] contribs = extension.getContributions();
        if (contribs == null) {
            return;
        }
        for (Object contrib : contribs) {
            this.registerContribution(contrib, extension.getExtensionPoint(), extension.getComponent());
        }
        this.setModifiedNow();
    }

    @Override
    public void unregisterExtension(Extension extension) throws Exception {
        Object[] contribs = extension.getContributions();
        if (contribs == null) {
            return;
        }
        for (Object contrib : contribs) {
            this.unregisterContribution(contrib, extension.getExtensionPoint(), extension.getComponent());
        }
        this.setModifiedNow();
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        return adapter.cast(this);
    }

    @Override
    public int getApplicationStartedOrder() {
        return 1000;
    }

    @Override
    public void applicationStarted(ComponentContext context) throws Exception {
    }

    protected void setModifiedNow() {
        this.setLastModified(System.currentTimeMillis());
    }

    @Override
    public Long getLastModified() {
        return this.lastModified;
    }

    @Override
    public void setLastModified(Long lastModified) {
        this.lastModified = lastModified;
    }
}

