/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.collections.ListenerList;
import org.nuxeo.runtime.ComponentEvent;
import org.nuxeo.runtime.ComponentListener;
import org.nuxeo.runtime.RuntimeService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentManager;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.Extension;
import org.nuxeo.runtime.model.RegistrationInfo;
import org.nuxeo.runtime.model.impl.ComponentInstanceImpl;
import org.nuxeo.runtime.model.impl.ComponentRegistry;
import org.nuxeo.runtime.model.impl.ExtensionPointImpl;
import org.nuxeo.runtime.model.impl.RegistrationInfoImpl;
import org.nuxeo.runtime.model.impl.ShutdownTask;

public class ComponentManagerImpl
implements ComponentManager {
    private static final Log log = LogFactory.getLog(ComponentManagerImpl.class);
    protected final Map<ComponentName, Set<Extension>> pendingExtensions;
    private ListenerList listeners;
    private final Map<String, RegistrationInfoImpl> services;
    protected Set<String> blacklist;
    protected ComponentRegistry reg = new ComponentRegistry();

    public ComponentManagerImpl(RuntimeService runtime) {
        this.pendingExtensions = new HashMap<ComponentName, Set<Extension>>();
        this.listeners = new ListenerList();
        this.services = new Hashtable<String, RegistrationInfoImpl>();
        this.blacklist = new HashSet<String>();
    }

    @Override
    public synchronized Collection<RegistrationInfo> getRegistrations() {
        return new ArrayList<RegistrationInfo>(this.reg.getComponents());
    }

    @Override
    public synchronized Map<ComponentName, Set<ComponentName>> getPendingRegistrations() {
        return new HashMap<ComponentName, Set<ComponentName>>(this.reg.getPendingComponents());
    }

    public synchronized Collection<ComponentName> getNeededRegistrations() {
        return this.pendingExtensions.keySet();
    }

    public synchronized Collection<Extension> getPendingExtensions(ComponentName name) {
        return this.pendingExtensions.get(name);
    }

    @Override
    public synchronized RegistrationInfo getRegistrationInfo(ComponentName name) {
        return this.reg.getComponent(name);
    }

    @Override
    public synchronized boolean isRegistered(ComponentName name) {
        return this.reg.contains(name);
    }

    @Override
    public synchronized int size() {
        return this.reg.size();
    }

    @Override
    public synchronized ComponentInstance getComponent(ComponentName name) {
        RegistrationInfoImpl ri = this.reg.getComponent(name);
        return ri != null ? ri.getComponent() : null;
    }

    @Override
    public synchronized void shutdown() {
        ShutdownTask.shutdown(this);
        try {
            this.listeners = null;
            this.reg.destroy();
            this.reg = null;
        }
        catch (Exception e) {
            log.error((Object)"Failed to shutdown registry manager");
        }
    }

    @Override
    public Set<String> getBlacklist() {
        return this.blacklist;
    }

    @Override
    public void setBlacklist(Set<String> blacklist) {
        this.blacklist = blacklist;
    }

    @Override
    public synchronized void register(RegistrationInfo regInfo) {
        RegistrationInfoImpl ri = (RegistrationInfoImpl)regInfo;
        ComponentName name = ri.getName();
        if (this.blacklist.contains(name.getName())) {
            log.warn((Object)("Component " + name.getName() + " was blacklisted. Ignoring."));
            return;
        }
        if (this.reg.contains(name)) {
            if (name.getName().startsWith("org.nuxeo.runtime.")) {
                return;
            }
            String msg = "Duplicate component name: " + name;
            log.error((Object)msg);
            Framework.getRuntime().getWarnings().add(msg);
            return;
        }
        for (ComponentName n : ri.getAliases()) {
            if (!this.reg.contains(n)) continue;
            String msg = "Duplicate component name: " + n + " (alias for " + name + ")";
            log.error((Object)msg);
            Framework.getRuntime().getWarnings().add(msg);
            return;
        }
        ri.attach(this);
        try {
            log.info((Object)("Registering component: " + name));
            if (!this.reg.addComponent(ri)) {
                log.info((Object)("Registration delayed for component: " + name + ". Waiting for: " + this.reg.getMissingDependencies(ri.getName())));
            }
        }
        catch (Throwable e) {
            String msg = "Failed to register component: " + name;
            log.error((Object)msg, e);
            msg = msg + " (" + e.toString() + ')';
            Framework.getRuntime().getWarnings().add(msg);
            return;
        }
    }

    @Override
    public synchronized void unregister(RegistrationInfo regInfo) {
        this.unregister(regInfo.getName());
    }

    @Override
    public synchronized void unregister(ComponentName name) {
        try {
            log.info((Object)("Unregistering component: " + name));
            this.reg.removeComponent(name);
        }
        catch (Throwable e) {
            log.error((Object)("Failed to unregister component: " + name), e);
        }
    }

    @Override
    public void addComponentListener(ComponentListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeComponentListener(ComponentListener listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    public synchronized ComponentInstance getComponentProvidingService(Class<?> serviceClass) {
        try {
            RegistrationInfoImpl ri = this.services.get(serviceClass.getName());
            if (ri != null) {
                if (!ri.isActivated()) {
                    if (ri.isResolved()) {
                        ri.activate();
                    } else {
                        if (!serviceClass.getSimpleName().equals("TypeProvider")) {
                            log.debug((Object)("The component exposing the service " + serviceClass + " is not resolved"));
                        }
                        return null;
                    }
                }
                return ri.getComponent();
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to get service: " + serviceClass));
        }
        return null;
    }

    @Override
    public <T> T getService(Class<T> serviceClass) {
        ComponentInstance comp = this.getComponentProvidingService(serviceClass);
        return comp != null ? (T)comp.getAdapter(serviceClass) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ComponentName> getActivatingRegistrations() {
        RegistrationInfoImpl[] comps = null;
        ComponentManagerImpl componentManagerImpl = this;
        synchronized (componentManagerImpl) {
            comps = this.reg.getComponentsArray();
        }
        ArrayList<ComponentName> activating = new ArrayList<ComponentName>();
        for (RegistrationInfoImpl ri : comps) {
            if (ri.getState() != 4) continue;
            activating.add(ri.getName());
        }
        return activating;
    }

    void sendEvent(ComponentEvent event) {
        Object[] listeners;
        log.debug((Object)("Dispatching event: " + event));
        for (Object listener : listeners = this.listeners.getListeners()) {
            ((ComponentListener)listener).handleEvent(event);
        }
    }

    public synchronized void registerExtension(Extension extension) throws Exception {
        ComponentName name = extension.getTargetComponent();
        RegistrationInfoImpl ri = this.reg.getComponent(name);
        if (ri != null && ri.component != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Register contributed extension: " + extension));
            }
            ComponentManagerImpl.loadContributions(ri, extension);
            ri.component.registerExtension(extension);
            this.sendEvent(new ComponentEvent(9, ((ComponentInstanceImpl)extension.getComponent()).ri, extension));
        } else {
            Set<Extension> extensions;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Enqueue contributed extension to pending queue: " + extension));
            }
            if ((extensions = this.pendingExtensions.get(name)) == null) {
                extensions = new LinkedHashSet<Extension>();
                this.pendingExtensions.put(name, extensions);
            }
            extensions.add(extension);
            this.sendEvent(new ComponentEvent(11, ((ComponentInstanceImpl)extension.getComponent()).ri, extension));
        }
    }

    public synchronized void unregisterExtension(Extension extension) throws Exception {
        ComponentName name;
        RegistrationInfoImpl ri;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unregister contributed extension: " + extension));
        }
        if ((ri = this.reg.getComponent(name = extension.getTargetComponent())) != null) {
            ComponentInstance co = ri.getComponent();
            if (co != null) {
                co.unregisterExtension(extension);
            }
        } else {
            Set<Extension> extensions = this.pendingExtensions.get(name);
            if (extensions != null) {
                extensions.remove(name);
                if (extensions.isEmpty()) {
                    this.pendingExtensions.remove(name);
                }
            }
        }
        this.sendEvent(new ComponentEvent(10, ((ComponentInstanceImpl)extension.getComponent()).ri, extension));
    }

    public static void loadContributions(RegistrationInfoImpl ri, Extension xt) {
        ExtensionPointImpl xp = ri.getExtensionPoint(xt.getExtensionPoint());
        if (xp != null && xp.contributions != null) {
            try {
                Object[] contribs = xp.loadContributions(ri, xt);
                xt.setContributions(contribs);
            }
            catch (Exception e) {
                log.error((Object)"Failed to create contribution objects", (Throwable)e);
            }
        }
    }

    public synchronized void registerServices(RegistrationInfoImpl ri) {
        if (ri.serviceDescriptor == null) {
            return;
        }
        for (String service : ri.serviceDescriptor.services) {
            log.info((Object)("Registering service: " + service));
            this.services.put(service, ri);
        }
    }

    public synchronized void unregisterServices(RegistrationInfoImpl ri) {
        if (ri.serviceDescriptor == null) {
            return;
        }
        for (String service : ri.serviceDescriptor.services) {
            this.services.remove(service);
        }
    }

    @Override
    public synchronized String[] getServices() {
        return this.services.keySet().toArray(new String[this.services.size()]);
    }
}

