/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.impl.server;

import java.util.Collections;
import java.util.List;
import org.apache.chemistry.opencmis.commons.data.CmisExtensionElement;
import org.apache.chemistry.opencmis.commons.data.PropertyBoolean;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.PropertyId;
import org.apache.chemistry.opencmis.commons.data.PropertyString;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.nuxeo.ecm.core.api.DocumentModel;

public abstract class NuxeoPropertyDataBase<T>
implements PropertyData<T> {
    protected final PropertyDefinition<T> propertyDefinition;
    protected final DocumentModel doc;

    public NuxeoPropertyDataBase(PropertyDefinition<T> propertyDefinition, DocumentModel doc) {
        this.propertyDefinition = propertyDefinition;
        this.doc = doc;
    }

    public PropertyDefinition<T> getPropertyDefinition() {
        return this.propertyDefinition;
    }

    public String getId() {
        return this.propertyDefinition.getId();
    }

    public String getLocalName() {
        return this.propertyDefinition.getLocalName();
    }

    public String getDisplayName() {
        return this.propertyDefinition.getDisplayName();
    }

    public String getQueryName() {
        return this.propertyDefinition.getQueryName();
    }

    public <U> U getValue() {
        return (U)this.getFirstValue();
    }

    public abstract T getFirstValue();

    public List<T> getValues() {
        T v = this.getFirstValue();
        return v == null ? Collections.emptyList() : Collections.singletonList(v);
    }

    public void setValue(Object value) {
        Object old = null;
        if (value == null && old == null) {
            return;
        }
        if (value != null && value.equals(old)) {
            return;
        }
        throw new CmisConstraintException("Read-only property: " + this.propertyDefinition.getId());
    }

    public List<CmisExtensionElement> getExtensions() {
        return null;
    }

    public void setExtensions(List<CmisExtensionElement> extensions) {
        throw new UnsupportedOperationException();
    }

    public static class NuxeoPropertyBooleanDataFixed
    extends NuxeoPropertyDataFixed<Boolean>
    implements PropertyBoolean {
        protected NuxeoPropertyBooleanDataFixed(PropertyDefinition<Boolean> propertyDefinition, Boolean value) {
            super(propertyDefinition, value);
        }
    }

    public static class NuxeoPropertyStringDataFixed
    extends NuxeoPropertyDataFixed<String>
    implements PropertyString {
        protected NuxeoPropertyStringDataFixed(PropertyDefinition<String> propertyDefinition, String value) {
            super(propertyDefinition, value);
        }
    }

    public static class NuxeoPropertyIdMultiDataFixed
    extends NuxeoPropertyMultiDataFixed<String>
    implements PropertyId {
        protected NuxeoPropertyIdMultiDataFixed(PropertyDefinition<String> propertyDefinition, List<String> value) {
            super(propertyDefinition, value);
        }
    }

    public static class NuxeoPropertyIdDataFixed
    extends NuxeoPropertyDataFixed<String>
    implements PropertyId {
        protected NuxeoPropertyIdDataFixed(PropertyDefinition<String> propertyDefinition, String value) {
            super(propertyDefinition, value);
        }
    }

    public static abstract class NuxeoPropertyMultiDataFixed<T>
    extends NuxeoPropertyDataBase<T> {
        protected final List<T> value;

        protected NuxeoPropertyMultiDataFixed(PropertyDefinition<T> propertyDefinition, List<T> value) {
            super(propertyDefinition, null);
            this.value = value;
        }

        @Override
        public <U> U getValue() {
            return (U)this.getValues();
        }

        @Override
        public T getFirstValue() {
            return this.value.size() == 0 ? null : (T)this.value.get(0);
        }

        @Override
        public List<T> getValues() {
            return this.value;
        }
    }

    public static abstract class NuxeoPropertyDataFixed<T>
    extends NuxeoPropertyDataBase<T> {
        protected final T value;

        protected NuxeoPropertyDataFixed(PropertyDefinition<T> propertyDefinition, T value) {
            super(propertyDefinition, null);
            this.value = value;
        }

        @Override
        public T getFirstValue() {
            return this.value;
        }
    }
}

