/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.cudf.metadata;

import org.eclipse.equinox.p2.cudf.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.cudf.metadata.IRequiredCapability;
import org.eclipse.equinox.p2.cudf.metadata.Version;
import org.eclipse.equinox.p2.cudf.solver.Projector;

public class InstallableUnit
extends Projector.AbstractVariable
implements Comparable<InstallableUnit> {
    public static final IProvidedCapability[] NO_PROVIDES = new IProvidedCapability[0];
    public static final IRequiredCapability[] NO_REQUIRES = new IRequiredCapability[0];
    public static final String NAMESPACE_IU_ID = "org.eclipse.equinox.p2.iu";
    private String id;
    private Version version;
    IProvidedCapability[] providedCapabilities = NO_PROVIDES;
    private IRequiredCapability[] requires = NO_REQUIRES;
    private boolean singleton;
    private boolean installed;
    private long sumProperty;

    @Override
    public int compareTo(InstallableUnit other) {
        if (this.id.compareTo(other.getId()) == 0) {
            return this.version.compareTo(other.getVersion());
        }
        return this.id.compareTo(other.getId());
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof InstallableUnit)) {
            return false;
        }
        InstallableUnit other = (InstallableUnit)obj;
        if (this.id == null && other.getId() != null || this.id != null && !this.id.equals(other.getId())) {
            return false;
        }
        if (this.version == null) {
            return other.getVersion() == null;
        }
        return this.version.equals(other.getVersion());
    }

    public IProvidedCapability[] getProvidedCapabilities() {
        return this.providedCapabilities;
    }

    public IRequiredCapability[] getRequiredCapabilities() {
        return this.requires;
    }

    public Version getVersion() {
        return this.version;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        return result;
    }

    public boolean isResolved() {
        return false;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public void setCapabilities(IProvidedCapability[] newCapabilities) {
        this.providedCapabilities = newCapabilities == null || newCapabilities.length == 0 ? NO_PROVIDES : newCapabilities;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setRequiredCapabilities(IRequiredCapability[] capabilities) {
        this.requires = capabilities.length == 0 ? NO_REQUIRES : (IRequiredCapability[])capabilities.clone();
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public void setVersion(Version newVersion) {
        this.version = newVersion != null ? newVersion : Version.emptyVersion;
    }

    @Override
    public String toString() {
        return this.id + ' ' + this.getVersion();
    }

    public void setInstalled(boolean isInstalled) {
        this.installed = isInstalled;
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public long getSumProperty() {
        return this.sumProperty;
    }

    public void setSumProperty(long sumProperty) {
        this.sumProperty = sumProperty;
    }
}

