/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.client.status;

import java.util.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.connect.client.status.SubscriptionStatusWrapper;
import org.nuxeo.connect.client.status.UnresgistedSubscriptionStatusWrapper;
import org.nuxeo.connect.connector.CanNotReachConnectServer;
import org.nuxeo.connect.connector.ConnectClientVersionMismatchError;
import org.nuxeo.connect.connector.ConnectSecurityError;
import org.nuxeo.connect.connector.ConnectServerError;
import org.nuxeo.connect.registration.ConnectRegistrationService;
import org.nuxeo.runtime.api.Framework;

public class ConnectStatusHolder {
    protected static ConnectStatusHolder instance;
    protected SubscriptionStatusWrapper instanceStatus;
    protected static final Log log;
    protected static final int REFRESH_PERIOD_MINUTES = 10;

    public static ConnectStatusHolder instance() {
        if (instance == null) {
            instance = new ConnectStatusHolder();
        }
        return instance;
    }

    protected ConnectRegistrationService getService() {
        return (ConnectRegistrationService)Framework.getLocalService(ConnectRegistrationService.class);
    }

    public boolean isRegistred() {
        return this.getService().isInstanceRegistred();
    }

    public SubscriptionStatusWrapper getStatus() {
        SubscriptionStatusWrapper refreshStatus;
        SubscriptionStatusWrapper lastStatus = this.getStatus(false);
        Calendar oldestStatusDate = Calendar.getInstance();
        oldestStatusDate.add(12, -10);
        if (!(lastStatus != null && !lastStatus.refreshDate.before(oldestStatusDate) || (refreshStatus = this.getStatus(true)) != null && !refreshStatus.isError() || lastStatus == null || lastStatus.isError())) {
            this.instanceStatus = lastStatus;
            this.instanceStatus.refreshDate = Calendar.getInstance();
        }
        return this.instanceStatus;
    }

    public void flush() {
        this.instanceStatus = null;
    }

    public SubscriptionStatusWrapper getStatus(boolean forceRefresh) {
        if (this.instanceStatus == null || forceRefresh) {
            if (this.isRegistred()) {
                try {
                    this.instanceStatus = new SubscriptionStatusWrapper(this.getService().getConnector().getConnectStatus());
                }
                catch (CanNotReachConnectServer e) {
                    log.warn((Object)"can not reach connect server", (Throwable)e);
                    this.instanceStatus = new SubscriptionStatusWrapper("Nuxeo Connect Server is not reachable");
                    this.instanceStatus.canNotReachConnectServer = true;
                }
                catch (ConnectClientVersionMismatchError e) {
                    log.warn((Object)"Connect Client does not have the required version to communicate with Nuxeo Connect Server", (Throwable)e);
                    this.instanceStatus = new SubscriptionStatusWrapper(e.getMessage());
                    this.instanceStatus.versionMismatch = true;
                }
                catch (ConnectSecurityError e) {
                    log.warn((Object)"Can not authenticated against Connect Server", (Throwable)e);
                    this.instanceStatus = new SubscriptionStatusWrapper(e);
                }
                catch (ConnectServerError e) {
                    log.error((Object)"Error while calling connect server", (Throwable)e);
                    this.instanceStatus = new SubscriptionStatusWrapper(e.getMessage());
                }
            } else {
                this.instanceStatus = new UnresgistedSubscriptionStatusWrapper();
            }
        }
        return this.instanceStatus;
    }

    static {
        log = LogFactory.getLog(ConnectStatusHolder.class);
    }
}

