/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.admin.repo;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.admin.repo.RepoStat;
import org.nuxeo.ecm.admin.repo.RepoStatInfo;
import org.nuxeo.ecm.admin.repo.StatsTaskRunner;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class StatsTask
implements Runnable {
    protected static final Log log = LogFactory.getLog(StatsTask.class);
    private final DocumentRef rootDocRef;
    protected final boolean includeBlob;
    protected final RepoStat cmdInstance;
    protected final String repositoryName;

    public StatsTask(String repoName, DocumentRef rootDocRef, boolean includeBlob, RepoStat instance) throws Exception {
        this.repositoryName = repoName;
        this.rootDocRef = rootDocRef;
        this.includeBlob = includeBlob;
        this.cmdInstance = instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        StatsTaskRunner runner = new StatsTaskRunner(this.repositoryName, this.includeBlob, this.rootDocRef, this);
        try {
            TransactionHelper.startTransaction();
            runner.runUnrestricted();
        }
        catch (ClientException e) {
            log.error((Object)"Error while executing StatsTaskRunner", (Throwable)e);
        }
        finally {
            TransactionHelper.commitOrRollbackTransaction();
        }
    }

    public void exec(StatsTask task) {
        this.cmdInstance.exec(task);
    }

    protected StatsTask getNextTask(DocumentModel root) {
        StatsTask newTask;
        if (this.cmdInstance.isPoolFull()) {
            return null;
        }
        try {
            newTask = new StatsTask(this.repositoryName, root.getRef(), this.includeBlob, this.cmdInstance);
        }
        catch (Exception e) {
            log.error((Object)"Unable to start new task", (Throwable)e);
            return null;
        }
        return newTask;
    }

    protected RepoStatInfo getInfo() {
        return this.cmdInstance.getInfo();
    }
}

