/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wss.handlers.fprpc;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.wss.WSSException;
import org.nuxeo.wss.fprpc.FPRPCCall;
import org.nuxeo.wss.fprpc.FPRPCRequest;
import org.nuxeo.wss.fprpc.FPRPCResponse;
import org.nuxeo.wss.handlers.fprpc.FPRPCHandler;
import org.nuxeo.wss.spi.Backend;
import org.nuxeo.wss.spi.WSSBackend;

public abstract class AbstractFPRPCHandler
implements FPRPCHandler {
    private static final Log log = LogFactory.getLog(AbstractFPRPCHandler.class);

    @Override
    public void handleRequest(FPRPCRequest request, FPRPCResponse fpResponse) throws WSSException {
        List<FPRPCCall> calls = request.getCalls();
        if (calls.size() > 1) {
            log.error((Object)"multiple calls not implemented, stopping processing");
            throw new WSSException("multiple calls not implemented ");
        }
        WSSBackend backend = Backend.get(request);
        this.processCall(request, fpResponse, 0, backend);
    }

    protected abstract void processCall(FPRPCRequest var1, FPRPCResponse var2, int var3, WSSBackend var4) throws WSSException;
}

