/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wss.spi;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.wss.WSSConfig;
import org.nuxeo.wss.fm.FreeMarkerRenderer;
import org.nuxeo.wss.servlet.WSSRequest;
import org.nuxeo.wss.spi.WSSBackend;
import org.nuxeo.wss.spi.WSSBackendFactory;
import org.nuxeo.wss.spi.dummy.DummyBackendFactory;

public class Backend {
    protected static WSSBackendFactory factory = null;
    public static final String DEFAULT_FACTORY_CLASS = "org.nuxeo.ecm.platform.wi.backend.wss.WSSBackendFactoryImpl";
    private static final Log log = LogFactory.getLog(Backend.class);

    public static WSSBackendFactory getFactory() {
        if (factory == null && (factory = Backend.loadFactory()) != null) {
            FreeMarkerRenderer.addLoader(factory.getClass());
        }
        return factory;
    }

    protected static synchronized WSSBackendFactory loadFactory() {
        String factoryClass = WSSConfig.instance().getWssBackendFactoryClassName();
        if (factory == null) {
            try {
                factory = (WSSBackendFactory)Class.forName(DEFAULT_FACTORY_CLASS, true, Thread.currentThread().getContextClassLoader()).newInstance();
            }
            catch (Exception e) {
                log.error((Object)"Unable to create default backend factory org.nuxeo.ecm.platform.wi.backend.wss.WSSBackendFactoryImpl", (Throwable)e);
            }
        }
        if (factory == null) {
            factory = new DummyBackendFactory();
        }
        return factory;
    }

    public static WSSBackend get(WSSRequest request) {
        return Backend.getFactory().getBackend(request);
    }
}

