/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.connector;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.nuxeo.connect.NuxeoConnectClient;
import org.nuxeo.connect.connector.ConnectConnector;
import org.nuxeo.connect.connector.ConnectSecurityError;
import org.nuxeo.connect.connector.ConnectServerError;
import org.nuxeo.connect.connector.ConnectServerResponse;
import org.nuxeo.connect.connector.http.ConnectUrlConfig;
import org.nuxeo.connect.data.AbstractJSONSerializableData;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.data.DownloadingPackage;
import org.nuxeo.connect.data.PackageDescriptor;
import org.nuxeo.connect.data.SubscriptionStatus;
import org.nuxeo.connect.downloads.ConnectDownloadManager;
import org.nuxeo.connect.identity.LogicalInstanceIdentifier;
import org.nuxeo.connect.identity.SecurityHeaderGenerator;
import org.nuxeo.connect.update.PackageType;

public abstract class AbstractConnectConnector
implements ConnectConnector {
    public static final String GET_DOWNLOADS_SUFFIX = "getDownloads";
    public static final String GET_DOWNLOAD_SUFFIX = "getDownload";
    public static final String GET_STATUS_SUFFIX = "status";
    public static final String NUXEO_TMP_DIR_PROPERTY = "nuxeo.tmp.dir";
    public static final String CONNECT_CONNECTOR_CACHE_MINUTES_PROPERTY = "org.nuxeo.connect.connector.cache.duration";
    public static final long DEFAULT_CACHE_TIME_MS = 3600000L;
    public static final long DEFAULT_CACHE_TIME_MS_STUDIO = 300000L;
    protected static Log log = LogFactory.getLog(AbstractConnectConnector.class);

    protected String getBaseUrl() {
        if (LogicalInstanceIdentifier.isRegistered()) {
            return ConnectUrlConfig.getRegistredBaseUrl();
        }
        return ConnectUrlConfig.getUnregisteredBaseUrl();
    }

    protected File getCacheFileFor(PackageType type) {
        String connectUrlString = ConnectUrlConfig.getBaseUrl();
        String cacheDir = NuxeoConnectClient.getProperty(NUXEO_TMP_DIR_PROPERTY, System.getProperty("java.io.tmpdir"));
        try {
            URL connectUrl = new URL(connectUrlString);
            String cachePrefix = connectUrl.getHost() + "_";
            int port = connectUrl.getPort();
            if (port == -1) {
                port = connectUrl.getDefaultPort();
            }
            cachePrefix = port == -1 ? cachePrefix + "00_" : cachePrefix + Integer.toString(port) + "_";
            cachePrefix = cachePrefix + connectUrl.getPath().replaceAll("/", "#");
            String cacheFileName = cachePrefix + "_" + (Object)((Object)type) + ".json";
            return new File(cacheDir, cacheFileName);
        }
        catch (MalformedURLException e) {
            String fallbackFileName = connectUrlString + "_" + (Object)((Object)type) + ".json";
            return new File(cacheDir, fallbackFileName);
        }
    }

    @Override
    public void flushCache() {
        for (PackageType type : PackageType.values()) {
            File cacheFile = this.getCacheFileFor(type);
            FileUtils.deleteQuietly((File)cacheFile);
        }
        FileUtils.deleteQuietly((File)this.getCacheFileFor(null));
    }

    protected ConnectServerResponse execCall(String url) throws ConnectServerError {
        return this.execServerCall(url, SecurityHeaderGenerator.getHeaders());
    }

    protected abstract ConnectServerResponse execServerCall(String var1, Map<String, String> var2) throws ConnectServerError;

    @Override
    public SubscriptionStatus getConnectStatus() throws ConnectServerError {
        String url = this.getBaseUrl() + GET_STATUS_SUFFIX;
        ConnectServerResponse response = this.execCall(url);
        String json = response.getString();
        if (json == null) {
            throw new ConnectServerError("null response from server");
        }
        try {
            SubscriptionStatus subscriptionStatus = AbstractJSONSerializableData.loadFromJSON(SubscriptionStatus.class, json);
            return subscriptionStatus;
        }
        catch (Throwable t) {
            throw new ConnectServerError("Unable to parse response: " + json, t);
        }
        finally {
            response.release();
        }
    }

    @Override
    public DownloadingPackage getDownload(String id) throws ConnectServerError {
        try {
            id = URLEncoder.encode(id, "UTF-8");
            id = id.replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e);
        }
        String url = this.getBaseUrl() + GET_DOWNLOAD_SUFFIX + "/" + id;
        ConnectServerResponse response = this.execCall(url);
        String json = response.getString();
        try {
            PackageDescriptor pkg = AbstractJSONSerializableData.loadFromJSON(PackageDescriptor.class, json);
            if (pkg == null || pkg.getId() == null) {
                throw new ConnectSecurityError("Unable to parse server response: package has no id");
            }
            ConnectDownloadManager cdm = NuxeoConnectClient.getDownloadManager();
            DownloadingPackage downloadingPackage = cdm.storeDownloadedBundle(pkg);
            return downloadingPackage;
        }
        catch (JSONException e) {
            throw new ConnectServerError("Unable to parse response", e);
        }
        finally {
            response.release();
        }
    }

    @Override
    public List<DownloadablePackage> getDownloads(PackageType type) throws ConnectServerError {
        ArrayList<DownloadablePackage> result = new ArrayList<DownloadablePackage>();
        String json = null;
        String cacheTimeString = NuxeoConnectClient.getProperty(CONNECT_CONNECTOR_CACHE_MINUTES_PROPERTY, null);
        long cacheMaxAge = cacheTimeString == null ? 3600000L : Long.parseLong(cacheTimeString) * 60L * 1000L;
        if (type == null || type == PackageType.STUDIO) {
            cacheMaxAge = Math.min(cacheMaxAge, 300000L);
        }
        File cacheFile = this.getCacheFileFor(type);
        Date now = new Date();
        if (cacheFile.exists() && now.getTime() - cacheFile.lastModified() < cacheMaxAge) {
            try {
                json = FileUtils.readFileToString((File)cacheFile);
                JSONArray array = new JSONArray(json);
                for (int i = 0; i < array.length(); ++i) {
                    JSONObject ob = (JSONObject)array.get(i);
                    result.add(AbstractJSONSerializableData.loadFromJSON(PackageDescriptor.class, ob));
                }
            }
            catch (IOException e) {
            }
            catch (JSONException e) {
                json = null;
                result = new ArrayList();
            }
        }
        if (json == null) {
            String url = this.getBaseUrl() + GET_DOWNLOADS_SUFFIX + "/" + (Object)((Object)type);
            ConnectServerResponse response = this.execCall(url);
            json = response.getString();
            response.release();
            try {
                JSONArray array = new JSONArray(json);
                for (int i = 0; i < array.length(); ++i) {
                    JSONObject ob = (JSONObject)array.get(i);
                    result.add(AbstractJSONSerializableData.loadFromJSON(PackageDescriptor.class, ob));
                }
            }
            catch (JSONException e) {
                throw new ConnectServerError("Unable to parse response", e);
            }
            try {
                FileUtils.writeStringToFile((File)cacheFile, (String)json);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return result;
    }
}

