/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.html.servlets;

import java.io.IOException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class NegotiationSelector
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String perspective;
        String theme;
        String mode;
        String referrer = request.getHeader("referer");
        if (referrer == null) {
            response.getWriter().write("no referrer found");
            return;
        }
        String engine = request.getParameter("engine");
        if (engine != null) {
            response.addCookie(this.createCookie("nxthemes.engine", engine));
        }
        if ((mode = request.getParameter("mode")) != null) {
            response.addCookie(this.createCookie("nxthemes.mode", mode));
        }
        if ((theme = request.getParameter("theme")) != null) {
            response.addCookie(this.createCookie("nxthemes.theme", theme));
        }
        if ((perspective = request.getParameter("perspective")) != null) {
            response.addCookie(this.createCookie("nxthemes.perspective", perspective));
        }
        response.sendRedirect(referrer);
    }

    private Cookie createCookie(String name, String value) {
        Cookie cookie = new Cookie(name, value);
        if (value.equals("")) {
            cookie.setMaxAge(0);
        }
        cookie.setPath("/");
        return cookie;
    }
}

