/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.binding;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.ui.web.util.ComponentTagUtils;

public class MetaValueExpression
extends ValueExpression
implements Serializable {
    private static final long serialVersionUID = -2721042412903607760L;
    private static final Log log = LogFactory.getLog(MetaValueExpression.class);
    private ValueExpression originalValueExpression;

    public MetaValueExpression(ValueExpression originalValueExpression) {
        this.originalValueExpression = originalValueExpression;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MetaValueExpression)) {
            return false;
        }
        MetaValueExpression other = (MetaValueExpression)obj;
        return this.originalValueExpression.equals((Object)other.originalValueExpression);
    }

    public int hashCode() {
        return this.originalValueExpression.hashCode();
    }

    public String getExpressionString() {
        return this.originalValueExpression.getExpressionString();
    }

    public boolean isLiteralText() {
        return this.originalValueExpression.isLiteralText();
    }

    public Class<?> getExpectedType() {
        return this.originalValueExpression.getExpectedType();
    }

    public Class<?> getType(ELContext context) {
        return this.originalValueExpression.getType(context);
    }

    public Object getValue(ELContext context) {
        Object res = null;
        if (this.originalValueExpression != null && (res = this.originalValueExpression.getValue(context)) instanceof String) {
            String expression = (String)res;
            if (ComponentTagUtils.isValueReference(expression)) {
                FacesContext faces = FacesContext.getCurrentInstance();
                Application app = faces.getApplication();
                ExpressionFactory factory = app.getExpressionFactory();
                ValueExpression newExpr = factory.createValueExpression(context, expression, Object.class);
                try {
                    res = newExpr.getValue(context);
                }
                catch (Exception err) {
                    log.error((Object)String.format("Error processing expression %s: %s", expression, err));
                    res = null;
                }
            } else {
                res = expression;
            }
        }
        return res;
    }

    public boolean isReadOnly(ELContext context) {
        return true;
    }

    public void setValue(ELContext context, Object value) {
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.originalValueExpression = (ValueExpression)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.originalValueExpression);
    }
}

