/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.model.ListDataModel;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.ui.web.component.VariableManager;
import org.nuxeo.ecm.platform.ui.web.directory.SelectItemComparator;

public class UISelectItems
extends javax.faces.component.UISelectItems {
    private static final Log log = LogFactory.getLog(UISelectItems.class);
    public static final String COMPONENT_TYPE = UISelectItems.class.getName();
    protected String var;
    protected Object itemLabel;
    protected Object itemValue;
    protected Boolean itemRendered;
    protected Boolean itemDisabled;
    protected String ordering;
    protected Boolean caseSensitive;

    public String getVar() {
        if (this.var != null) {
            return this.var;
        }
        ValueExpression ve = this.getValueExpression("var");
        if (ve != null) {
            try {
                return (String)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return null;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public Object getItemLabel() {
        if (this.itemLabel != null) {
            return this.itemLabel;
        }
        ValueExpression ve = this.getValueExpression("itemLabel");
        if (ve != null) {
            try {
                return ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return null;
    }

    public void setItemLabel(Object itemLabel) {
        this.itemLabel = itemLabel;
    }

    public Object getItemValue() {
        if (this.itemValue != null) {
            return this.itemValue;
        }
        ValueExpression ve = this.getValueExpression("itemValue");
        if (ve != null) {
            try {
                return ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return null;
    }

    public void setItemValue(Object itemValue) {
        this.itemValue = itemValue;
    }

    protected Boolean getBooleanValue(String name, boolean defaultValue) {
        ValueExpression ve = this.getValueExpression(name);
        if (ve != null) {
            try {
                return !Boolean.FALSE.equals(ve.getValue(this.getFacesContext().getELContext()));
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return defaultValue;
    }

    public Boolean getItemDisabled() {
        if (this.itemDisabled != null) {
            return this.itemDisabled;
        }
        return this.getBooleanValue("itemDisabled", false);
    }

    public void setItemDisabled(Boolean itemDisabled) {
        this.itemDisabled = itemDisabled;
    }

    public Boolean getItemRendered() {
        if (this.itemRendered != null) {
            return this.itemRendered;
        }
        return this.getBooleanValue("itemRendered", true);
    }

    public void setItemRendered(Boolean itemRendered) {
        this.itemRendered = itemRendered;
    }

    public String getOrdering() {
        if (this.ordering != null) {
            return this.ordering;
        }
        ValueExpression ve = this.getValueExpression("ordering");
        if (ve != null) {
            try {
                return (String)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return null;
    }

    public Boolean getCaseSensitive() {
        if (this.caseSensitive != null) {
            return this.caseSensitive;
        }
        return this.getBooleanValue("caseSensitive", false);
    }

    public void setCaseSensitive(Boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public void setOrdering(String ordering) {
        this.ordering = ordering;
    }

    public Object getValue() {
        Object value = super.getValue();
        return this.createSelectItems(value);
    }

    protected final Object saveRequestMapVarValue() {
        String varName = this.getVar();
        return VariableManager.saveRequestMapVarValue(varName);
    }

    protected final void restoreRequestMapVarValue(Object value) {
        String varName = this.getVar();
        VariableManager.restoreRequestMapVarValue(varName, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SelectItem[] createSelectItems(Object value) {
        Object varValue = this.saveRequestMapVarValue();
        try {
            SelectItem[] ldm;
            ArrayList<SelectItem> items = new ArrayList<SelectItem>();
            if (value instanceof ListDataModel) {
                ldm = (SelectItem[])value;
                value = ldm.getWrappedData();
            }
            if (value instanceof SelectItem[]) {
                ldm = (SelectItem[])value;
                return ldm;
            }
            if (value instanceof Object[]) {
                Object[] array;
                for (Object currentItem : array = (Object[])value) {
                    if (currentItem instanceof SelectItemGroup) {
                        SelectItemGroup itemGroup = (SelectItemGroup)currentItem;
                        SelectItem[] itemsFromGroup = itemGroup.getSelectItems();
                        items.addAll(Arrays.asList(itemsFromGroup));
                        continue;
                    }
                    this.putIteratorToRequestParam(currentItem);
                    SelectItem selectItem = this.createSelectItem();
                    this.removeIteratorFromRequestParam();
                    if (selectItem == null) continue;
                    items.add(selectItem);
                }
            } else if (value instanceof Collection) {
                Collection collection = (Collection)value;
                for (Object e : collection) {
                    if (e instanceof SelectItemGroup) {
                        SelectItemGroup itemGroup = (SelectItemGroup)e;
                        SelectItem[] itemsFromGroup = itemGroup.getSelectItems();
                        items.addAll(Arrays.asList(itemsFromGroup));
                        continue;
                    }
                    this.putIteratorToRequestParam(e);
                    SelectItem selectItem = this.createSelectItem();
                    this.removeIteratorFromRequestParam();
                    if (selectItem == null) continue;
                    items.add(selectItem);
                }
            } else if (value instanceof Map) {
                Map map = (Map)value;
                for (Object object : map.entrySet()) {
                    Map.Entry currentItem = (Map.Entry)object;
                    this.putIteratorToRequestParam(currentItem.getValue());
                    SelectItem selectItem = this.createSelectItem();
                    this.removeIteratorFromRequestParam();
                    if (selectItem == null) continue;
                    items.add(selectItem);
                }
            } else if (value != null) {
                log.warn((Object)("Could not map values to select items, value is not supported: " + value));
            }
            String ordering = this.getOrdering();
            Boolean caseSensitive = this.getCaseSensitive();
            if (ordering != null && !"".equals(ordering)) {
                Collections.sort(items, new SelectItemComparator(ordering, caseSensitive));
            }
            SelectItem[] selectItemArray = items.toArray(new SelectItem[0]);
            return selectItemArray;
        }
        finally {
            this.restoreRequestMapVarValue(varValue);
        }
    }

    protected SelectItem createSelectItem() {
        Boolean rendered = this.getItemRendered();
        if (!rendered.booleanValue()) {
            return null;
        }
        Object value = this.getItemValue();
        Object labelObject = this.getItemLabel();
        Boolean disabled = this.getItemDisabled();
        String label = labelObject != null ? labelObject.toString() : null;
        return new SelectItem(value, label, null, !Boolean.FALSE.equals(disabled));
    }

    protected void putIteratorToRequestParam(Object object) {
        String var = this.getVar();
        VariableManager.putVariableToRequestParam(var, object);
    }

    protected void removeIteratorFromRequestParam() {
        String var = this.getVar();
        VariableManager.removeVariableFromRequestParam(var);
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.var, this.itemLabel, this.itemValue, this.itemDisabled, this.itemRendered, this.ordering, this.caseSensitive};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.var = (String)values[1];
        this.itemLabel = values[2];
        this.itemValue = values[3];
        this.itemDisabled = (Boolean)values[4];
        this.itemRendered = (Boolean)values[5];
        this.ordering = (String)values[6];
        this.caseSensitive = (Boolean)values[7];
    }
}

