/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.multipart;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.faces.context.FacesContext;
import org.nuxeo.ecm.platform.ui.web.multipart.MultipartRequest;

class MultipartRequestRegistry {
    private final AtomicInteger atomicInteger = new AtomicInteger(0);
    private final String registryId = UUID.randomUUID().toString();
    private final Map<String, MultipartRequest> requestsMap = new ConcurrentHashMap<String, MultipartRequest>();
    private static final String REGISTRY_ATTRIBUTE_NAME = MultipartRequestRegistry.class.getName();

    private MultipartRequestRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MultipartRequestRegistry getInstance(FacesContext context) {
        Map applicationMap = context.getExternalContext().getApplicationMap();
        MultipartRequestRegistry requestRegistry = (MultipartRequestRegistry)applicationMap.get(REGISTRY_ATTRIBUTE_NAME);
        if (requestRegistry == null) {
            Map map = applicationMap;
            synchronized (map) {
                requestRegistry = (MultipartRequestRegistry)applicationMap.get(REGISTRY_ATTRIBUTE_NAME);
                if (requestRegistry == null) {
                    requestRegistry = new MultipartRequestRegistry();
                    applicationMap.put(REGISTRY_ATTRIBUTE_NAME, requestRegistry);
                }
            }
        }
        return requestRegistry;
    }

    public String registerRequest(MultipartRequest request) {
        String key = this.registryId + ":" + this.atomicInteger.incrementAndGet();
        this.requestsMap.put(key, request);
        return key;
    }

    public void removeRequest(String key) {
        this.requestsMap.remove(key);
    }

    public MultipartRequest getRequest(String key) {
        return this.requestsMap.get(key);
    }
}

