/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.renderer;

import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.ImageRenderer;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import javax.faces.component.UIComponent;
import javax.faces.component.UIGraphic;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.lang.StringUtils;

public class NXImageRenderer
extends ImageRenderer {
    protected static final String[] ATTRIBUTES = new String[]{"alt", "dir", "lang", "longdesc", "onclick", "ondblclick", "onkeydown", "onkeypress", "onkeyup", "onmousedown", "onmousemove", "onmouseout", "onmouseover", "onmouseup", "style", "title", "usemap"};
    public static final String RENDERER_TYPE = "javax.faces.NXImage";

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        String src = NXImageRenderer.src(context, component);
        if (StringUtils.isBlank((String)src)) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Do not render empty img tag with empty src value for component " + component.getId());
            }
        } else {
            writer.startElement("img", component);
            this.writeIdAttributeIfNecessary(context, writer, component);
            writer.writeURIAttribute("src", (Object)src, "value");
            Map attrs = component.getAttributes();
            if (writer.getContentType().equals("application/xhtml+xml") && null == attrs.get("alt")) {
                writer.writeAttribute("alt", (Object)"", "alt");
            }
            RenderKitUtils.renderPassThruAttributes((ResponseWriter)writer, (UIComponent)component, (String[])ATTRIBUTES);
            String width = (String)attrs.get("width");
            String height = (String)attrs.get("height");
            if (!StringUtils.isBlank((String)width)) {
                writer.writeAttribute("width", (Object)width, "width");
            }
            if (!StringUtils.isBlank((String)height)) {
                writer.writeAttribute("height", (Object)height, "height");
            }
            RenderKitUtils.renderXHTMLStyleBooleanAttributes((ResponseWriter)writer, (UIComponent)component);
            String styleClass = (String)attrs.get("styleClass");
            if (!StringUtils.isBlank((String)styleClass)) {
                writer.writeAttribute("class", (Object)styleClass, "styleClass");
            }
            writer.endElement("img");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "End encoding component " + component.getId());
        }
    }

    protected static String src(FacesContext context, UIComponent component) {
        String value = (String)((UIGraphic)component).getValue();
        if (value == null) {
            return "";
        }
        value = context.getApplication().getViewHandler().getResourceURL(context, value);
        return context.getExternalContext().encodeResourceURL(value);
    }
}

