/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.rest;

import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.NavigationHandler;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.contexts.Contexts;
import org.nuxeo.ecm.platform.ui.web.rest.RestHelper;
import org.nuxeo.ecm.platform.ui.web.rest.api.URLPolicyService;
import org.nuxeo.ecm.platform.ui.web.util.BaseURL;
import org.nuxeo.runtime.api.Framework;

public class FancyNavigationHandler
extends NavigationHandler {
    private static final Log log = LogFactory.getLog(FancyNavigationHandler.class);
    private final NavigationHandler baseNavigationHandler;

    public FancyNavigationHandler(NavigationHandler navigationHandler) {
        this.baseNavigationHandler = navigationHandler;
    }

    public void handleNavigation(FacesContext context, String fromAction, String outcome) {
        Map map;
        boolean ajaxRequest;
        boolean rootChanged;
        ExternalContext eContext = context.getExternalContext();
        HttpServletRequest httpRequest = (HttpServletRequest)eContext.getRequest();
        httpRequest.setAttribute("PostOutcome", (Object)outcome);
        URLPolicyService pservice = null;
        try {
            pservice = (URLPolicyService)Framework.getService(URLPolicyService.class);
            pservice.appendParametersToRequest(context);
        }
        catch (Exception e) {
            log.error((Object)"error occured while appending params to request: ", (Throwable)e);
        }
        UIViewRoot oldRoot = context.getViewRoot();
        this.baseNavigationHandler.handleNavigation(context, fromAction, outcome);
        UIViewRoot newRoot = context.getViewRoot();
        boolean bl = rootChanged = !oldRoot.equals(newRoot);
        if (outcome != null && !context.getResponseComplete() && !rootChanged && pservice != null && Framework.isDevModeSet()) {
            this.handleHotReloadNavigation(pservice, context, fromAction, outcome);
        }
        boolean bl2 = ajaxRequest = (map = eContext.getRequestParameterMap()) != null && map.containsKey("AJAXREQUEST");
        if (outcome == null && !ajaxRequest && !context.getResponseComplete()) {
            String url = httpRequest.getRequestURL().toString();
            String localUrl = BaseURL.getServerURL((ServletRequest)httpRequest, true);
            String baseUrl = BaseURL.getServerURL((ServletRequest)httpRequest, false);
            if (localUrl != null && !localUrl.equals(baseUrl)) {
                url = url.replaceFirst(localUrl, baseUrl);
            }
            if (Contexts.isEventContextActive()) {
                url = RestHelper.addMainConversationParameters(url);
            }
            try {
                eContext.redirect(url);
            }
            catch (IOException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }

    protected void handleHotReloadNavigation(URLPolicyService pservice, FacesContext context, String fromAction, String outcome) {
        String viewId = pservice.getViewIdFromOutcome(outcome, null);
        ExternalContext extContext = context.getExternalContext();
        if (viewId != null) {
            ViewHandler viewHandler = Util.getViewHandler((FacesContext)context);
            String newPath = viewHandler.getActionURL(context, viewId);
            try {
                extContext.redirect(extContext.encodeActionURL(newPath));
            }
            catch (IOException ioe) {
                throw new FacesException(ioe.getMessage(), (Throwable)ioe);
            }
            context.responseComplete();
        }
    }
}

